#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include "lxt.h"

extern boolean xp_fullredraw;

int
xplabel_idef_proc(p, pi)
/*
   Internal function.
   Initialize defaults for a label item.
*/
Panel *p;
Panel_item *pi;
{
	return(LX_SUCCESS);
}

int
xplabel_dst_proc(pi)
/*
   Internal function.
   Destroys a label item.
*/
Panel_item *pi;
{
	return(LX_SUCCESS);
}

int
xplabel_sz_proc(p, pi)
Panel *p;
Panel_item *pi;
/*
   Internal function.
   Sizes a label item.
*/
{
	if (p == (Panel *) NULL) {
		(void) fprintf(stderr, "xplabel_sz_proc: null panel\n");
		return(LX_ERROR);
	}
	if (pi == (Panel_item *) NULL) {
		(void) fprintf(stderr, "xplabel_sz_proc: null item\n");
		return(LX_ERROR);
	}

	pi->xpi_w= pi->xpi_h= 0;
	if (pi->xpi_image != (XImage *) NULL) {
		pi->xpi_w= pi->xpi_image->width;
		pi->xpi_h= pi->xpi_image->height;
	}
	else if (pi->xpi_str != (char *) NULL) {
		pi->xpi_w= XTextWidth(pi->xpi_font, pi->xpi_str, strlen(pi->xpi_str));
		pi->xpi_h= pi->xpi_font->max_bounds.ascent+pi->xpi_font->max_bounds.descent;
	}
	return(LX_SUCCESS);
}

void
xplabel_drw_proc(p, pi)
/*
   Internal function.
   Plots a label item onto the backing store.
*/
Panel *p;
Panel_item *pi;
{
	int y;

	if (!xp_fullredraw)
		XFillRectangle(p->xp_dpy, p->xp_ppm, pi->xpi_cgc, pi->xpi_x, pi->xpi_y, pi->xpi_w, pi->xpi_h);
	if (pi->xpi_state == LXPI_INACTIVE)
		return;

	/* attempt to draw xpi_image */
	if (pi->xpi_image != (XImage *) NULL) {
		XPutImage(p->xp_dpy, p->xp_ppm, pi->xpi_gc, pi->xpi_image, 0, 0, pi->xpi_x, pi->xpi_y, pi->xpi_image->width, pi->xpi_image->height);
		return;
	}

	if (pi->xpi_str == (char *) NULL)
		return;
	if (strlen(pi->xpi_str) == 0)
		return;

	y= pi->xpi_y+pi->xpi_font->max_bounds.ascent;
	XDrawString(p->xp_dpy, p->xp_ppm, pi->xpi_gc, pi->xpi_x, y, pi->xpi_str, strlen(pi->xpi_str));
	return;
}
