#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include "lxt.h"

extern Panel *xp_panels;
extern Panelitem_dispatch panelitem_proctab[];

extern Panel *xp_blocked;
extern boolean alert_buttonactive;
extern int alert_xwarp, alert_ywarp;

boolean xp_fullredraw;
boolean xp_usrresize= FALSE;
int xp_confx, xp_confy;
int xp_confw, xp_confh;

boolean
panel_event(evt)
/*
    Internal function.
    Checks if the event is a panel event
    and processes it if so.
*/
XEvent *evt;
{
	XAnyEvent *xa;
	Panel *p;
	void panel_win_evt(), panel_pwin_evt();
	void panel_vswin_evt(), panel_hswin_evt();

	xa= (XAnyEvent *) evt;
	for (p= xp_panels; p != (Panel *) NULL; p= p->xp_next) {
		if (!(p->xp_flags & LXP_PANELVISIBLE))
			continue;

		if (xa->window == p->xp_win) {
			panel_win_evt(p, evt);
			return(TRUE);
		}
		else if (xa->window == p->xp_pwin) {
			panel_pwin_evt(p, evt);
			return(TRUE);
		}
		else if (xa->window == p->xp_vswin) {
			panel_vswin_evt(p, evt);
			return(TRUE);
		}
		else if (xa->window == p->xp_hswin) {
			panel_hswin_evt(p, evt);
			return(TRUE);
		}
	}
	return(FALSE);
}

void
panel_win_evt(p, evt)
Panel *p;
XEvent *evt;
{
	XConfigureEvent *cf;
	XExposeEvent *ex;
	int panel_config();
	void panel_draw(), panel_display();
	void panelvscroll_draw(), panelhscroll_draw();
	void panel_unmapsubwins();

	switch (evt->type) {
	case MapNotify:
		if (p->xp_flags & LXP_CONFIGDONE)
			return;
		if (!(p->xp_flags & LXP_PANELVISIBLE))
			return;

		p->xp_flags|= LXP_FRAMEMAPPED;
		(void) panel_resize(p);
		(void) panel_config(p);
		p->xp_flags|= LXP_CONFIGDONE;
		XMapWindow(p->xp_dpy, p->xp_pwin);
		if (p == xp_blocked) {
			if (alert_buttonactive)
				XWarpPointer(p->xp_dpy, None, p->xp_win, 0, 0, 0, 0, alert_xwarp, alert_ywarp);
			else
				XWarpPointer(p->xp_dpy, None, p->xp_win, 0, 0, 0, 0, p->xp_apw/2, p->xp_aph/2);
		}
		xp_fullredraw= TRUE;
		panel_draw(p);
		panel_display(p);
		xp_fullredraw= FALSE;
		if (p->xp_flags & LXP_VSCROLLVIS) {
			XMapWindow(p->xp_dpy, p->xp_vswin);
			panelvscroll_draw(p);
		}
		if (p->xp_flags & LXP_HSCROLLVIS) {
			XMapWindow(p->xp_dpy, p->xp_hswin);
			panelhscroll_draw(p);
		}
		break;

	case ConfigureNotify:
		if (!(p->xp_flags & LXP_CONFIGDONE))
			return;
		if (!(p->xp_flags & LXP_PANELVISIBLE))
			return;

		/* make sure a resize has actually occurred */
		cf= (XConfigureEvent *) evt;
		if ((p->xp_w == cf->width) && (p->xp_h == cf->height)) {
			p->xp_x= cf->x;
			p->xp_y= cf->y;
			return;
		}

		xp_usrresize= TRUE;
		xp_confx= cf->x;
		xp_confy= cf->y;
		xp_confw= cf->width;
		xp_confh= cf->height;
#ifdef PRE_R3
		/* this causes a server crash under X.V11R3/SunOS3.4! */
		XUnmapSubwindows(p->xp_dpy, p->xp_win);
#else
		panel_unmapsubwins(p);
#endif PRE_R3
		(void) panel_resize(p);
		(void) panel_config(p);
		xp_usrresize= FALSE;
		XMapWindow(p->xp_dpy, p->xp_pwin);
		xp_fullredraw= TRUE;
		panel_draw(p);
		panel_display(p);
		xp_fullredraw= FALSE;
		if (p->xp_flags & LXP_VSCROLLVIS) {
			XMapWindow(p->xp_dpy, p->xp_vswin);
			panelvscroll_draw(p);
		}
		if (p->xp_flags & LXP_HSCROLLVIS) {
			XMapWindow(p->xp_dpy, p->xp_hswin);
			panelhscroll_draw(p);
		}
		break;

	case UnmapNotify:
		p->xp_flags&= ~LXP_FRAMEMAPPED;
		p->xp_flags&= ~LXP_CONFIGDONE;
		break;

	case Expose:
		if (!(p->xp_flags & LXP_CONFIGDONE))
			return;

		ex= (XExposeEvent *) evt;
		XFillRectangle(p->xp_dpy, p->xp_win, p->xp_gc, ex->x, ex->y, ex->width, ex->height);
		if ((p->xp_flags & LXP_VSCROLLVIS) && (p->xp_flags & LXP_HSCROLLVIS))
			XFillRectangle(p->xp_dpy, p->xp_win, p->xp_cgc, p->xp_ibw, p->xp_ibw, p->xp_vscroll->xs_barwidth+1, p->xp_hscroll->xs_barwidth+1);
		break;

	default:
		break;
	}
}

void
panel_pwin_evt(p, evt)
Panel *p;
XEvent *evt;
{
	void panel_pw_ex_proc(), panel_pw_bp_proc();
	void panel_pw_pm_proc(), panel_pw_br_proc();
	void panel_pw_kp_proc();
	void xptext_sc_proc(), xptext_sr_proc(), xptext_sn_proc();

	switch (evt->type) {
	case Expose:
		panel_pw_ex_proc(p, (XExposeEvent *) evt);
		break;
	case KeyPress:
		panel_pw_kp_proc(p, (XKeyEvent *) evt);
		break;
	case ButtonPress:
		panel_pw_bp_proc(p, (XButtonPressedEvent *) evt);
		break;
	case ButtonRelease:
		panel_pw_br_proc(p, (XButtonReleasedEvent *) evt);
		break;
	case MotionNotify:
		panel_pw_pm_proc(p, (XPointerMovedEvent *) evt);
		break;
	case SelectionClear:
		xptext_sc_proc(p, (XSelectionClearEvent *) evt);
		break;
	case SelectionRequest:
		xptext_sr_proc(p, (XSelectionRequestEvent *) evt);
		break;
	case SelectionNotify:
		xptext_sn_proc(p, (XSelectionEvent *) evt);
		break;
	default:
		break;
	}
}

void
panel_vswin_evt(p, evt)
Panel *p;
XEvent *evt;
{
	void panel_vsw_ex_proc(), panel_vsw_bp_proc();

	switch (evt->type) {
	case Expose:
		panel_vsw_ex_proc(p, (XExposeEvent *) evt);
		break;
	case ButtonPress:
		panel_vsw_bp_proc(p, (XButtonPressedEvent *) evt);
		break;
	default:
		break;
	}
}

void
panel_hswin_evt(p, evt)
Panel *p;
XEvent *evt;
{
	void panel_hsw_ex_proc(), panel_hsw_bp_proc();

	switch (evt->type) {
	case Expose:
		panel_hsw_ex_proc(p, (XExposeEvent *) evt);
		break;
	case ButtonPress:
		panel_hsw_bp_proc(p, (XButtonPressedEvent *) evt);
		break;
	default:
		break;
	}
}

void
panel_pw_ex_proc(p, evt)
/*
   Internal function.
   Redraws panel upon exposure.
*/
Panel *p;
XExposeEvent *evt;
{
	if (!(p->xp_flags & LXP_CONFIGDONE))
		return;

	XCopyArea(p->xp_dpy, p->xp_ppm, p->xp_pwin, p->xp_gc, evt->x+p->xp_vx, evt->y+p->xp_vy, evt->width, evt->height, evt->x, evt->y);
	XFlush(p->xp_dpy);
	return;
}

void
panel_pw_bp_proc(p, evt)
/*
   Internal function.
   Button click over panel.
*/
Panel *p;
XButtonPressedEvent *evt;
{
	Panel_item *pi;
	Panel_item *panel_findsel();

	if (!(p->xp_flags & LXP_CONFIGDONE))
		return;

	p->xp_selitem= (Panel_item *) NULL;
	if ((pi= panel_findsel(p, evt->x+p->xp_vx, evt->y+p->xp_vy)) == (Panel_item *) NULL)
		return;
	(panelitem_proctab[pi->xpi_type].xpi_bp_proc)(p, pi, evt);
	return;
}

void
panel_pw_br_proc(p, evt)
/*
   Internal function.
   Button release over panel.
*/
Panel *p;
XButtonReleasedEvent *evt;
{
	Panel_item *pi;
	Panel_item *panel_findsel();

	if (!(p->xp_flags & LXP_CONFIGDONE))
		return;
	if (p->xp_selitem == (Panel_item *) NULL)
		return;

	pi= panel_findsel(p, evt->x+p->xp_vx, evt->y+p->xp_vy);
	(panelitem_proctab[p->xp_selitem->xpi_type].xpi_br_proc)(p, pi, evt);
	return;
}

void
panel_pw_kp_proc(p, evt)
/*
   Internal function.
   Key press over panel.
*/
Panel *p;
XKeyEvent *evt;
{
	if (!(p->xp_flags & LXP_CONFIGDONE))
		return;
	if (p->xp_seltext == (Panel_item *) NULL)
		return;

	(panelitem_proctab[p->xp_seltext->xpi_type].xpi_kp_proc)(p, p->xp_seltext, evt);
	return;
}

void
panel_pw_pm_proc(p, evt)
/*
   Internal function.
   Pointer motion within panel.
*/
Panel *p;
XPointerMovedEvent *evt;
{
	Panel_item *pi;
	Panel_item *panel_findsel();

	if (!(p->xp_flags & LXP_CONFIGDONE))
		return;
	if (!(evt->state & (Button1Mask | Button2Mask | Button3Mask)))
		return;
	if (p->xp_selitem == (Panel_item *) NULL)
		return;

	pi= panel_findsel(p, evt->x+p->xp_vx, evt->y+p->xp_vy);
	(panelitem_proctab[p->xp_selitem->xpi_type].xpi_pm_proc)(p, pi, evt);
	return;
}

void
panel_vsw_ex_proc(p, evt)
/*
   Internal function.
   Redraws panel upon exposure.
*/
Panel *p;
XExposeEvent *evt;
{
	if (!(p->xp_flags & LXP_CONFIGDONE))
		return;
	if (!(p->xp_flags & LXP_VSCROLLVIS))
		return;

	XCopyArea(p->xp_dpy, p->xp_vspm, p->xp_vswin, p->xp_gc, evt->x, evt->y, evt->width, evt->height, evt->x, evt->y);
	XFlush(p->xp_dpy);
}

void
panel_vsw_bp_proc(p, evt)
/*
   Internal function.
   Vertical scroll.
*/
Panel *p;
XButtonPressedEvent *evt;
{
	int scroll_ctr, panel_ctr, page_sz;
	Scrollbar *s;
	void panel_draw(), panel_display();
	void panelvscroll_draw();

	if (!(p->xp_flags & LXP_CONFIGDONE))
		return;
	if (!(p->xp_flags & LXP_VSCROLLVIS))
		return;

	s= p->xp_vscroll;
	scroll_ctr= evt->y-s->xs_barstart;
	panel_ctr= (int) (((float) scroll_ctr/(float) s->xs_barlen)*p->xp_mph);

	/* click on button */
	if ((scroll_ctr < 0) || (scroll_ctr > s->xs_barlen)) {

		switch (evt->button) {
		case Button1:
			if (p->xp_vy+10 > p->xp_mph-p->xp_aph)
				p->xp_vy= p->xp_mph-p->xp_aph;
			else
				p->xp_vy= p->xp_vy+10;
			break;
		case Button2:
			page_sz= (5*p->xp_aph)/6;
			if (evt->state & ShiftMask) {
				if (p->xp_vy-page_sz  < 0)
					p->xp_vy= 0;
				else
					p->xp_vy= p->xp_vy-page_sz;
			}
			else {
				if (p->xp_vy+page_sz > p->xp_mph-p->xp_aph)
					p->xp_vy= p->xp_mph-p->xp_aph;
				else
					p->xp_vy= p->xp_vy+page_sz;
			}
			break;
		case Button3:
			if (p->xp_vy-10  < 0)
				p->xp_vy= 0;
			else
				p->xp_vy= p->xp_vy-10;
			break;
		default:
			break;
		}
	}

	/* scroll to extreme top */
	else if (panel_ctr-(p->xp_aph/2) < 0) {

		/* already there */
		if (p->xp_vy == 0)
			return;

		p->xp_vy= 0;
	}

	/* scroll to extreme bottom */
	else if (panel_ctr+(p->xp_aph/2) > p->xp_mph) {

		/* already there */
		if (p->xp_vy == p->xp_mph-p->xp_aph)
			return;

		p->xp_vy= p->xp_mph-p->xp_aph;
	}

	/* scroll to any other point */
	else {

		/* already there */
		if (p->xp_vy == panel_ctr-(p->xp_aph/2))
			return;

		p->xp_vy= panel_ctr-(p->xp_aph/2);
	}

	panel_draw(p);
	panelvscroll_draw(p);
	panel_display(p);
	return;
}

void
panel_hsw_ex_proc(p, evt)
/*
   Internal function.
   Redraws panel upon exposure.
*/
Panel *p;
XExposeEvent *evt;
{
	if (!(p->xp_flags & LXP_CONFIGDONE))
		return;
	if (!(p->xp_flags & LXP_HSCROLLVIS))
		return;

	XCopyArea(p->xp_dpy, p->xp_hspm, p->xp_hswin, p->xp_gc, evt->x, evt->y, evt->width, evt->height, evt->x, evt->y);
	XFlush(p->xp_dpy);
}

void
panel_hsw_bp_proc(p, evt)
/*
   Internal function.
   Horizontal scroll.
*/
Panel *p;
XButtonPressedEvent *evt;
{
	int scroll_ctr, panel_ctr, page_sz;
	Scrollbar *s;
	void panel_draw(), panel_display();
	void panelhscroll_draw();

	if (!(p->xp_flags & LXP_CONFIGDONE))
		return;
	if (!(p->xp_flags & LXP_HSCROLLVIS))
		return;

	s= p->xp_hscroll;
	scroll_ctr= evt->x-s->xs_barstart;
	panel_ctr= (int) (((float) scroll_ctr/(float) s->xs_barlen)*p->xp_mpw);

	/* click on button */
	if ((scroll_ctr < 0) || (scroll_ctr > s->xs_barlen)) {

		switch (evt->button) {
		case Button1:
			if (p->xp_vx+10 > p->xp_mpw-p->xp_apw)
				p->xp_vx= p->xp_mpw-p->xp_apw;
			else
				p->xp_vx= p->xp_vx+10;
			break;
		case Button2:
			page_sz= (5*p->xp_apw)/6;
			if (evt->state & ShiftMask) {
				if (p->xp_vx-page_sz  < 0)
					p->xp_vx= 0;
				else
					p->xp_vx= p->xp_vx-page_sz;
			}
			else {
				if (p->xp_vx+page_sz > p->xp_mpw-p->xp_apw)
					p->xp_vx= p->xp_mpw-p->xp_apw;
				else
					p->xp_vx= p->xp_vx+page_sz;
			}
			break;
		case Button3:
			if (p->xp_vx-10  < 0)
				p->xp_vx= 0;
			else
				p->xp_vx= p->xp_vx-10;
			break;
		default:
			break;
		}
	}

	/* scroll to extreme left */
	else if (panel_ctr-(p->xp_apw/2) < 0) {

		/* already there */
		if (p->xp_vx == 0)
			return;

		p->xp_vx= 0;
	}

	/* scroll to extreme right */
	else if (panel_ctr+(p->xp_apw/2) > p->xp_mpw) {

		/* already there */
		if (p->xp_vx == p->xp_mpw-p->xp_apw)
			return;

		p->xp_vx= p->xp_mpw-p->xp_apw;
	}

	/* scroll to any other point */
	else {

		/* already there */
		if (p->xp_vx == panel_ctr-(p->xp_apw/2))
			return;

		p->xp_vx= panel_ctr-(p->xp_apw/2);
	}

	panel_draw(p);
	panelhscroll_draw(p);
	panel_display(p);
	return;
}

Panel_item *
panel_findsel(p, x, y)
/*
   Internal function.
   Returns a (possibly null) pointer to the item at (x, y).
*/
Panel *p;
int x, y;
{
	Panel_item *pi;

	for (pi= p->xp_items; pi != (Panel_item *) NULL; pi= pi->xpi_next) {
		if ((x >= pi->xpi_x) && (x < pi->xpi_x+pi->xpi_w) &&
		    (y >= pi->xpi_y) && (y < pi->xpi_y+pi->xpi_h) &&
		    (pi->xpi_state == LXPI_ACTIVE))
			break;
	}
	return(pi);
}
