#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include "lxt.h"

extern Panel *xp_panels;
extern boolean xp_usrresize;
extern int xp_confx, xp_confy;
extern int xp_confw, xp_confh;
extern Panel *xp_blocked;

int
panel_config(p)
/*
   Internal function.
   Sizes and positions scrollbars and panel within
   the enclosing window, creating all necessary backing store.
*/
Panel *p;
{
	XWindowAttributes xwa;
	int root, scr, depth;
	int ibw, w, h;
	Scrollbar *s;

	if (xp_usrresize) {
		p->xp_x= xp_confx;
		p->xp_y= xp_confy;
		p->xp_w= xp_confw;
		p->xp_h= xp_confh;
	}
	else {
		XGetWindowAttributes(p->xp_dpy, p->xp_win, &xwa);
		p->xp_x= xwa.x;
		p->xp_y= xwa.y;
		p->xp_w= xwa.width;
		p->xp_h= xwa.height;
	}

	/* don't display internal border on blocking panels */
	if (xp_blocked == p)
		ibw= 0;
	else
		ibw= p->xp_ibw;

	/* scrollbars necessary? */
	if (p->xp_mpw > p->xp_w-(2*ibw))
		p->xp_flags|= LXP_HSCROLLVIS;
	else
		p->xp_flags&= ~LXP_HSCROLLVIS;
	if (p->xp_mph > p->xp_h-(2*ibw))
		p->xp_flags|= LXP_VSCROLLVIS;
	else
		p->xp_flags&= ~LXP_VSCROLLVIS;

	/* addition of one scrollbar further reduces available
	   panel space in the other direction, so check again */
	if (p->xp_flags & LXP_HSCROLLVIS) {
		if (p->xp_mph > p->xp_h-(p->xp_hscroll->xs_barwidth+1)-(2*ibw))
			p->xp_flags|= LXP_VSCROLLVIS;
	}
	if (p->xp_flags & LXP_VSCROLLVIS) {
		if (p->xp_mpw > p->xp_w-(p->xp_vscroll->xs_barwidth+1)-(2*ibw))
			p->xp_flags|= LXP_HSCROLLVIS;
	}

	/* size and locate panel and scrollbars */
	p->xp_px= p->xp_py= ibw;
	p->xp_vx= p->xp_vy= 0;
	p->xp_apw= p->xp_w-(2*ibw);
	p->xp_aph= p->xp_h-(2*ibw);
	if (p->xp_flags & LXP_VSCROLLVIS) {
		p->xp_px+= p->xp_vscroll->xs_barwidth+1;
		p->xp_apw-= p->xp_vscroll->xs_barwidth+1;
	}
	if (p->xp_flags & LXP_HSCROLLVIS) {
		p->xp_py+= p->xp_hscroll->xs_barwidth+1;
		p->xp_aph-= p->xp_hscroll->xs_barwidth+1;
	}
	if (p->xp_apw < 1)
		p->xp_apw= 1;
	if (p->xp_aph < 1)
		p->xp_aph= 1;
	XMoveWindow(p->xp_dpy, p->xp_pwin, p->xp_px, p->xp_py);
	XResizeWindow(p->xp_dpy, p->xp_pwin, p->xp_apw, p->xp_aph);
	if (p->xp_flags & LXP_VSCROLLVIS) {
		s= p->xp_vscroll;
		if ((p->xp_aph >= (2*s->xs_buttonlen)+LXSDEF_MINBARLEN) && (s->xs_buttonlen > 0))
			s->xs_flags|= LXS_BUTTONVIS;
		else
			s->xs_flags&= ~LXS_BUTTONVIS;
		if (p->xp_py == ibw) {
			XMoveWindow(p->xp_dpy, p->xp_vswin, ibw, ibw);
			XResizeWindow(p->xp_dpy, p->xp_vswin, s->xs_barwidth+1, p->xp_aph);
			if (s->xs_flags & LXS_BUTTONVIS) {
				s->xs_barstart= s->xs_buttonlen+1;
				s->xs_barlen= p->xp_aph-(2*(s->xs_buttonlen+1));
			}
			else {
				s->xs_barstart= 0;
				s->xs_barlen= p->xp_aph;
			}
		}
		else {
			XMoveWindow(p->xp_dpy, p->xp_vswin, ibw, p->xp_py-1);
			XResizeWindow(p->xp_dpy, p->xp_vswin, s->xs_barwidth+1, p->xp_aph+1);
			if (s->xs_flags & LXS_BUTTONVIS) {
				s->xs_barstart= s->xs_buttonlen+2;
				s->xs_barlen= p->xp_aph-(2*(s->xs_buttonlen+1));
			}
			else {
				s->xs_barstart= 1;
				s->xs_barlen= p->xp_aph;
			}
		}
	}
	if (p->xp_flags & LXP_HSCROLLVIS) {
		s= p->xp_hscroll;
		if ((p->xp_apw >= (2*s->xs_buttonlen)+LXSDEF_MINBARLEN) && (s->xs_buttonlen > 0))
			s->xs_flags|= LXS_BUTTONVIS;
		else
			s->xs_flags&= ~LXS_BUTTONVIS;
		if (p->xp_px == ibw) {
			XMoveWindow(p->xp_dpy, p->xp_hswin, ibw, ibw);
			XResizeWindow(p->xp_dpy, p->xp_hswin, p->xp_apw, s->xs_barwidth+1);
			if (s->xs_flags & LXS_BUTTONVIS) {
				s->xs_barstart= s->xs_buttonlen+1;
				s->xs_barlen= p->xp_apw-(2*(s->xs_buttonlen+1));
			}
			else {
				s->xs_barstart= 0;
				s->xs_barlen= p->xp_apw;
			}
		}
		else {
			XMoveWindow(p->xp_dpy, p->xp_hswin, p->xp_px-1, ibw);
			XResizeWindow(p->xp_dpy, p->xp_hswin, p->xp_apw+1, s->xs_barwidth+1);
			if (s->xs_flags & LXS_BUTTONVIS) {
				s->xs_barstart= s->xs_buttonlen+2;
				s->xs_barlen= p->xp_apw-(2*(s->xs_buttonlen+1));
			}
			else {
				s->xs_barstart= 1;
				s->xs_barlen= p->xp_apw;
			}
		}
	}

	/* free any old and allocate all necessary new backing store */
	root= DefaultRootWindow(p->xp_dpy);
	scr= DefaultScreen(p->xp_dpy);
	depth= DefaultDepth(p->xp_dpy, scr);
	if (p->xp_ppm != None)
		XFreePixmap(p->xp_dpy, p->xp_ppm);
	if (p->xp_vspm != None)
		XFreePixmap(p->xp_dpy, p->xp_vspm);
	if (p->xp_hspm != None)
		XFreePixmap(p->xp_dpy, p->xp_hspm);
	if ((p->xp_ppm= XCreatePixmap(p->xp_dpy, (Drawable) root, p->xp_mpw, p->xp_mph, depth)) == None) {
		(void) fprintf(stderr, "panel_config: memory allocation error\n");
		return(LX_ERROR);
	}
	if (p->xp_flags & LXP_VSCROLLVIS) {
		if (p->xp_py == ibw)
			h= p->xp_aph;
		else
			h= p->xp_aph+1;
		if ((p->xp_vspm= XCreatePixmap(p->xp_dpy, (Drawable) root, p->xp_vscroll->xs_barwidth+1, h, depth)) == None) {
			(void) fprintf(stderr, "panel_config: memory allocation error\n");
			return(LX_ERROR);
		}
	}
	else
		p->xp_vspm= None;
	if (p->xp_flags & LXP_HSCROLLVIS) {
		if (p->xp_px == ibw)
			w= p->xp_apw;
		else
			w= p->xp_apw+1;
		if ((p->xp_hspm= XCreatePixmap(p->xp_dpy, (Drawable) root, w, p->xp_hscroll->xs_barwidth+1, depth)) == None) {
			(void) fprintf(stderr, "panel_config: memory allocation error\n");
			return(LX_ERROR);
		}
	}
	else
		p->xp_hspm= None;

	return(LX_SUCCESS);
}

void
panel_unmapsubwins(p)
/*
   Internal function.
   Calls to XUnmapSubwindows(p->xp_dpy, p->xp_win) cause
   server crashes under X.V11R3/SunOS3.4, hence this hack.
*/
Panel *p;
{
	XWindowAttributes xwa;

	XGetWindowAttributes(p->xp_dpy, p->xp_pwin, &xwa);
	switch (xwa.map_state) {
	case IsUnviewable:
	case IsViewable:
		XUnmapWindow(p->xp_dpy, p->xp_pwin);
		break;
	case IsUnmapped:
		break;
	default:
		break;
	}

	XGetWindowAttributes(p->xp_dpy, p->xp_hswin, &xwa);
	switch (xwa.map_state) {
	case IsUnviewable:
	case IsViewable:
		XUnmapWindow(p->xp_dpy, p->xp_hswin);
		break;
	case IsUnmapped:
		break;
	default:
		break;
	}

	XGetWindowAttributes(p->xp_dpy, p->xp_vswin, &xwa);
	switch (xwa.map_state) {
	case IsUnviewable:
	case IsViewable:
		XUnmapWindow(p->xp_dpy, p->xp_vswin);
		break;
	case IsUnmapped:
		break;
	default:
		break;
	}
}

panel_print()
/*
   Internal function.
   Debugging only.
*/
{
	Panel *p;
	Panel_item *pi;

	for (p= xp_panels; p != (Panel *) NULL; p= p->xp_next) {
		(void) printf("panel_print: begin\n");
		for (pi= p->xp_items; pi != (Panel_item *) NULL; pi= pi->xpi_next) {
			(void) printf("panelitem_print: begin\n");
			if (pi->xpi_str != (char *) NULL)
				(void) printf("xpi_str: %s\n", pi->xpi_str);
		}
	}
}
