#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include "lxt.h"

extern boolean xp_fullredraw;
extern Panel_item *xpenum_selpanelitem;

int
xpchoice_idef_proc(p, pi)
/*
   Internal function.
   Initialize defaults for a choice item.
*/
Panel *p;
Panel_item *pi;
{
	pi->xpi_item.xpi_enum.xpenum_val= (0x1 << LXPDEF_ENUMVAL);
	pi->xpi_item.xpi_enum.xpenum_sel= (xp_esel *) NULL;
	pi->xpi_item.xpi_enum.xpenum_list= (xp_esel *) NULL;
	pi->xpi_item.xpi_enum.xpenum_flags= LXPENUM_DISPALL;
	return(LX_SUCCESS);
}

int
xpchoice_sz_proc(p, pi)
/*
   Internal function.
   Sizes a choice item.
*/
Panel *p;
Panel_item *pi;
{
	int font_ht;
	xp_esel *es;

	pi->xpi_w= pi->xpi_h= 0;
	if (pi->xpi_image != (XImage *) NULL) {
		pi->xpi_w= pi->xpi_item.xpi_enum.xpenum_lx+pi->xpi_image->width;
		pi->xpi_h= pi->xpi_item.xpi_enum.xpenum_ly+pi->xpi_image->height;
	}
	else if (pi->xpi_str != (char *) NULL) {
		font_ht= pi->xpi_font->max_bounds.ascent+pi->xpi_font->max_bounds.descent;
		pi->xpi_w= pi->xpi_item.xpi_enum.xpenum_lx+XTextWidth(pi->xpi_font, pi->xpi_str, strlen(pi->xpi_str));
		pi->xpi_h= pi->xpi_item.xpi_enum.xpenum_ly+font_ht+2;
	}

	for (es= pi->xpi_item.xpi_enum.xpenum_list; es != (xp_esel *) NULL; es= es->xpesel_next) {
		if (pi->xpi_w < es->xpesel_x+es->xpesel_w)
			pi->xpi_w= es->xpesel_x+es->xpesel_w;
		if (pi->xpi_h < es->xpesel_y+es->xpesel_h)
			pi->xpi_h= es->xpesel_y+es->xpesel_h;
	}
	return(LX_SUCCESS);
}

void
xpchoice_drw_proc(p, pi)
/*
   Internal function.
   Plots a choice item onto the backing store.
*/
Panel *p;
Panel_item *pi;
{
	int x, y, ascent, font_ht;
	xp_esel *es;
	boolean xpenum_ordsel();

	if (!xp_fullredraw)
		XFillRectangle(p->xp_dpy, p->xp_ppm, pi->xpi_cgc, pi->xpi_x, pi->xpi_y, pi->xpi_w, pi->xpi_h);
	if (pi->xpi_state == LXPI_INACTIVE)
		return;

	x= pi->xpi_x+pi->xpi_item.xpi_enum.xpenum_lx;
	y= pi->xpi_y+pi->xpi_item.xpi_enum.xpenum_ly;
	ascent= pi->xpi_font->max_bounds.ascent;
	font_ht= pi->xpi_font->max_bounds.ascent+pi->xpi_font->max_bounds.descent;

	/* attempt to draw xpi_image */
	if (pi->xpi_image != (XImage *) NULL)
		XPutImage(p->xp_dpy, p->xp_ppm, pi->xpi_gc, pi->xpi_image, 0, 0, x, y, pi->xpi_image->width, pi->xpi_image->height);

	/* else attempt to draw xpi_str */
	else if (pi->xpi_str != (char *) NULL) {
		if (strlen(pi->xpi_str) != 0)
			XDrawString(p->xp_dpy, p->xp_ppm, pi->xpi_gc, x, y+ascent+1, pi->xpi_str, strlen(pi->xpi_str));
	}

	for (es= pi->xpi_item.xpi_enum.xpenum_list; es != (xp_esel *) NULL; es= es->xpesel_next) {
		if ((pi->xpi_item.xpi_enum.xpenum_flags & LXPENUM_DISPCURRSEL) && !(xpenum_ordsel(pi, es->xpesel_ord)))
			continue;

		/* draw (no)mark image unless selected choices are to be inverted */
		if (!(pi->xpi_item.xpi_enum.xpenum_flags & LXPENUM_INVERTLABEL)) {
			x= pi->xpi_x+es->xpesel_mx;
			y= pi->xpi_y+es->xpesel_my;
			if (xpenum_ordsel(pi, es->xpesel_ord)) {
				if (es->xpesel_mimage != (XImage *) NULL)
					XPutImage(p->xp_dpy, p->xp_ppm, pi->xpi_gc, es->xpesel_mimage, 0, 0, x, y, es->xpesel_mimage->width, es->xpesel_mimage->height);
			}
			else {
				if (es->xpesel_nmimage != (XImage *) NULL)
					XPutImage(p->xp_dpy, p->xp_ppm, pi->xpi_gc, es->xpesel_nmimage, 0, 0, x, y, es->xpesel_nmimage->width, es->xpesel_nmimage->height);
			}
		}

		/* draw choice image or string */
		x= pi->xpi_x+es->xpesel_lx;
		y= pi->xpi_y+es->xpesel_ly;
		if (es->xpesel_image != (XImage *) NULL)
			XPutImage(p->xp_dpy, p->xp_ppm, pi->xpi_gc, es->xpesel_image, 0, 0, x, y, es->xpesel_image->width, es->xpesel_image->height);
		else if (es->xpesel_str != (char *) NULL) {
			if (strlen(es->xpesel_str) != 0)
				XDrawString(p->xp_dpy, p->xp_ppm, pi->xpi_gc, x, y+ascent+1, es->xpesel_str, strlen(es->xpesel_str));
		}

		/* invert choice image or string if desired */
		if ((pi->xpi_item.xpi_enum.xpenum_flags & LXPENUM_INVERTLABEL) && (xpenum_ordsel(pi, es->xpesel_ord)))
			XFillRectangle(p->xp_dpy, p->xp_ppm, pi->xpi_igc, x-1, y, XTextWidth(pi->xpi_font, es->xpesel_str, strlen(es->xpesel_str))+2, font_ht+2);
	}
}

void
xpchoice_bp_proc(p, pi, evt)
/*
   Internal function.
   Process button press on choice item.
*/
Panel *p;
Panel_item *pi;
XButtonPressedEvent *evt;
{
	xp_enum *xpe;
	xp_esel *es;
	int old, new;
	xp_esel *xpenum_findesel();
	int xpenum_value();
	void xpchoice_drw_proc(), xpi_std_dsp_proc();
	void xpenum_adj_menu();

	xpe= (xp_enum *) &(pi->xpi_item.xpi_enum);
	if (xpe->xpenum_sel == (xp_esel *) NULL)
		return;

	switch (evt->button) {
	case Button1:
	case Button2:
		if ((es= xpenum_findesel(pi, evt->x+p->xp_vx-pi->xpi_x, evt->y+p->xp_vy-pi->xpi_y)) == (xp_esel *) NULL)
			return;
		if (xpe->xpenum_sel == es)
			return;
		xpe->xpenum_sel= es;
		xpe->xpenum_val= (0x1 << xpe->xpenum_sel->xpesel_ord);
		xpenum_adj_menu(pi);
		xpchoice_drw_proc(p, pi);
		xpi_std_dsp_proc(p, pi);
		break;
	case Button3:
		if (pi->xpi_menu == (Menu *) NULL)
			return;
		if (pi->xpi_menu->xm_items == (Menu_itemptr *) NULL)
			return;
		old= xpenum_value(pi);
		xpenum_selpanelitem= pi;
		menu_show(pi->xpi_menu, evt);
		new= xpenum_value(pi);
		if (old != new) {
			xpchoice_drw_proc(p, pi);
			xpi_std_dsp_proc(p, pi);
		}
		break;
	default:
		break;
	}
	return;
}
