#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>

#include "lxt.h"

Panel *xp_blocked= (Panel *) NULL;
int xp_blockretval;

int
panel_block(p, val)
/*
   User-callable.
   Displays a blocking panel.
*/
Panel *p;
int *val;
{
	XSetWindowAttributes xswa;
	XWindowAttributes xwa;
	Colormap cmap;
	Time tmstamp;
	Atom tmatom;
	int i;
	XEvent evt;
	XAnyEvent *xa;

	if (p == (Panel *) NULL) {
		(void) fprintf(stderr, "panel_block: null panel\n");
		return(LX_ERROR);
	}
	if (p->xp_magic != LX_PANEL) {
		(void) fprintf(stderr, "panel_block: object is not a panel\n");
		return(LX_ERROR);
	}
	if (xp_blocked != (Panel *) NULL) {
		(void) fprintf(stderr, "panel_block: blocked panel already displayed\n");
		return(LX_ERROR);
	}
	xp_blocked= p;

	xswa.override_redirect= TRUE;
	XChangeWindowAttributes(p->xp_dpy, p->xp_win, CWOverrideRedirect, &xswa);
	XMapRaised(p->xp_dpy, p->xp_win);
	if (p->xp_flags & LXP_GRABPTR) {
		XGrabPointer(p->xp_dpy, p->xp_win, True,
			ButtonPressMask | ButtonReleaseMask | PointerMotionMask,
			GrabModeAsync, GrabModeAsync, p->xp_win, None, CurrentTime);

		/* we need to generate a real timestamp to pass to
		   XSetInputFocus() to maintain ICCCM compliance --
		   this is done by performing a zero-length append
		   to a window property; if this fails, just use
		   CurrentTime and be happy that we tried */
		if ((tmatom= XInternAtom(p->xp_dpy, "_LXT_ICCCM_TMSTAMP", False)) == None)
			tmstamp= CurrentTime;
		else {
			XChangeProperty(p->xp_dpy, p->xp_pwin, tmatom, XA_STRING, 8, PropModeAppend, (unsigned char *) NULL, 0);
			XSync(p->xp_dpy, False);

			/* wait 5 seconds max to get notification, then give up */
			for (i= 5; i > 0; i--) {
				if (XCheckTypedWindowEvent(p->xp_dpy, p->xp_pwin, PropertyNotify, &evt) == True)
					break;
				else
					sleep(1);
			}
			if (i > 0)
				tmstamp= ((XPropertyEvent *) &evt)->time;
			else
				tmstamp= CurrentTime;
		}
		XSetInputFocus(p->xp_dpy, p->xp_win, RevertToParent, tmstamp);

		/* install non-default colormap if necessary */
		XGetWindowAttributes(p->xp_dpy, p->xp_win, &xwa);
		cmap= DefaultColormap(p->xp_dpy, DefaultScreen(p->xp_dpy));
		if (xwa.colormap != cmap)
			XInstallColormap(p->xp_dpy, xwa.colormap);
	}

	for (;;) {
		XNextEvent(p->xp_dpy, &evt);
		xa= (XAnyEvent *) &evt;

		/* suppress all mouse and keyboard events
		   not directed to the blocking panel */
		if ((xa->window != p->xp_win) && (xa->window != p->xp_pwin) &&
		    (xa->window != p->xp_vswin) && (xa->window != p->xp_hswin) &&
			(xa->type == KeyPress || xa->type == KeyRelease ||
			 xa->type == ButtonPress || xa->type == ButtonRelease ||
			 xa->type == MotionNotify)) 
			continue;

		if (lxt_event(&evt)) {
			if (xp_blocked == (Panel *) NULL)
				break;
		}
		else if (p->xp_proc != (void (*)()) NULL)
			(*(p->xp_proc))(&evt);
	}
	if (p->xp_flags & LXP_GRABPTR) {
		if (xwa.colormap != cmap)
			XUninstallColormap(p->xp_dpy, xwa.colormap);
		XUngrabPointer(p->xp_dpy, CurrentTime);
	}
	XUnmapWindow(p->xp_dpy, p->xp_win);
	xswa.override_redirect= FALSE;
	XChangeWindowAttributes(p->xp_dpy, p->xp_win, CWOverrideRedirect, &xswa);
	*val= xp_blockretval;
	return(LX_SUCCESS);
}

int
panel_unblock(p, val)
Panel *p;
int val;
{
	if (p == (Panel *) NULL) {
		(void) fprintf(stderr, "panel_unblock: null panel\n");
		return(LX_ERROR);
	}
	if (p->xp_magic != LX_PANEL) {
		(void) fprintf(stderr, "panel_unblock: object is not a panel\n");
		return(LX_ERROR);
	}
	if (xp_blocked == (Panel *) NULL) {
		(void) fprintf(stderr, "panel_unblock: no existing blocked panel\n");
		return(LX_ERROR);
	}
	else if (xp_blocked != p) {
		(void) fprintf(stderr, "panel_unblock: panel is not blocked\n");
		return(LX_ERROR);
	}
	xp_blocked= (Panel *) NULL;
	xp_blockretval= val;
	return(LX_SUCCESS);
}
