#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include "lxt.h"

extern Canvas *xc_canvases;
extern boolean xc_usrresize;
extern int xc_confx, xc_confy;
extern int xc_confw, xc_confh;

int
canvas_config(c)
/*
   Internal function.
   Sizes and positions scrollbars and canvas within
   the enclosing window, creating all necessary backing store.
*/
Canvas *c;
{
	XWindowAttributes xwa;
	int root, scr, depth;
	int w, h;
	Scrollbar *s;

	if (xc_usrresize) {
		c->xc_x= xc_confx;
		c->xc_y= xc_confy;
		c->xc_w= xc_confw;
		c->xc_h= xc_confh;
	}
	else {
		XGetWindowAttributes(c->xc_dpy, c->xc_win, &xwa);
		c->xc_x= xwa.x;
		c->xc_y= xwa.y;
		c->xc_w= xwa.width;
		c->xc_h= xwa.height;
	}

	c->xc_cx= c->xc_cy= c->xc_ibw;
	c->xc_vx= c->xc_vy= 0;
	c->xc_acw= c->xc_w-(2*c->xc_ibw);
	c->xc_ach= c->xc_h-(2*c->xc_ibw);
	if (c->xc_acw < 1)
		c->xc_acw= 1;
	if (c->xc_ach < 1)
		c->xc_ach= 1;

	/* scrollbars necessary? */
	if (c->xc_mode == LXC_STATIC) {
		if (c->xc_vcw > c->xc_w-(2*c->xc_ibw))
			c->xc_flags|= LXC_HSCROLLVIS;
		else
			c->xc_flags&= ~LXC_HSCROLLVIS;
		if (c->xc_vch > c->xc_h-(2*c->xc_ibw))
			c->xc_flags|= LXC_VSCROLLVIS;
		else
			c->xc_flags&= ~LXC_VSCROLLVIS;

		/* addition of one scrollbar further reduces available
		   canvas space in the other direction, so check again */
		if (c->xc_flags & LXC_HSCROLLVIS) {
			if (c->xc_vch > c->xc_h-(c->xc_hscroll->xs_barwidth+1)-(2*c->xc_ibw))
				c->xc_flags|= LXC_VSCROLLVIS;
		}
		if (c->xc_flags & LXC_VSCROLLVIS) {
			if (c->xc_vcw > c->xc_w-(c->xc_vscroll->xs_barwidth+1)-(2*c->xc_ibw))
				c->xc_flags|= LXC_HSCROLLVIS;
		}
	}

	/* adjust dynamic pixmap backing store if necessary */
	else if (canvas_adjdynpm(c) != LX_SUCCESS)
		return(LX_ERROR);

	/* size and locate canvas and scrollbars */
	if (c->xc_flags & LXC_VSCROLLVIS) {
		c->xc_cx+= c->xc_vscroll->xs_barwidth+1;
		c->xc_acw-= c->xc_vscroll->xs_barwidth+1;
	}
	if (c->xc_flags & LXC_HSCROLLVIS) {
		c->xc_cy+= c->xc_hscroll->xs_barwidth+1;
		c->xc_ach-= c->xc_hscroll->xs_barwidth+1;
	}
	if (c->xc_acw < 1)
		c->xc_acw= 1;
	if (c->xc_ach < 1)
		c->xc_ach= 1;
	XMoveWindow(c->xc_dpy, c->xc_cwin, c->xc_cx, c->xc_cy);
	XResizeWindow(c->xc_dpy, c->xc_cwin, c->xc_acw, c->xc_ach);
	if (c->xc_flags & LXC_VSCROLLVIS) {
		s= c->xc_vscroll;
		if ((c->xc_ach >= (2*s->xs_buttonlen)+LXSDEF_MINBARLEN) && (s->xs_buttonlen > 0))
			s->xs_flags|= LXS_BUTTONVIS;
		else
			s->xs_flags&= ~LXS_BUTTONVIS;
		if (c->xc_cy == c->xc_ibw) {
			XMoveWindow(c->xc_dpy, c->xc_vswin, c->xc_ibw, c->xc_ibw);
			XResizeWindow(c->xc_dpy, c->xc_vswin, s->xs_barwidth+1, c->xc_ach);
			if (s->xs_flags & LXS_BUTTONVIS) {
				s->xs_barstart= s->xs_buttonlen+1;
				s->xs_barlen= c->xc_ach-(2*(s->xs_buttonlen+1));
			}
			else {
				s->xs_barstart= 0;
				s->xs_barlen= c->xc_ach;
			}
		}
		else {
			XMoveWindow(c->xc_dpy, c->xc_vswin, c->xc_ibw, c->xc_cy-1);
			XResizeWindow(c->xc_dpy, c->xc_vswin, s->xs_barwidth+1, c->xc_ach+1);
			if (s->xs_flags & LXS_BUTTONVIS) {
				s->xs_barstart= s->xs_buttonlen+2;
				s->xs_barlen= c->xc_ach-(2*(s->xs_buttonlen+1));
			}
			else {
				s->xs_barstart= 1;
				s->xs_barlen= c->xc_ach;
			}
		}
	}
	if (c->xc_flags & LXC_HSCROLLVIS) {
		s= c->xc_hscroll;
		if ((c->xc_acw >= (2*s->xs_buttonlen)+LXSDEF_MINBARLEN) && (s->xs_buttonlen > 0))
			s->xs_flags|= LXS_BUTTONVIS;
		else
			s->xs_flags&= ~LXS_BUTTONVIS;
		if (c->xc_cx == c->xc_ibw) {
			XMoveWindow(c->xc_dpy, c->xc_hswin, c->xc_ibw, c->xc_ibw);
			XResizeWindow(c->xc_dpy, c->xc_hswin, c->xc_acw, s->xs_barwidth+1);
			if (s->xs_flags & LXS_BUTTONVIS) {
				s->xs_barstart= s->xs_buttonlen+1;
				s->xs_barlen= c->xc_acw-(2*(s->xs_buttonlen+1));
			}
			else {
				s->xs_barstart= 0;
				s->xs_barlen= c->xc_acw;
			}
		}
		else {
			XMoveWindow(c->xc_dpy, c->xc_hswin, c->xc_cx-1, c->xc_ibw);
			XResizeWindow(c->xc_dpy, c->xc_hswin, c->xc_acw+1, s->xs_barwidth+1);
			if (s->xs_flags & LXS_BUTTONVIS) {
				s->xs_barstart= s->xs_buttonlen+2;
				s->xs_barlen= c->xc_acw-(2*(s->xs_buttonlen+1));
			}
			else {
				s->xs_barstart= 1;
				s->xs_barlen= c->xc_acw;
			}
		}
	}

	/* free any old and allocate all necessary new scrollbar backing store */
	root= DefaultRootWindow(c->xc_dpy);
	scr= DefaultScreen(c->xc_dpy);
	depth= DefaultDepth(c->xc_dpy, scr);
	if (c->xc_vspm != None)
		XFreePixmap(c->xc_dpy, c->xc_vspm);
	if (c->xc_hspm != None)
		XFreePixmap(c->xc_dpy, c->xc_hspm);
	if (c->xc_flags & LXC_VSCROLLVIS) {
		if (c->xc_cy == c->xc_ibw)
			h= c->xc_ach;
		else
			h= c->xc_ach+1;
		if ((c->xc_vspm= XCreatePixmap(c->xc_dpy, (Drawable) root, c->xc_vscroll->xs_barwidth+1, h, depth)) == None) {
			(void) fprintf(stderr, "canvas_config: memory allocation error\n");
			return(LX_ERROR);
		}
	}
	else
		c->xc_vspm= None;
	if (c->xc_flags & LXC_HSCROLLVIS) {
		if (c->xc_cx == c->xc_ibw)
			w= c->xc_acw;
		else
			w= c->xc_acw+1;
		if ((c->xc_hspm= XCreatePixmap(c->xc_dpy, (Drawable) root, w, c->xc_hscroll->xs_barwidth+1, depth)) == None) {
			(void) fprintf(stderr, "canvas_config: memory allocation error\n");
			return(LX_ERROR);
		}
	}
	else
		c->xc_hspm= None;

	return(LX_SUCCESS);
}

int
canvas_adjdynpm(c)
/*
   Internal function.
   Adjust size of backing store pixmap
   to match size of actual canvas window.
*/
Canvas *c;
{
	int root, scr, depth;
	Pixmap pm;
	int w, h;

	switch (c->xc_mode) {
	case LXC_STATIC:
		break;
	case LXC_DYNAMICCLR:
	case LXC_DYNAMICPRS:
		root= DefaultRootWindow(c->xc_dpy);
		scr= DefaultScreen(c->xc_dpy);
		depth= DefaultDepth(c->xc_dpy, scr);
		c->xc_flags&= ~LXC_HSCROLLVIS;
		c->xc_flags&= ~LXC_VSCROLLVIS;
		if (c->xc_cpm == None) {
			if ((c->xc_cpm= XCreatePixmap(c->xc_dpy, (Drawable) root, c->xc_acw, c->xc_ach, depth)) == None) {
				(void) fprintf(stderr, "canvas_adjdynpm: memory allocation error\n");
				return(LX_ERROR);
			}
			XFillRectangle(c->xc_dpy, c->xc_cpm, c->xc_cgc, 0, 0, c->xc_acw, c->xc_ach);
		}
		else {
			pm= c->xc_cpm;
			if ((c->xc_acw != c->xc_vcw) || (c->xc_ach != c->xc_vch)) {
				if ((c->xc_cpm= XCreatePixmap(c->xc_dpy, (Drawable) root, c->xc_acw, c->xc_ach, depth)) == None) {
					c->xc_cpm= pm;
					(void) fprintf(stderr, "canvas_adjdynpm: memory allocation error\n");
					return(LX_ERROR);
				}
				XFillRectangle(c->xc_dpy, c->xc_cpm, c->xc_cgc, 0, 0, c->xc_acw, c->xc_ach);
			}
			else
				break;

			/* save contents of old pixmap if required */
			if (c->xc_mode == LXC_DYNAMICPRS) {
				if (c->xc_acw < c->xc_vcw)
					w= c->xc_acw;
				else
					w= c->xc_vcw;
				if (c->xc_ach < c->xc_vch)
					h= c->xc_ach;
				else
					h= c->xc_vch;
				XCopyArea(c->xc_dpy, pm, c->xc_cpm, c->xc_gc, 0, 0, w, h, 0, 0);
				XFlush(c->xc_dpy);
			}
			XFreePixmap(c->xc_dpy, pm);
		}
		c->xc_vcw= c->xc_acw;
		c->xc_vch= c->xc_ach;
		break;
	default:
		break;
	}

	return(LX_SUCCESS);
}

void
canvas_unmapsubwins(c)
/*
   Internal function.
   Calls to XUnmapSubwindows(c->xc_dpy, c->xc_win) cause
   server crashes under X.V11R3/SunOS3.4, hence this hack.
*/
Canvas *c;
{
	XWindowAttributes xwa;

	XGetWindowAttributes(c->xc_dpy, c->xc_cwin, &xwa);
	switch (xwa.map_state) {
	case IsUnviewable:
	case IsViewable:
		XUnmapWindow(c->xc_dpy, c->xc_cwin);
		break;
	case IsUnmapped:
		break;
	default:
		break;
	}

	XGetWindowAttributes(c->xc_dpy, c->xc_hswin, &xwa);
	switch (xwa.map_state) {
	case IsUnviewable:
	case IsViewable:
		XUnmapWindow(c->xc_dpy, c->xc_hswin);
		break;
	case IsUnmapped:
		break;
	default:
		break;
	}

	XGetWindowAttributes(c->xc_dpy, c->xc_vswin, &xwa);
	switch (xwa.map_state) {
	case IsUnviewable:
	case IsViewable:
		XUnmapWindow(c->xc_dpy, c->xc_vswin);
		break;
	case IsUnmapped:
		break;
	default:
		break;
	}
}
