/* 
	graphpoints.h
*/

typedef struct pointlink {
	int xval;
	double yval;
	struct pointlink *prev;
	struct pointlink *next;
} Pt_link;

typedef struct mygraph {
	Pt_link **pointlist;	/* linked list pointers */
	int npoints;
	int maxpoints;
	int nchans;
/* private functions */
	int (*extendList)();
/* public functions */
	void (*addPoint)();
	Pt_link *((*getPoint)());
	Pt_link *((*previous)());
	Pt_link *((*next)());
	Pt_link *((*last)());
	Pt_link *((*head)());
	void (*destroy)();
} Graph_points;

int gp_extendList();

void gp_addPoint(), gp_destroy();
Pt_link *gp_previous(), *gp_next(), *gp_getPoint(), *gp_head(), *gp_last();

struct mygraph *new_graphpoints();
