/*
	graphpoints.c
*/

#include "main.h"
#include "graphpoints.h"

Graph_points *
new_graphpoints()
{
	Graph_points *g;
	g = (Graph_points *) mv_alloc(sizeof(Graph_points));
/* functions */
	g->extendList = gp_extendList;
	g->addPoint = gp_addPoint;
	g->getPoint = gp_getPoint;
	g->previous = gp_previous;
	g->next = gp_next;
	g->last = gp_last;
	g->head = gp_head;
	g->destroy = gp_destroy;
/* initialization */
	g->extendList(g, 4);	/* 4 channels max for now */
	return g;
}

void
gp_destroy(g)
	Graph_points *g;
{
	Pt_link *end, *prev;
	int i;
	for(i = 0; i < g->nchans; i++) {
		for(end=g->last(g, i); end != NULL; ) { 
			prev = end->prev; 
			cfree((char *) end);
			if(!(end = prev))
				break;
		}
	}
	cfree((char *) g->pointlist);
	cfree((char *) g);
	g = (Graph_points *) NULL;
}

int
gp_extendList(g, nchans)
	Graph_points *g;
	int nchans;
{
	char *tmp = (char *) g->pointlist;
	if(!tmp)	/* if not previously allocated */
		tmp = (char *) mv_alloc(sizeof(POINTER)*nchans);
	else if((tmp = (char *) realloc(tmp, sizeof(POINTER) * nchans)) == CNULL) {
		mv_error(errno, "gp_extendList:  unable to allocate.");
		return -1;
	}
	g->pointlist = (Pt_link **) tmp;
	g->nchans = nchans;
	return 1;
}

void
gp_addPoint(g, chan, loc, val)
	Graph_points *g;
	int chan, loc;
	double val;
{
	Pt_link *head = g->pointlist[chan], *point, *new;
	new = (Pt_link *) mv_alloc(sizeof(Pt_link));
	new->xval = loc;
	new->yval = val;
	if(head != (Pt_link *) NULL) {
		point = head;
		while(point->next != (Pt_link *) NULL)
			point = point->next;
		new->prev = point;
		new->next = NULL;
		point->next = new;
	}
	else {
		new->prev = NULL;
		new->next = NULL;
		g->pointlist[chan] = new;
	}
}

Pt_link *
gp_getPoint(g, chan, loc)
	Graph_points *g;
	int loc, chan;
{
	Pt_link *point, *next;
	for(point =g->pointlist[chan]; point != (Pt_link *) NULL; point = next) {
		next = point->next;
		if(point->xval == loc) return point;
	}
	return (Pt_link *) NULL;
}

Pt_link *
gp_previous(g, loc)
	Graph_points *g;
	int loc;
{
	Pt_link *point;
	if((point = g->getPoint(g, loc)) == (Pt_link *) NULL)
		return (Pt_link *) NULL;
	return point->prev;
}

Pt_link *
gp_next(g, loc)
	Graph_points *g;
	int loc;
{
	Pt_link *point;
	if((point = g->getPoint(g, loc)) == (Pt_link *) NULL)
		return (Pt_link *) NULL;
	return point->next;
}

Pt_link *
gp_head(g, chan)
	Graph_points *g;
	int chan;
{
	return g->pointlist[chan];
}

Pt_link *
gp_last(g, chan)
	Graph_points *g;
	int chan;
{
	Pt_link *point, *next;
	for(point =g->pointlist[chan]; point != (Pt_link *) NULL; point = next) {
		if((next = point->next) == NULL)
			return point;
	}
	return (Pt_link *) NULL;
}
