/****************************************************************************** 
 *
 *  mixview - X Window System based soundfile editor and processor
 *
 *  Copyright 1989 by Douglas Scott
 *
 *  Author:     Douglas Scott 
 *  Date:       May 1, 1989
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The author makes no representations about
 *  the suitability of this software for any purpose.  
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/
#include "main.h"
#include "dialog.h"
#include "nobug.h"

#define OCTPT	0		/* data modes for increment */
#define LINOCT	1
#define RATIO	2


extern double array[SIZE];	/* for use with setline */
extern sf_struct *v;		/* the global struct containing much info */
extern int lineset;		/* the flag telling if setline done */
extern double tabs[2];		/* for tablei */
double tonedata[4][3];		/* for tone */
double rsndata[4][5];		/* for reson */
double *combdata[4];		/* for comb */

unsigned
tone_set(es)
ebuf_struct *es;
{
	register int i;
	double amp, cutoff;
	int mode;

	if(dialog->call(dialog, D_QTONE, "") < 1) return 0;
	cutoff = dialog->getValue(dialog, 0);
	if(cutoff < 0.0) {
		mv_alert("Illegal value for cutoff frequency.");
		return 0;
	}
	amp = dialog->getValue(dialog, 1);
	mode = dialog->getChoice(dialog, 0);
	if(dialog->getChoice(dialog, 1)) {
		if(get_curve() < 1) {
			clear_events();
			return 0;
		}
	}
	tab_set(es);	/* set table */

	if(mode) cutoff -= (v->srate/2.0);	/* for hi pass */

	for(i=0; i<v->nchans; i++)
		toneset(cutoff, 1, &tonedata[i][0]); /* set up tone filter */

	/* now load the value into the p array for trans to use */

	es->p[0] = amp;
	return((int) es->bufsize);
}

mv_tone(a, b)
cbuf_struct *a;
ebuf_struct *b;
{
    double input[4], amp, sig[4]; 
    register int i, j, z;
    register long int outcount = 0;

	/*  p0 = amp */


    z = v->srate/8000;		      /* the control rate for amp curve */
    z = z ? z : 1;
    j = 0;

    sfreset();		/* sets buffer pointers to starting points */

    /* the processing loop for the input signal */

    while(outcount++ < a->nsamps) {
	GETSAMP(a, input);                 /* get input samp */ 
	while(!j--) {
		amp = tablei(outcount,array,tabs) * b->p[0];
		j = z;
	}
	for(i=0; i<a->nchans; i++) {
		sig[i] = tone(input[i], tonedata[i]) * amp;
	}
        ADDSAMP(b, sig);
    }
}

unsigned
reson_set(es)
ebuf_struct *es;
{
	register int i;
	double amp, cutoff, bwidth;
	int mode, fmode;
	if(dialog->call(dialog, D_QRESON, "") < 1) return 0;
	cutoff = dialog->getValue(dialog, 0);
	bwidth = dialog->getValue(dialog, 1);
	if(cutoff < 0.0 || bwidth < 0.0) {
		mv_alert("Cutoff and bandwidth must be > 0.0.");
		return 0;
	}
	amp = dialog->getValue(dialog, 2);
	mode = dialog->getChoice(dialog, 0);
	if(dialog->getChoice(dialog, 1)) {
		if(get_curve() < 1) {
			clear_events();
			return 0;
		}
	}
	tab_set(es);	/* set up table */
	switch(mode){
	case 0:
		fmode = 1;
		break;
	case 1:
		fmode = 2;
		break;
	case 2:
		fmode = 0;
		break;
	default:
		fmode = 0;
		break;
	}

	/* set up reson filter */

	for(i=0; i<v->nchans; i++)
		rsnset(cutoff, bwidth, fmode, 1, &rsndata[i][0]);

	/* now load the value into the p array for trans to use */

	es->p[0] = amp;
	return((int) es->bufsize);
}

mv_reson(a, b)
cbuf_struct *a;
ebuf_struct *b;
{
    double input[4], amp, sig[4]; 
    register int i, j, z;
    register long int outcount = 0;

	/*  p0 = amp */


    z = v->srate/8000;		      /* the control rate for amp curve */
    z = z ? z : 1;
    j = 0;

    sfreset();		/* sets buffer pointers to starting points */

    /* the processing loop for the input signal */

    while(outcount++ < a->nsamps) {
	GETSAMP(a, input);                 /* get input samp */ 
	while(!j--) {
		amp = tablei(outcount,array,tabs) * b->p[0];
		j = z;
	}
	for(i=0; i<a->nchans; i++) {
		sig[i] = reson(input[i], rsndata[i]) * amp;
	}
        ADDSAMP(b, sig);
    }
}

unsigned
comb_set(es)
ebuf_struct *es;
{
	register int i;
	double amp, centerfreq, ringtime;
	int mode;

	if(dialog->call(dialog, D_QCOMB, "") < 1) return 0;
	centerfreq = dialog->getValue(dialog, 0);
	ringtime = dialog->getValue(dialog, 1);
	amp = dialog->getValue(dialog, 2);
	mode = dialog->getChoice(dialog, 0);
	if(centerfreq <= 0.0) {
		mv_alert("Center freq must be > 0.0.");
		return(0);
	}
	if(ringtime <= 0.0) {
		mv_alert("Ring time must be > 0.0.");
		return(0);
	}
	if(dialog->getChoice(dialog, 1)) {
		if(get_curve() < 1) {
			clear_events();
			return 0;
		}
	}
	es->nsamps += (int) (ringtime * es->srate);
	es->bufsize = es->nsamps * es->nchans * es->size;
	tab_set(es);	/* set table */

	if(!mode) centerfreq = 1.0/centerfreq;	/* mode 0 is freq, not time */

	/* allocate memory for loops and set filters if allocation succeeds */

	for(i=0; i<v->nchans; i++) {
		if((combdata[i] = 
			(double *) calloc((unsigned) (es->srate*centerfreq)+3,
			sizeof(double))) == (double *) NULL) {
				mv_error(errno, "Cannot allocate memory for filters!");
				if(i > 0) {
					while(i) cfree((char *) combdata[--i]);
				}
				return 0;
			}
		combset(centerfreq, ringtime, &combdata[i][0]);
	}
	/* now load the value into the p array for trans to use */

	es->p[0] = amp;
	return((int) es->bufsize);
}

mv_comb(a, b)
cbuf_struct *a;
ebuf_struct *b;
{
    double input[4], amp, sig[4]; 
    register int i, j, z;
    register long int outcount = 0;

	/*  p0 = amp */


    z = v->srate/8000;		      /* the control rate for amp curve */
    z = z ? z : 1;
    j = 0;

    sfreset();		/* sets buffer pointers to starting points */

    /* the processing loop for the input signal */

    while(outcount++ < a->nsamps) {
	GETSAMP(a, input);                 /* get input samp */ 
	while(!j--) {
		amp = tablei(outcount,array,tabs) * b->p[0];
		j = z;
	}
	for(i=0; i<a->nchans; i++) {
		sig[i] = comb(input[i], combdata[i]) * amp;
	}
        ADDSAMP(b, sig);
    }
    /* now continue feeding zeroes for filter decay */
    for(outcount = a->nsamps; outcount < b->nsamps; outcount++) {
	while(!j--) {
		amp = tablei(outcount,array,tabs) * b->p[0];
		j = z;
	}
	for(i=0; i<a->nchans; i++) {
		input[i] = 0.0;
		sig[i] = comb(input[i], combdata[i]) * amp;
	}
        ADDSAMP(b, sig);
    }
    for(i=0; i<a->nchans; i++) cfree((char *) combdata[i]); /* free memory */
}
