/*
	events.c
*/

#include "main.h"
#include "cmd.h"

extern Display *dpy;
extern Window canvas_win, cwin, mbar_win;
extern Pixmap plot_pm;
extern Canvas *canvas;
extern sf_struct *v;
extern Cursor arrow_curs;
extern int nheaders;
extern CMD command;   /* the command-status structure (from cmd.c) */
extern cbuf_struct *c;
extern FLAG line, box, is_owner, is_buff, yesbuff, insert, region;
extern FLAG is_visible;
extern int xloc, yloc;

get_events()
{
        XEvent event;
        while(1) {			/* loop for all events */
                XNextEvent(dpy, &event);
                switch (event.type) {
		case MappingNotify:	/* change in kbd. map */
			XRefreshKeyboardMapping((XMappingEvent *) &event);
			break;
		case ConfigureNotify:	/* main window resized */
                        resize_select((XConfigureEvent *) &event);
			is_visible = 1;
                        break;
		case SelectionRequest:	/* request for selection */
			store_selection((XSelectionRequestEvent *) &event);
			break;
		case SelectionNotify:	/* selection request granted */
			get_property((XSelectionEvent *) &event);
			break;
		case SelectionClear:	/* loss of selection ownership */
			unselect_region((XSelectionClearEvent *) &event);
			break;
                }
		if (lxt_event(&event)) /* process toolkit events */
			continue;
		if(screen_event(&event)) /* process my screen events */
			continue;
		if(datawin_event(&event)) /* process my datawin events */
			continue;
                switch (event.type) {	 /* process pointer & kbd. events */
                case MotionNotify:
                        pm_select((XPointerMovedEvent *) &event);
                        break;
                case ButtonPress:
                        bp_select((XButtonPressedEvent *) &event);
                        break;
                case ButtonRelease:
                        br_select((XButtonReleasedEvent *) &event);
                        break;
		case KeyPress:
			kp_select((XKeyPressedEvent *) &event);
			break;
                default:
                        break;
                }
        }
}

store_selection(event)	/* sets up selected region for transfer to requestor */
	XSelectionRequestEvent *event;
{
	int format = 8, fd;
	FLAG success = 0;
	ext_buff ext_info;	/* the struct with name & size of buffer */
	char bufname[32];	/* the full pathname of the buffer	*/
	XEvent sn;		/* create event to be sent to requestor */
	sn.type = SelectionNotify;
	sn.xselection.requestor = event->requestor;
	sn.xselection.selection = event->selection;
	sn.xselection.target = event->target;
	sn.xselection.time = event->time;
	sn.xselection.property = event->property;
	if((event->selection== XA_PRIMARY)&&(event->property== v->cutproperty))
	{
		/* create unique temporary buffer name */

		sprintf(bufname, "%s/tmp.%d", v->sfdir, getpid());
		if((fd = open(bufname, O_WRONLY|O_CREAT|O_TRUNC, 0644)) == -1) {
			mv_error(errno, "Unable to open temp file on disk.");
			close(fd);
			goto fail;
		}
		command.type = MC_COPY;	/* set up command to do copy */
		command.time = event->time;
		if(cmd_select(&command) < 0)		/* do the copy */
			goto fail;
		if(write(fd, c->sfbuff, (int) c->bufsize) < 1) {
			mv_error(errno, "Unable to write to temp file.");
			close(fd);
			clear_buffer();
			goto fail;
		}
		close(fd);	/* ready to go on now */

		/* set up the information struct to pass to requestor */
		
		strcpy(ext_info.name, bufname);
		ext_info.bufsize = c->bufsize;

		clear_buffer();			/* free memory */

		XChangeProperty(dpy,		/* load into property */
			event->requestor,
			event->property,
			event->target,
			format,
			PropModeReplace,
			(unsigned char *) &ext_info,
			(int) sizeof(ext_buff)); /* no. of bytes in struct */
		success = 1;
	}
fail: 	if(!success) {
		sn.xselection.property = None;
	}
	XSendEvent(dpy, sn.xselection.requestor, False, 0, &sn);
}

get_property(event)	/* transfers property into int. buffer for edit use */
	XSelectionEvent *event;
{
	is_buff = BUF_NONE;	/* default until successful */
	if((event->selection == XA_PRIMARY) && (event->property != None))
	{
		ext_buff ext_info;	/* external buffer info struct */
		long bufflen = 8192;	/* retrieval buffer length */
		long offset = 0;	/* offset into property    */
		Atom return_type;	/* property type recieved  */
		int fd, return_format;
		unsigned long nbytes_ret, bytes_left;
		unsigned char *return_buff;	/* pointer to the prop. data */

		XGetWindowProperty(dpy,		/* get property */
			event->requestor,
			event->property,
			offset, bufflen, False,
			event->target,
			&return_type, &return_format, &nbytes_ret,
			&bytes_left, &return_buff);
		if(nbytes_ret > 0 && return_format != 0)  /* if success */
		{
			int bytes;
			bcopy((char *) return_buff, (char *) &ext_info,
				sizeof(ext_buff));
			if((fd = open(ext_info.name, O_RDWR)) == -1) {
				mv_error(errno, "Unable to open temp file.");
				close(fd);
				goto fail;
			}
			clear_buffer();
			if(!alloc_buffer(ext_info.bufsize)) goto fail;
			if((bytes= read(fd,c->sfbuff,(int) ext_info.bufsize)) == -1) {
				mv_error(errno, "Unable to read temp file.");
				close(fd);
				clear_buffer();
				goto fail;
			}
			else {	/* set all other cut buffer parameters */
			
				c->bufsize = bytes;
				c->size = v->size;
				c->nchans = v->nchans;		/* for now */
				c->srate = v->srate;
				c->nsamps = c->bufsize/(c->nchans*c->size);
				c->is_float = v->is_float;	/* for now */
				c->cutproperty = event->property;
				/* flags for internal buffer */
				is_buff = BUF_INT;	
				yesbuff = 1;
				reset_buff_mode();	/* buffer now intern. */
			}
		}
		else mv_alert("get_property: XGetProperty failed.");
		/* free space taken by property */
fail:		XDeleteProperty(dpy, event->requestor, event->property);
		XFree((char *) return_buff);
		close(fd);
		unlink(ext_info.name);	/* remove temp file */
	}
	cmd_select(&command);	/* finish edit replace, etc. operation */
}

unselect_region(event)		/* for loss of selection ownership */
	XSelectionClearEvent *event;
{
	if(box & region){
		undraw_box();
		draw_hair(xloc, yloc);
		set_insert_point(xloc, yloc);
		is_owner = 0;
	}
}

/****************** Pointer and keyboard event processing ***************/

bp_select(event)		/* button pressed */
	XButtonPressedEvent *event;
{
	extern Menu *edit_menu, *option_menu, *alter_menu, *filter_menu;
	extern Menu *analysis_menu, *file_menu, *header_menu, *canvas_menu;

	int loc = event->x;
	int fracbar = v->width/nheaders; 
        unsigned e_mask = ButtonReleaseMask | ButtonMotionMask;

	if(event->window == canvas_win){
	    plot_pm = *((Pixmap *) canvas_get(canvas, LXC_PIXMAP));
	    switch (event->button){
            case Button1:
		XGrabPointer(dpy, canvas_win, True, e_mask, GrabModeAsync,
				GrabModeAsync, cwin, arrow_curs, event->time);
		if(region&is_owner){
			XSetSelectionOwner(dpy, XA_PRIMARY, None, event->time);
			is_owner = 0;
		}
		if(box) undraw_box(); 
		if(region) region = 0;
               	draw_hair(event->x, event->y);
               	break;
            case Button2:
		XGrabPointer(dpy, canvas_win, True, e_mask, GrabModeAsync,
			GrabModeAsync, cwin, arrow_curs, event->time);
		if(!line && !insert) draw_hair(event->x, event->y);
		if(!insert) set_insert_point(event->x, event->y);
               	draw_box(event->x, event->y);
               	break;
	    case Button3:
		menu_show(canvas_menu, event);
		break;
	    }
	}
	else if(event->window == mbar_win){
	    if(loc <= fracbar) menu_show(file_menu, event);
	    else if(loc<=2*fracbar) menu_show(edit_menu,event);
	    else if(loc<=3*fracbar) menu_show(alter_menu,event);
	    else if(loc<=4*fracbar) menu_show(filter_menu,event);
	    else if(loc<=5*fracbar) menu_show(option_menu,event);
	    else if(loc<=6*fracbar) menu_show(header_menu,event);
	    else if(loc<=7*fracbar) menu_show(analysis_menu,event);
	    cmd_select(&command);	/* process result of menu choice */
        }
}

pm_select(event)		/* mouse moved w/ button held */
	XPointerMovedEvent *event;
{
	XEvent evt;

	if(event->window != canvas_win) return;
	/* compress motion events before calling routines */
	while(XEventsQueued(event->display, QueuedAfterReading) > 0)
	{
		XEvent ahead;
		XPeekEvent(event->display, &ahead);
		if(ahead.type != MotionNotify) break;
		if(ahead.xmotion.window != event->window) break;
		XNextEvent(event->display, &evt);
		event = (XPointerMovedEvent *) &evt;
	}
        if (event->state & Button1Mask) {
                draw_hair(event->x, event->y);
        }
        else if (event->state & Button2Mask) {
                draw_box(event->x, event->y);
	}
}

br_select(event)		/* button released */
	XButtonReleasedEvent *event;
{
	if(event->window != canvas_win) return;
        switch (event->button) {
        case Button1:
		if(event->state & Button2Mask) return;
                set_insert_point(event->x, event->y);
		XUngrabPointer(dpy, event->time);
                break;
        case Button2:
		if(event->state & Button1Mask) return;
                set_region(event->x, event->y);
		XSetSelectionOwner(dpy, XA_PRIMARY, event->window, event->time);
		is_owner = 1;
		XUngrabPointer(dpy, event->time);
                break;
        } 
}
