/* 
	cmd.h
*/

typedef struct mv_command
{
	int type;
	Time time;
} CMD;

/* general menu command flags */
#define MC_NEWFILE	1

/* edit command flags */

#define MC_COPY		0x00000100
#define MC_REMOVE	0x10001101
#define MC_ERASE	0x11001101
#define MC_OUTSPLICE	0x10100102
#define MC_ZAP		0x11100102
#define MC_MIX		0x10001003
#define MC_REPLACE	0x10001004
#define MC_INSPLICE	0x10101005
#define MC_MULT		0x10001006
#define MC_CFADE	0x10001007

/* alter command flags */

#define MC_PHRASE	0x10011108
#define MC_INSERT	0x10001109
#define MC_REVERSE	0x1000110a
#define MC_TRANSPOSE	0x1001110b
#define MC_GRAVY	0x1001110c

/* filter command flags */

#define MC_MELL		0x1001110d
#define MC_RESON	0x1001110e
#define MC_COMB		0x1001110f
#define MC_ALLPASS	0x10011110
#define MC_TONE		0x10011111

/* other commands */

#define MC_HIST		0x00000101
#define MC_FFT		0x00000102

/* masks for command type */

#define READ_MASK	0x00000100
#define WRITE_MASK	0x00001000
#define ALTER_MASK	0x00010000
#define SPLICE_MASK	0x00100000
#define DELETE_MASK	0x01000000
#define MOD_MASK	0x10000000

/* masks for alter mode */

#define ALTER_REPLACE   0
#define ALTER_OVERWRITE 1
#define ALTER_MIX	2
