/****************************************************************************** 
 *
 *  mixview - X Window System based soundfile editor and processor
 *
 *  Copyright 1989 by Douglas Scott
 *
 *  Author:     Douglas Scott 
 *  Date:       May 1, 1989
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The author makes no representations about
 *  the suitability of this software for any purpose.  
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/
/*	
	cmd.c
*/

#include "main.h"
#include "dialog.h"
#include "mesg.h"
#include "cmd.h"
#include "menus.h"
#include "nobug.h"

extern Display *dpy;
extern Window canvas_win;
extern Cursor wait_curs, main_curs, mbar_curs;
extern sf_struct *v;
extern ebuf_struct *e;
extern cbuf_struct *c;
extern FLAG box, insert, region, is_saved, is_owner;
extern FLAG chscale, read_only, is_buff, yesbuff;
extern int xloc, yloc, xend, peak_rescan, lineset;

double last_edstart, last_edend;

FLAG ampmode;

int
cmd_select(cmd)
CMD *cmd;
{
	unsigned long nboffset; 
	unsigned totalbytes, new_size;
	int newloc;
	DBCOM(entering cmd_select);

	if(!cmd->type) return -1;	/* no command chosen */
	block_events();
	clear_events();			/* flush the event buffer first */
	if(cmd->type & READ_MASK) 	/* create & fill new cut buffer */
	{
		unsigned bufsize;
		int nsamps;
		DBCOM(---read mask section---);

		e->size = c->size = v->size;
		e->nchans = c->nchans = v->nchans;
		e->srate = c->srate = v->srate;
		e->is_float = c->is_float = v->is_float;
		if(cmd->type == MC_INSERT) { /* insert-space command */
			double idur;
			dialog->setValue(dialog, 0, 0.0);
			if(dialog->call(dialog,  D_QINSERT, "") < 1) {
				exit_cmd(cmd);
				return -1;
			}
			idur = dialog->getValue(dialog, 0);
			DBPRT(idur);
			nsamps = idur * v->srate;
			bufsize = nsamps*v->nchans*v->size;
			c->edstart = v->itime;
			c->edend = c->edstart + idur;
		}
		else {
			nsamps = ROUND((c->edend - c->edstart) * v->srate);
			bufsize = nsamps * c->nchans * c->size;
		}
		DBCOM(initial values for these);
		DBPRT(nsamps);
		DBPRT(c->edstart);
		DBPRT(c->edend);
		DBPRT(yesbuff);
	        DBPRT(is_buff);
		DBPRT(bufsize);

		/* determine offset (in bytes) into main buffer	*/

		nboffset = (int)(c->edstart*v->srate) * v->nchans*v->size;
		DBPRT(nboffset);

		/* check to see if read will go beyond EOF; if so,      */
		/* allocate more space before copying samps into buffer	*/

		totalbytes = nboffset + bufsize;
		if(totalbytes > v->bufsize) {
			if(setLength(totalbytes) < 0) {
				exit_cmd(cmd);
				return -1;
			}
		}
		if(cmd->type & DELETE_MASK){/* if region NOT to be copied */
		   DBCOM(delete mask section);
		   is_buff = BUF_INT;
		   if(e->nsamps == 0)
			c->cutproperty=v->cutproperty; /* set ATOM if not set */
		   e->nsamps = nsamps;
		   e->bufsize = bufsize;
		}
		else{				/* if region to be COPIED */
		   DBCOM(non delete -- copy -- section);

		   /* release old space */
		   clear_buffer();

		   e->nsamps = c->nsamps = nsamps;
		   e->bufsize = bufsize;

		   /* create new space in cut buffer */
		   if(!alloc_buffer(bufsize)) {
			exit_cmd(cmd);
			return -1;
		   }

		   /* if anything except space-inserting, copy into buff */

		   if(cmd->type != MC_INSERT) {
			bcopy(v->sfbuff+nboffset, c->sfbuff, (int) c->bufsize);
			yesbuff = 1;	/* set flag for buffer full */
		   }
		   DBCOM(bcopy done -- reset menu now);
		   reset_buff_mode();	/* resets mode menu */
		   is_buff = BUF_INT;	/* set flags */
		   c->cutproperty = v->cutproperty;	/* set ATOM */
		}
		if(cmd->type & SPLICE_MASK)	/* if splicing out a section */
		{
		   DBCOM(splice out mask section);
		   DBPRT(bufsize); DBPRT(v->bufsize); DBPRT(c->bufsize);
		   /* shift bytes to the left by size-of-cut-buffer */

		   bcopy(v->sfbuff+nboffset+bufsize, v->sfbuff+nboffset,
		         (int)(v->bufsize-nboffset-bufsize));
		   setLength(v->bufsize-bufsize);
		   DBCOM(after bcopy:);
		   DBPRT(v->bufsize);
		}
	}
	if(cmd->type & WRITE_MASK) /* cut buffer to be written into file */
	{
	   int graindiff = 0;
	   DBCOM(---write mask section---); 
	   DBCOM(values for these now);
	   DBPRT(c->nsamps); DBPRT(e->nsamps); DBPRT(c->edstart);
	   DBPRT(yesbuff); DBPRT(is_buff);
	   if(is_buff == BUF_EXT)	/* if buffer is external */
	   {
	    	DBCOM(go get selection);
	    	XConvertSelection(dpy,		/* go get it! */
	    		XA_PRIMARY,
	    		XA_STRING,
	    		v->cutproperty,
	    		canvas_win,
	    		cmd->time);
	   	return 1;
	   }
	   else if(is_buff == BUF_NONE)	/* failure to retrieve it */
	   {
	    	dialog->call(dialog, D_NEXTBUF, "");
	    	exit_cmd(cmd);
	    	return -1;
	   }
	   /* check for buffer compatibility with (new) sfile */

	   if(c->cutproperty != v->cutproperty) {
	    	mv_alert("Cut buff doesn't match new sfile format.");
	    	exit_cmd(cmd);
	   	return -1;
	   }
	   /* offset from beg. of file to start edit */

	   nboffset = (int)(v->itime*v->srate) * v->nchans*v->size;
	   DBPRT(nboffset);

	   ampmode = 0;	/* defaults */
	   lineset = 0;
	   /* if using stored buffer */
	   if(!(cmd->type & READ_MASK)) {
		DBCOM(stored buff- setting e vals = to c vals);
		e->nsamps = c->nsamps;
		e->bufsize = c->bufsize;
		e->size = c->size;
		e->nchans = c->nchans;
		e->srate = c->srate;
		   DBCOM(values for these now);
		   DBPRT(e->nsamps);
		   DBPRT(e->bufsize);
		   DBPRT(e->size);
		   DBPRT(e->nchans);
	   }

	   /* if command does NOT replace file with modified buffer */

	   if(!(cmd->type & ALTER_MASK)) {
	    	c->edstart = v->itime;
	    	c->edend = v->itime + (double) e->nsamps/v->srate;
	    	switch (cmd->type) { /* highlight area to be written into */
		case MC_MIX:
		case MC_REPLACE:
		case MC_INSPLICE:
		case MC_MULT:
		case MC_CFADE:
			xend = screen_loc(c->edend) - 1;
			draw_box(xend, yloc);
			region = 1;
			XSetSelectionOwner(dpy, XA_PRIMARY, canvas_win,
				CurrentTime);
			is_owner = 1;
			break;
		case MC_INSERT:
			xend = screen_loc(c->edend) - 1;
			draw_box(xend, yloc);
			region = 1;
			if(dialog->call(dialog,  D_CONFINS, "") < 1) {
				exit_cmd(cmd);
				return -1;
			}
			XSetSelectionOwner(dpy, XA_PRIMARY, canvas_win,
				CurrentTime);
			is_owner = 1;
			break;
		default:
			break;
	    	}
	    	/* query user for parameters for current cmd. */

	    	if(get_parameters(e, cmd->type, &new_size) < 1) {
	    		exit_cmd(cmd);
			return -1;
	    	}
		DBCOM(after get params:);
	    	if(new_size > e->bufsize) {	/* multiple buffer operation */
	    		int ntimes, bytesdiff;
	    		unsigned offset1 = 0, offset2 = c->bufsize;
	    		char *temp = c->sfbuff;
	    		DBCOM(multiple buffer);
	    		ntimes = new_size/c->bufsize - 1;
	    		if((temp = (char *) realloc(temp, new_size)) == (char *) NULL) {
				mv_error(errno,"Sorry - can't allocate copy buffer!");
	    			exit_cmd(cmd);
	    			return -1;
	    		}
	    		c->sfbuff = temp;
	    		while(ntimes--) {
	    			bcopy(c->sfbuff+offset1,
	    				c->sfbuff+offset2, (int) c->bufsize);
	    			offset1 += c->bufsize;
	    			offset2 += c->bufsize;
	    		}
	    		bytesdiff = new_size - c->bufsize;
	    		e->bufsize = c->bufsize = new_size;
	    		c->nsamps = e->nsamps;
	    		graindiff = bytesdiff/(c->size*v->grainsize*v->nchans);
	    		xend = screen_loc(c->edend) - 1;
	    		draw_box(xend+graindiff, yloc); /* shift box */
	    		set_region(xend, yloc);
	    	}
	   }	

	   /* if replacing section of file with modified buffer */

	   if(cmd->type & ALTER_MASK)
	   {	
	   	int bytesdiff, zerobytes, alter_mode;
	   	unsigned oldbufsize;
	   	DBCOM(alter mask section);
	    	/* query user for parameters for current cmd. */

	    	if(get_parameters(e, cmd->type, &new_size) < 1) {
	    		exit_cmd(cmd);
			return -1;
	    	}
		DBPRT(c->nsamps);
		DBPRT(e->nsamps);

	   	if(new_size != c->bufsize) {
	   		bytesdiff = new_size - c->bufsize;
	   		if(bytesdiff & 1) bytesdiff += 1;
	   		graindiff=bytesdiff/(v->size*v->grainsize*v->nchans);
	   		xend = screen_loc(c->edend) - 1;
	   		draw_box(xend+graindiff, yloc); /* shift box */
	   		if(query_alter_mode(&alter_mode) < 1) {
	   			exit_cmd(cmd);
	   			return -1;
	   		}
	   		c->edstart = v->itime;
	   		set_region(xend, yloc);
	   	}
	   	else alter_mode = ALTER_MIX;
	   	switch(alter_mode){
	   	case ALTER_MIX:
	   		zerobytes = c->bufsize;
	   		break;
	   	case ALTER_OVERWRITE:
			DBCOM(overwrite option);
	   		zerobytes = new_size > c->bufsize ? new_size :
	   			   			    c->bufsize;
			DBPRT(zerobytes);
	   		totalbytes = nboffset + zerobytes;
			/* if edit area extends beyond EOF */
	   		if(totalbytes > v->bufsize) {
	   			if(setLength(totalbytes) < 0) {
	   				exit_cmd(cmd);
	   				return -1;
	   			}
	   		}
	   		break;
	   	case ALTER_REPLACE:
			DBCOM(replace option);
	   		zerobytes = new_size;
			DBPRT(zerobytes);
	   		oldbufsize = v->bufsize;
	   		totalbytes = v->bufsize + bytesdiff;
			/* if replaced edit area is larger size than orig */
	   		if(totalbytes > v->bufsize) {
	   			if(setLength(totalbytes) < 0) {
	   				exit_cmd(cmd);
	   				return -1;
	   			}
				bcopy(v->sfbuff+nboffset+c->bufsize,
				      v->sfbuff+nboffset+c->bufsize+bytesdiff,
				      (int) (oldbufsize-nboffset-c->bufsize));
	   		}
			else if(totalbytes < v->bufsize) {
				bcopy(v->sfbuff+nboffset+c->bufsize,
				      v->sfbuff+nboffset+c->bufsize+bytesdiff,
				      (int) (oldbufsize-nboffset-c->bufsize));
	   			setLength(totalbytes);
			}
	   		break;
	   	}
	   	bzero(v->sfbuff+nboffset, zerobytes); /* clear edit region */
		DBCOM(bzero done);
	   }	 
	   /* a simple edit-write operation */
	   else {	
	   	DBCOM(simple write operation section);
	   	if(cmd->type == MC_INSERT)
	   		cmd->type = MC_INSPLICE;
	   	if(cmd->type & SPLICE_MASK) /* if splicing in a section */
	   	{
	   		unsigned oldbufsize = v->bufsize;
	   		DBCOM(splice in mask section);
	   		if(setLength(v->bufsize+c->bufsize) < 0) {
	   			exit_cmd(cmd);
	   			return -1;
	   		}
	   		bcopy(v->sfbuff+nboffset,
	   			v->sfbuff+nboffset+c->bufsize,
	   			(int)(oldbufsize-nboffset));
	   		DBCOM(end of buffer shifted right);
	   	}
	   	/* check to see if write will go beyond EOF */
	   	totalbytes = nboffset + c->bufsize;
	   	if(totalbytes > v->bufsize) {
	   		if(setLength(totalbytes) < 0) {
	   			exit_cmd(cmd);
	   			return -1;
	   		}
	   	}
	   }

	   /* set up edit-transfer buffer */
	   /* set buffer == whole soundfile if rescaling */

	   DBCOM(just about to set pointer into edit buffer);
	   e->sfbuff = v->sfbuff + nboffset; /* ptr. to beg. of edit */

	   DBCOM(done setting up);
	   DBCOM(just before edit done ---);
	   DBPRT(c->nsamps);
	   DBPRT(e->nsamps);
	   DBPRT(e->nchans);
	   DBPRT(yesbuff);
	   DBPRT(is_buff);
	}

	last_edstart = c->edstart;	/* store for recall later */
	last_edend = c->edend;

	/* reset buffer flag if it was just used for DELETE operation */

	if(cmd->type&DELETE_MASK && !yesbuff) is_buff = BUF_NONE; 

         /* main switch for edit operations */

	switch(cmd->type & ~DELETE_MASK) {
	case MC_COPY:
		undraw_box();
		v->itime = c->edend;
		newloc = screen_loc(v->itime);
		draw_hair(newloc, yloc);
		set_insert_point(newloc, yloc);
		break;
	case MC_REMOVE:
		mv_remove(e);
		undraw_box();
		v->itime = c->edend;
		set_line_loc();
		set_insert_point(xloc, yloc);
		break;
	case MC_OUTSPLICE:
		undraw_box();
		v->itime = c->edstart;
		set_line_loc();
		set_insert_point(xloc, yloc);
		break;
	case MC_MIX:
		mv_mix(c, e);
		set_box_loc();	/* leave region highlighted */
		break;
	case MC_REPLACE:
		mv_replace(c, e);
		set_box_loc();	/* leave region highlighted */
		break;
	case MC_INSPLICE:
		mv_replace(c, e);
		set_box_loc();	/* leave region highlighted */
		break;
	case MC_MULT:
		mv_mult(c, e);
		set_box_loc();	/* leave region highlighted */
		break;
	case MC_CFADE:
		mv_cfade(c, e);
		set_box_loc();
		break;
	case MC_PHRASE:
		mv_phrase(c, e);
		set_box_loc();
		break;
	case MC_REVERSE:
		mv_reverse(e);
		set_box_loc();
		break;
	case MC_TRANSPOSE:
		mv_trans(c, e);
		set_box_loc();
		break;
	case MC_GRAVY:
		mv_gravy(c, e);
		set_box_loc();
		break;
	case MC_MELL:
		mv_mell(c, e);
		set_box_loc();
		break;
	case MC_RESON:
		mv_reson(c, e);
		set_box_loc();
		break;
	case MC_COMB:
		mv_comb(c, e);
		set_box_loc();
		break;
	case MC_TONE:
		mv_tone(c, e);
		set_box_loc();
		break;
	case MC_FFT:
		break;
	default:
		break;
	}
	set_menus();	 			     /* set menu statuses */
	/* set new dur */
	v->sfdur = (double) v->bufsize /(v->srate * v->nchans * v->size); 
	DBCOM(finishing up now);
	DBCOM(\n);
	set_screen_times(1);
	set_view_display();
	if(cmd->type & MOD_MASK) {
		if(peak_rescan == 2) {		/* query */
			if(dialog->call(dialog, D_QRESCALE, "") == YES) {
				clear_events();
				mesg->On(mesg, "Scanning for peak amp...");
				v->peakamp = get_peakamp(1); 
			}
		}
		else if(peak_rescan == 1) {	/* automatic */
			clear_events();
			mesg->On(mesg, "Scanning for peak amp...");
			v->peakamp = get_peakamp(1); 
		}
		else;				/* no rescan */
		is_saved = 0;
		chscale = 1;
		display_it(1);
	}
	unblock_events();
	mesg->Off(mesg);
	cmd->type = 0;				     /* reset */
	return 1;
}

clear_events()	/* process queued events (prior to some long calculation) */
{
	XSync(dpy, 0); 
	while(XEventsQueued(dpy, QueuedAfterReading) > 0) {
		XEvent evt;
		XNextEvent(dpy, &evt);
		if(lxt_event(&evt))
			continue;
	}
}

exit_cmd(cmd)
CMD *cmd;
{
	unblock_events();
	mesg->Off(mesg);
	cmd->type = 0;
	set_menus();
}


setLength(new_len)	/* routine for reallocating memory for buffers */
unsigned new_len;
{
	char *temp = v->sfbuff;

	DBCOM(entering setLength);
	if((temp = (char *) realloc(temp, new_len)) == (char *) NULL) {
		mv_error(errno, "Sorry - Can't allocate enough space!");
		return(-1);
	}
	v->sfbuff = temp;
	if(new_len > v->bufsize)
		bzero(v->sfbuff+v->bufsize, (int)(new_len-v->bufsize));
	v->bufsize = new_len;
	DBCOM(exiting setLength);

	return((int) new_len);
}

alloc_buffer(size)
unsigned size;
{
	if((c->sfbuff = (char *) calloc(size,sizeof(char))) == NULL) {
		mv_error(errno, "Sorry - can't allocate copy buffer!");
		c->bufsize = 0;
		return -1;
	}
	c->bufsize = size;
	DBCOM(space allocated for cbuff);
	return (int) c->bufsize;
}

clear_buffer()	/* clears cut buffer if used in external transfer */
{
	if(!c->bufsize) return;
	cfree(c->sfbuff);
	DBCOM(space released from cbuff);
	c->bufsize = 0;
	is_buff = BUF_NONE;
	yesbuff = 0;
	set_menus();
}

set_edit(cb, sf, start, end) /* uses cut buff as temp pointer into main */
cbuf_struct *cb;
sf_struct *sf;
double start, end;
{
	int nboffset = (int)(start*sf->srate) * sf->nchans*sf->size;
	cb->sfbuff = sf->sfbuff + nboffset; /* ptr. to beg. of edit */
	cb->size = sf->size;
	cb->is_float = sf->is_float;
	cb->nchans = sf->nchans;
	cb->srate = sf->srate;
	cb->nsamps = (end-start) * cb->srate;
	cb->bufsize = cb->nsamps * cb->nchans * cb->size;
	cb->inptr = cb->outptr = 0;
	cb->peakamp = sf->peakamp;
	cb->cutproperty = sf->cutproperty;
}
	
int
get_parameters(b, cmdtype, newbufsize)
ebuf_struct *b;
int cmdtype;
unsigned *newbufsize;
{
	int code = YES; 	/* default */
	DBCOM(entering get_parameters);

	*newbufsize = b->bufsize;

	switch(cmdtype) {
	case MC_MIX:
		if(*newbufsize = mix_set(b))
			mesg->On(mesg, "Mixing into selected region...");
		break;
	case MC_REPLACE:
		if(*newbufsize = replace_set(b))
			mesg->On(mesg, "Replacing selected region...");
		break;
	case MC_INSPLICE:
		if(*newbufsize = insplice_set(b))
			mesg->On(mesg, "Splicing buffer in...");
		break;
	case MC_MULT:
		if(*newbufsize = mult_set(b))
			mesg->On(mesg, "Multiplying by selected region...");
		break;
	case MC_CFADE:
		if(*newbufsize = cfade_set(b))
			mesg->On(mesg, "Crossfading with selected region...");
		break;
	case MC_PHRASE:
		if(*newbufsize = phrase_set(b))
			mesg->On(mesg, "Phrasing selected region...");
		break;
	case MC_TRANSPOSE:
		if(*newbufsize = trans_set(b))
			mesg->On(mesg, "Transposing selected region...");
		break;
	case MC_GRAVY:
		if(*newbufsize = gravy_set(b))
			mesg->On(mesg, "\"Gravy-ing\" selected region...");
		break;
	case MC_MELL:
		if(*newbufsize = mell_set(b))
			mesg->On(mesg, "Filtering selected region...");
		break;
	case MC_TONE:
		if(*newbufsize = tone_set(b))
			mesg->On(mesg, "Filtering selected region...");
		break;
	case MC_RESON:
		if(*newbufsize = reson_set(b))
			mesg->On(mesg, "Filtering selected region...");
		break;
	case MC_COMB:
		if(*newbufsize = comb_set(b))
			mesg->On(mesg, "Filtering selected region...");
		break;
	case MC_INSERT:
		tab_set(b);
		mesg->On(mesg, "Inserting selected region...");
		break;
	case MC_REMOVE:
		mesg->On(mesg, "Removing selected region...");
		code = YES;
		break;
	case MC_REVERSE:
		mesg->On(mesg, "Reversing selected region...");
		code = YES;
		break;
	case MC_OUTSPLICE:
		mesg->On(mesg, "Splicing out selected region...");
		code = YES;
		break;
	case MC_ERASE:
		mesg->On(mesg, "Erasing selected region...");
		code = YES;
		break;
	default:
		code = CANCEL;
	}
	DBPRT(*newbufsize);
	if(*newbufsize == 0) code = CANCEL;
	DBCOM(exiting get_parameters);
	clear_events();
	return(code);
}
	
query_alter_mode(mode)
int *mode;
{
	int code;
	dialog->setChoice(dialog, 0, ALTER_REPLACE);	/* default */
	if((code = dialog->call(dialog, D_QAMODE, "")) < 1) return(code);
	*mode = dialog->getChoice(dialog, 0);
	return(code);
}

/*************************************************************************/

CMD command;

cmd_check(cmd)	/* check keybd. command against edit state */
CMD *cmd;
{
	if(region) {
		if((cmd->type & READ_MASK) && (cmd->type != MC_INSERT)) return;
		else cmd->type = 0;
	}
	else if(insert && is_buff) {
		if(cmd->type == MC_INSERT) return;
		if((cmd->type & WRITE_MASK) && !(cmd->type & READ_MASK)) return;
		else cmd->type = 0;
	}
	else cmd->type = 0;
}

void
menu_select(m, mi) /* called by all edit/alter/filter menus */
Menu *m;
Menu_item *mi;
{
	command.type = get_item_command(mi);
	command.time = get_item_time(mi);
}

void
do_hist(menu, menu_item)
Menu *menu;
Menu_item *menu_item;
{
}
