#include <stdio.h>
#include <sys/wait.h>
#include <sys/errno.h>
#include <signal.h>
#include <fcntl.h>


#include "xplay.h"

char speed_buf[SPEED_LEN];
char limit_buf[LIMIT_LEN];
char exec_res[100], convert_res[100];
char song_name_buf1[NAME_LEN],song_name_buf2[NAME_LEN];
char lim_low[10],lim_hi[10];
char *exec_buf[30];
char *av[30];
char *progt;
char *iface_name[20];
char *convert_name[20];
char *conv_buf[20];
int ns;
char *exectmp;
static int graph_data;
int  firstload;  
char *edit_buf1,*edit_buf2; 			/* edit buffer for samples */
char *temp_buf1,*tempbuf2;
char *temp1,*temp2;
char *env_buf;
int modified = 0;			/* 1, if sample was modified */
int x1_old = 0, x2_old = 0;             /* coordiantes of old select window */
header_data options;                    /* commandline options */
int visible_sample;			/* visible part of sample */
DWORD start_visible;			/* pointer to first data displayed */
int pid=-1; 				/* pid of the play process */
Arg args[3];


Display *dpy;
Screen *screen;
Marker  marker;



static XContext dialog_context = None;

#define DISC_CON_QUIT 1
#define DISC_CON_LOAD 2
#define DISC_CON_RECORD 3

/* additional resources */

/* Structure containing information about the user */
typedef struct _UserInfo {
  int uid, gid;
  char home[MAXPATHLEN];
  char shell[MAXPATHLEN];
  int arg0flag;
  mode_t umask;
} UserInfo;



/* struct for prog exec info   */
typedef struct _Exec_file {
char name[20];
char progt[30];
char *av[20];
} Exec_file;

typedef struct {
   String speed;	/* default speed */
   String limit;	/* default limit */
   String version;	/* check, if resource file is loaded */
   String convertRes;
   String execRes;
} Resources;

Resources resources;
Marker  marker;
Exec_file exec_1;
Exec_file exec_2;

static XtResource resource_list[] = {
   { "speed",                         /* resource name */ 
     "Speed",                         /* resource class */ 
     XtRString,                       /* resource type */ 
     sizeof(String),                  /* size of type */ 
     XtOffsetOf(Resources, speed),    /* name of field in struct */
     XtRString,                       /* default type */
     "22050" },                       /* default */
   { "limit", "Limit", XtRString, sizeof(String), XtOffsetOf(Resources, limit),
     XtRString, "10" },
   { "version", "Version", XtRString, sizeof(String),
     XtOffsetOf(Resources, version), XtRString, "no version" },
   { "convertRes", "Convert", XtRString, sizeof(String),
     XtOffsetOf(Resources, convertRes), XtRString, "/root/.xwave_convert" },
   { "execRes", "Exec", XtRString, sizeof(String),
     XtOffsetOf(Resources, execRes), XtRString, "/root/.xwave_exec" },

};

Widget top_level;                    /* the top-level widget */
widget_structure ww;                 /* widget tree */
graph_ctx g_ctx;                     /* graphics context */
graph_ctx g_ctx1;

static XtActionsRec action_list[] = {
   {"PopdownFileDialog", popdown_file_dialog_action}, 
   {"SetLimitBorders", set_limit_borders_action}, 
   {"ExposeGraph", expose_graph_action}
};

#include "xwave_dlgs.h"
#include "xedit.h"
#include "xexec.h"
#include "xlist.h"   


void main (int argc, char **argv)
{
   XtAppContext app_context; 
   Pixmap title;
   Widget w;
   int fd,n,i,j,k,l; 
   char ch;

   top_level = XtVaAppInitialize (&app_context,
      "XPlay", 				/* application class */
      NULL, 0, 				/* command line option list */
      &argc, argv, 
      NULL, NULL);

   dpy = XtDisplay(top_level);           /* get the display pointer */
   screen = XDefaultScreenOfDisplay(dpy);

   /* set the applications action routines */

   XtAppAddActions(app_context, action_list, XtNumber(action_list));

   /* get the application resources */

   XtGetApplicationResources(top_level, &resources, resource_list, 
                             XtNumber(resource_list), NULL, 0);
   if (!strcmp(resources.version, "no version")) 
      XtAppWarningMsg(app_context, "noAppContext", 
      "getApplicationResources", "Resources", 
      "Could not open application defaults file", NULL, NULL);
   strncpy(speed_buf, resources.speed, sizeof(speed_buf));
   strncpy(limit_buf, resources.limit, sizeof(limit_buf));
   strncpy(exec_res, resources.execRes, sizeof(exec_res));
   strncpy(convert_res, resources.convertRes, sizeof(convert_res));
	strcpy(song_name_buf1, " ");
        strcpy(song_name_buf2, " ");


/************* convert exec resources to array of strings   *************/
read_args2_buf(exec_buf,exec_res);
for( i = 0 ; i< 6 ; i++){ 
	ns=split1(exec_buf[i],':',av) ;
iface_name[i]=av[0];
}
for( i = 0 ; i< 6; i++)
av[i]=NULL;

   /* convert the pixmaps */

   title = XCreateBitmapFromData(dpy, DefaultRootWindow(dpy), 
   				title_bits, title_width, title_height);

   /* install the icon pixmap */

   XtVaSetValues (top_level, XtNiconPixmap, title, NULL);
   XtVaSetValues (top_level, XtNtitle, "XWave Version 0.01", NULL);
   XtVaSetValues (top_level, XtNiconName, "XWave", NULL);

   /* create the widget hierarchy */
/*  limit_buf=limit_buf;

limit_buf_low="0";
limit_buf_hi=limit_buf;
*/
   create_widget_hierarchy(top_level, speed_buf, limit_buf, 
				iface_name,
 			   song_name_buf1, song_name_buf2, 
                           &g_ctx,&g_ctx1);

   /* now realize the widget tree... */

   XtRealizeWidget (top_level);

   /* ...and sit around forever waiting for events! */

   XtAppMainLoop (app_context);
}

/* callbacks and subroutines */

void quit_question(Widget w, XtPointer client_data, XtPointer call_data)
{
   if ((edit_buf1 != NULL) && (modified)) 
      discard_question(DISC_CON_QUIT);		/* quit, if discard */
   else
      quit_application();
}

void quit_application()
{
   XtReleaseGC(top_level, g_ctx.graph_GC);
   XtReleaseGC(top_level, g_ctx.line_GC);
   XtReleaseGC(top_level, g_ctx.delete_line_GC);
   XtReleaseGC(top_level, g_ctx1.graph_GC);
   XtReleaseGC(top_level, g_ctx1.line_GC);
   XtReleaseGC(top_level, g_ctx1.delete_line_GC);
   XtDestroyWidget(top_level);
   exit(0);
}

void stop_playing(Widget w, XtPointer client_data, XtPointer call_data)
{
   kill((pid_t)pid, SIGKILL);	/* kill the play process */
   XtSetSensitive(w, False);
   pid = -1;
}

void play_sample(Widget w, XtPointer client_data, XtPointer call_data)
{
   get_changeable_options();

if((graph_data)&&(edit_buf2 == NULL))
 {
      err(1, "No sample loaded in buf 2");
      return;
 }

   if ((!graph_data)&&(edit_buf1 == NULL)) {
      err(1, "No sample loaded in buf 1");
      return;
   }

   if (pid > 0) {
      if (waitpid((pid_t)pid, NULL, WNOHANG) == 0) { 
         err(1, "Play process has\nnot yet finished!");
         return;
      }
   }
   get_changeable_options();
   pid = fork();		/* create play process */
   XtSetSensitive(ww.stop_btn, True);
   if (!pid) {			/* we are the play process */
      XtDestroyApplicationContext(XtWidgetToApplicationContext(w));
if(graph_data)
      recplay(NULL, PLAY, options, edit_buf2);
else
      recplay(NULL, PLAY, options, edit_buf1);
      exit(0);			/* finish playing - kill the process */
   } else if (pid <= 0) {
      err(1, "Process creation failed!");
      return;
   } 
   /* simply return after process creation */
}

void get_changeable_options()
{
   char *wid;
   char *pointer;
   wave_header head;

if(graph_data) pointer=edit_buf2;
else pointer = edit_buf1;
if(pointer){
  memcpy(&head, pointer, sizeof(head));
   if (!header_check(&head)) return;

   /* force all options */
   options.force_speed = options.force_stereo = options.force_sample_size = 1;
   options.quiet_mode = 1;	/* always quiet */
   options.speed = head.sample_fq;
   options.stereo = (head.modus == 2);
   options.sample_size = head.bit_p_spl;
   /* calculate full time limit */
   options.time_limit = (float) head.data_length / 
                        (float) (head.sample_fq * head.modus);
   sprintf(limit_buf, "%.1f", options.time_limit);

   options.lower_border = 0;
   options.upper_border = head.data_length;
   visible_sample = head.data_length;	/* whole sample is to be seen */
   start_visible = 0;   }

   options.speed = atoi(speed_buf); 
   wid = (char *) XawToggleGetCurrent(ww.stereo_btn);
   options.stereo = strcmp(wid, "MON");
   wid = (char *) XawToggleGetCurrent(ww.graph_1);
   graph_data = strncmp(wid, "GR2",3);
   wid = (char *) XawToggleGetCurrent(ww.eight_bit_btn);
   if (wid[1] == '8')
      options.sample_size = 8;
   else if (wid[1] == '2') 
      options.sample_size = 12;
   else
      options.sample_size = 16;
   sscanf(limit_buf, "%f", &options.time_limit);
}

void record_question(Widget w, XtPointer client_data, XtPointer call_data)
{

   if (edit_buf2 != NULL || edit_buf1 != NULL ) {
      if (pid > 0) {
         if (waitpid((pid_t)pid, NULL, WNOHANG) == 0) { 
            err(1, "Play process has\nnot yet finished!");
            return;
         }
      }
      if (!modified) {
if(graph_data && edit_buf2){
         XtFree(edit_buf2);
         edit_buf2=NULL;  
         strcpy(song_name_buf2, "");
         XtSetArg(args[0], XtNstring, song_name_buf2);
         XtSetValues(ww.song_title2, args, 1);

}
else if(edit_buf1){
         XtFree(edit_buf1);
         edit_buf1=NULL; 
         strcpy(song_name_buf1, "");
         XtSetArg(args[0], XtNstring, song_name_buf1);
         XtSetValues(ww.song_title1, args, 1);    }

         x1_old = x2_old = 0;
         update_display();
         XFlush(dpy);
         record_sample();
      } else
         discard_question(DISC_CON_RECORD);		/* record, if discard */
   } else
      record_sample();
}

void record_sample()
{
   wave_header head;
   DWORD buf_siz;

   get_changeable_options();

   /* force all options */
   options.force_speed = options.force_stereo = options.force_sample_size = 1;
   options.quiet_mode = 1;	/* always quiet */
   options.lower_border = 0;

   /* allocate the edit buffer */
   buf_siz = options.speed * options.time_limit;
   if (options.stereo) buf_siz *= 2;
   if (options.sample_size != 8) buf_siz *= 2;
   buf_siz += 30;                /* 30 additional bytes */
if (graph_data){
   edit_buf2 = XtMalloc(buf_siz);
   recplay(NULL, RECORD, options, edit_buf2);  
   memcpy(&head, edit_buf2, sizeof(head));   }
else{
   edit_buf1 = XtMalloc(buf_siz);
   recplay(NULL, RECORD, options, edit_buf1);
   memcpy(&head, edit_buf1, sizeof(head));
}

   options.upper_border = head.data_length;
   visible_sample = head.data_length;	/* whole sample is to be seen */
   start_visible = 0;
   modified = 1;

   update_display();
}

void update_display()
{
   Window win = XtWindow(ww.graph2);		/* get window ID */
   Window win1 = XtWindow(ww.graph1);
   XPoint pt1[GRAPH_WIDTH+1], pt2[GRAPH_WIDTH+1];
   wave_header head;
   int factor;
   int step;
   char *pointer;
   int i,n;
   DWORD max_sample_data;
   int base_y1=0, base_y2=0;			/* baselines */
   union sample_data {
      char data8;				/* 8 bit per sample */
      unsigned int data16;			/* 12, 16 bit per sample */
   } sample1, sample2;

 get_changeable_options();

 if (graph_data){
   if (edit_buf2 == NULL) return; 
   XClearArea(dpy, win1, 0, 0, 0, 0, False);
pointer = edit_buf2;
}
else{
   if (edit_buf1 == NULL) return;
   XClearArea(dpy, win, 0, 0, 0, 0, False);
pointer = edit_buf1;
}
   memcpy(&head, pointer, sizeof(head));
   pointer += sizeof(head);
   pointer += start_visible;

   step = visible_sample / GRAPH_WIDTH;	/* step index */
   if (!step) step=1;

   if (head.modus == 2) {
      base_y1 = 0;
      base_y2 = GRAPH_HEIGHT/3;
      factor = GRAPH_HEIGHT/2;
      pt1[0].x = pt2[0].x = 0;
      pt1[0].y = base_y2;
      pt2[0].y = base_y2*2;
   } else {
      base_y1 = 0;
      factor = GRAPH_HEIGHT;
      pt1[0].x = 0;
      pt1[0].y = GRAPH_HEIGHT/2;
   }

   sample1.data16 = sample2.data16 = 0;		/* clear union */
      
   for (i=1; i<=GRAPH_WIDTH; i++, pointer += step) {	/* draw graph */
      if (head.bit_p_spl != 8) {
         sample1.data16 = (unsigned int) *pointer;
         sample2.data16 = (unsigned int) *(pointer+1);
         max_sample_data = 65535;
      } else {
         sample1.data8 = (char) *pointer;
         sample2.data8 = (char) *(pointer+1);
         max_sample_data = 255;
      }
      /* normalize and plot */
      pt1[i].x = i;
      pt1[i].y = base_y1 + sample1.data16 * factor / max_sample_data; 
      if (head.modus == 2) {
         pt2[i].x = i;
         pt2[i].y = base_y2 + sample2.data16 * factor / max_sample_data; 
      }
   }
if (graph_data){
   XDrawLines(dpy, win1, g_ctx1.graph_GC, pt1, GRAPH_WIDTH+1, CoordModeOrigin);
   if (head.modus == 2)
      XDrawLines(dpy, win1, g_ctx1.graph_GC, pt2, GRAPH_WIDTH+1, CoordModeOrigin);
}
else{
 XDrawLines(dpy, win, g_ctx.graph_GC, pt1, GRAPH_WIDTH+1, CoordModeOrigin);
 if (head.modus == 2)
    XDrawLines(dpy, win, g_ctx.graph_GC, pt2, GRAPH_WIDTH+1, CoordModeOrigin);
}
if(firstload == 1){
for( i = 0 ; i < 499 ; i++)
wave_envelope_filter[i][1] = 0; 

   calculate_limit_borders();
firstload=2;
}
else{
for( i = 0 ; i < 499 ; i++)
if(wave_envelope_filter[i][1] == i )
for(n = i+1 ; n < 499 ; n++ )
if(wave_envelope_filter[n][1] == n ){
if (graph_data)
XDrawLine(dpy, win, g_ctx.line_GC, wave_envelope_filter[i][1], wave_envelope_filter[i][2], wave_envelope_filter[n][1], wave_envelope_filter[n][2]);
else
XDrawLine(dpy, win1, g_ctx1.line_GC, wave_envelope_filter[i][1], wave_envelope_filter[i][2], wave_envelope_filter[n][1], wave_envelope_filter[n][2]);

i=n-1;  n=499;
}

/* draw_limit_borders(marker.x1, marker.x2);    */
 calculate_limit_borders();
}  
}

void set_limit_borders_action(Widget w, XEvent *event, String *params, 
                              Cardinal *num_params)
{
   Window win = XtWindow(w);
   Window win1 = XtWindow(w);
   int win_x, win_y; 
   int x, y;
   unsigned int mask;
   wave_header head;
   Window root, child;
   float limit_val;
   int step, old_upper, old_lower;

       firstload=-1;
 get_changeable_options();

if(graph_data)
   if (!edit_buf2) return;
else
   if (!edit_buf1) return;

if ((win != event->xany.window)||(win1 != event->xany.window)) return;  /* event has to come from graph */

   XQueryPointer(dpy, win, 
                 &root,            /* root window under the pointer */
                 &child,           /* child window under the pointer */
                 &x, &y,           /* pointer coords relative to root */
                 &win_x, &win_y,   /* pointer coords relative to window */
                 &mask);           /* state of modifier keys and buttons */

   memcpy(&head, edit_buf1, sizeof(head));


   step = visible_sample / GRAPH_WIDTH;

   /* set lower_border if Button1 was pressed, set upper border if 
      Button2 was pressed, otherwise set borders to default values */
   if (mask & Button1Mask) {
      old_lower = options.lower_border;
      options.lower_border = win_x * step + start_visible;
      if (options.upper_border < options.lower_border) {
         err(1, "Lower border must not exceed\nupper border!");
          options.lower_border = old_lower;
         return;
      }
 marker.x1 = win_x;  
draw_limit_borders(win_x, x2_old);   
   } else if (mask & Button2Mask) {
      old_upper = options.upper_border;
      options.upper_border = win_x * step + start_visible;
      if (options.upper_border < options.lower_border) {
         err(1, "Lower border must not exceed\nupper border!");
         options.upper_border = old_upper;
         return;
      } 
      marker.x2 = win_x;   
      draw_limit_borders(x1_old, win_x);
   } 
else if (mask & Button3Mask) {

   XDrawLine(dpy, win, g_ctx.line_GC, win_x, win_y, win_x + 1, win_y + 1);
   XDrawLine(dpy, win1, g_ctx1.line_GC, win_x, win_y, win_x + 1, win_y + 1); 
wave_envelope_filter[win_x][1]=win_x;
wave_envelope_filter[win_x][2]=win_y;

   }


else {
      options.lower_border = start_visible;
      options.upper_border = visible_sample + start_visible;
      draw_limit_borders(marker.x1, marker.x2);
   }
   limit_val = (float)(options.upper_border - options.lower_border) / 
                (float)(head.sample_fq * head.modus);
   sprintf(limit_buf, "%.1f", limit_val);
   XtSetArg(args[0], XtNstring, limit_buf);
   XtSetValues(ww.limit, args, 1);
   XFlush(dpy);
}

void calculate_limit_borders()
{
   int x1, x2, step;
   float limit;
   wave_header head;

 get_changeable_options();

if(graph_data){
   if (!edit_buf2) return;
   memcpy(&head, edit_buf2, sizeof(head));    }
else{
   if (!edit_buf1) return;
   memcpy(&head, edit_buf1, sizeof(head));   }

   step = visible_sample / GRAPH_WIDTH;
   if (!step) step=1;

   sscanf(limit_buf, "%f", &limit);
   if (limit < 0.0001) return;

   options.upper_border = limit * head.sample_fq * head.modus + 
                           options.lower_border;

   x1 = (options.lower_border - start_visible) / step;
   x2 = (options.upper_border - start_visible) / step;

   draw_limit_borders(x1, x2);
}

void draw_limit_borders(int x1, int x2)
{
   Window win = XtWindow(ww.graph2);
   Window win1 = XtWindow(ww.graph1);

 get_changeable_options();

if(graph_data){
   XDrawLine(dpy, win, g_ctx.delete_line_GC, x1_old, 0, x1_old, GRAPH_HEIGHT);
   XDrawLine(dpy, win, g_ctx.delete_line_GC, x2_old, 0, x2_old, GRAPH_HEIGHT);
   XDrawLine(dpy, win, g_ctx.line_GC, x1, 0, x1, GRAPH_HEIGHT);
   XDrawLine(dpy, win, g_ctx.line_GC, x2, 0, x2, GRAPH_HEIGHT);
}
else{
   XDrawLine(dpy, win1, g_ctx1.delete_line_GC, x1_old, 0, x1_old, GRAPH_HEIGHT);
   XDrawLine(dpy, win1, g_ctx1.delete_line_GC, x2_old, 0, x2_old, GRAPH_HEIGHT);
   XDrawLine(dpy, win1, g_ctx1.line_GC, x1, 0, x1, GRAPH_HEIGHT);
   XDrawLine(dpy, win1, g_ctx1.line_GC, x2, 0, x2, GRAPH_HEIGHT);
}

   XFlush(dpy);

   x1_old = x1;
   x2_old = x2;
}

void zoom_out(Widget w, XtPointer client_data, XtPointer call_data)
{
   wave_header head;
if(graph_data)
   memcpy(&head, edit_buf2, sizeof(head));
else
   memcpy(&head, edit_buf1, sizeof(head));

   visible_sample = head.data_length;
   start_visible = 0;
   update_display();
}

void zoom_in(Widget w, XtPointer client_data, XtPointer call_data)
{
   visible_sample = options.upper_border - options.lower_border;
   start_visible = options.lower_border;
   update_display();
}

void open_dialog(Widget w, XtPointer client_data, XtPointer call_data)
{
   if (w == ww.load_btn) {
   get_changeable_options();

      if ((edit_buf1 != NULL)||(edit_buf2 != NULL)) {   
         if (!modified) {
if((graph_data)&&(edit_buf2 != NULL)){
            XtFree(edit_buf2);
            edit_buf2=NULL; 
   strcpy(song_name_buf2, "");
            XtSetArg(args[0], XtNstring, song_name_buf2);
            XtSetValues(ww.song_title2, args, 1);

  }
else if((!graph_data)&&(edit_buf1 != NULL)) {
            XtFree(edit_buf1);
            edit_buf1=NULL; 
   strcpy(song_name_buf1, "");
            XtSetArg(args[0], XtNstring, song_name_buf1);
            XtSetValues(ww.song_title1, args, 1);

  }

            x1_old = x2_old = 0;
/*            update_display(); */    
            XFlush(dpy);
         } else {
            discard_question(DISC_CON_LOAD);		/* load, if discard */
            return;
         }
}     
if(graph_data)
      popup_file_dialog (w, "Load file: ", song_name_buf2, load_file);
else
      popup_file_dialog (w, "Load file: ", song_name_buf1, load_file);
   } else
if(graph_data)
      popup_file_dialog (w, "Save as: ", song_name_buf2, save_file);
else 
      popup_file_dialog (w, "Save as: ", song_name_buf1, save_file);
/*
popup_listbox_dialog (w, "Load: ", song_name_buf1, save_file);
*/
}

/***************************  setup app interface options **************************/

void interface_dialog(Widget w, XtPointer client_data, XtPointer call_data)
{
char *prog_name_buf;
char *args[30];
wave_header head;
DWORD buf_siz;
int step;
Widget former;

   if (w == ww.setup_btn) {

popup_app_interface_dialog (w, "Program interface: ",
 prog_name_buf, interface_exec);
                   
                  
popup_select_cursor_dialog (w, "Program interface: ",
 prog_name_buf, interface_exec);
                   
   /* now realize the widget tree... */
/*
   XtRealizeWidget (former);
step = visible_sample / GRAPH_WIDTH;
memcpy(&head, edit_buf1, sizeof(head));
buf_siz = 4 * (sizeof(float)) * head.data_length;
XtFree(temp_buf1);
temp_buf1=NULL;  
XtFree(env_buf);
env_buf=NULL;

env_buf = XtMalloc(buf_siz);
temp_buf1 = XtMalloc(buf_siz/2);   
temp_buf1 = copy_buf(edit_buf1,1);
envcreate(*env_buf,*temp_buf1, wave_envelope,step,1 );
/* save files and other setup stuff should go here    */

   }
}

void ffwd()
{
/*
options.lower_border = options.lower_border+1;

*lim_hi="up";
   XtSetArg(args[0], XtNstring, lim_hi);   
   XtSetValues(ww.limit_hi, args, 1);      

calculate_limit_borders();
*/

}

void rwnd()
{ /*
options.lower_border = options.lower_border-1;
*lim_low="down";
   XtSetArg(args[0], XtNstring, lim_low);    
   XtSetValues(ww.limit_low, args, 1);     


calculate_limit_borders();
*/
}
/*
void edit_update()
{
wave_header head;

memcpy(&head, edit_buf1, sizeof(head));
options.time_limit = (float) head.data_length / 
                        (float) (head.sample_fq * head.modus);
   sprintf(limit_buf, "%.1f", options.time_limit);

   options.lower_border = 0;
   options.upper_border = head.data_length;
visible_sample = head.data_length;	/* whole sample is to be seen */
 /*  start_visible = 0;

   /* set the widgets accordingly */
 /*  XtSetArg(args[0], XtNstring, limit_buf);
   XtSetValues(ww.limit, args, 1);


}
*/
void load_file()
{
   char *pointer;
   wave_header head;
   int fd,i,ns,n; 
   DWORD l, length; 
   char *extension[2];
   char *tmp_sng_name;
   char *song_name_buf;
   char *args1[30];


   get_changeable_options();

song_name_buf = XtMalloc(200);
if(graph_data)
strcpy(song_name_buf,song_name_buf2);
else 
strcpy(song_name_buf,song_name_buf1);

/*********** check file extension for conversion info ******/

read_args2_buf(conv_buf,convert_res);

for( i = 0 ; i<8  ; i++){
        ns=split1(conv_buf[i],':',av) ;
if (!strncmp("load",av[0],4))   
convert_name[i]=av[1];
}
for( i = 0 ; i< 30; i++)
av[i]=NULL;
 tmp_sng_name = XtMalloc(200);   
strcpy(tmp_sng_name,song_name_buf);
split1(tmp_sng_name,'.',extension) ;

for( i=0 ; i<20 ; i++)
if(!strcmp(extension[1],convert_name[i])){
read_args2_buf(conv_buf,convert_res);
ns=split1(conv_buf[i],':',av) ;
progt = av[2];
for ( n=0 ; n<ns ; n++)
av[n] = av[n+3];

for(n=0 ; n<ns ; n++){
if(!strcmp(av[n],"$1"))
av[n]=song_name_buf;
if(!strncmp(av[n],"$t",2))
av[n]="/sound/temp.wav";
}
printf(" exec %s %s %s %s %s %s",progt,av[0],av[1],av[2],av[3],av[4],av[5]);

interface_exec(progt,av,1);
/*  strcpy(song_name_buf,"/sound/temp.wav");    */
}

   if ((fd = open (song_name_buf, O_RDONLY, 0)) == -1) {
      err(1, "Could not open file ");

      return;
   }
   read(fd, &head, sizeof(head));
   if (!header_check(&head)) return;

   /* force all options */
   options.force_speed = options.force_stereo = options.force_sample_size = 1;
   options.quiet_mode = 1;	/* always quiet */
   options.speed = head.sample_fq;
   options.stereo = (head.modus == 2);
   options.sample_size = head.bit_p_spl;
   /* calculate full time limit */
   options.time_limit = (float) head.data_length / 
                        (float) (head.sample_fq * head.modus);
   sprintf(limit_buf, "%.1f", options.time_limit);

   options.lower_border = 0;
   options.upper_border = head.data_length;
   visible_sample = head.data_length;	/* whole sample is to be seen */
   start_visible = 0;

   /* set the widgets accordingly */

   XtSetArg(args[0], XtNstring, limit_buf);
   XtSetValues(ww.limit, args, 1);
if(graph_data){
   XtSetArg(args[0], XtNstring, song_name_buf2);
   XtSetValues(ww.song_title2, args, 1);     }
else{
   XtSetArg(args[0], XtNstring, song_name_buf1);
   XtSetValues(ww.song_title1, args, 1);     }

   sprintf(speed_buf, "%u", head.sample_fq);
   XtSetArg(args[0], XtNstring, speed_buf);
   XtSetValues(ww.speed, args, 1);
   if (options.stereo)  {
      XtSetArg(args[0], XtNstate, True);
      XtSetValues(ww.stereo_btn, args, 1);
      XtSetArg(args[0], XtNstate, False);
      XtSetValues(ww.mono_btn, args, 1);
   } else {
      XtSetArg(args[0], XtNstate, False);
      XtSetValues(ww.stereo_btn, args, 1);
      XtSetArg(args[0], XtNstate, True);
      XtSetValues(ww.mono_btn, args, 1);
   }
   if (options.sample_size == 8) {
      XtSetArg(args[0], XtNstate, True);
      XtSetValues(ww.eight_bit_btn, args, 1);
   } else if (options.sample_size == 12) {
      XtSetArg(args[0], XtNstate, True);
      XtSetValues(ww.twelve_bit_btn, args, 1);
   } else {
      XtSetArg(args[0], XtNstate, True);
      XtSetValues(ww.sixteen_bit_btn, args, 1);
   }

   /* allocate the edit buffer */
   length = head.length + 30;	/* 30 additional bytes */
if (graph_data)
   edit_buf2 = pointer = XtMalloc(length);
else
   edit_buf1 = pointer = XtMalloc(length);

   memcpy(pointer, &head, sizeof(head));
   pointer += sizeof(head);

   /* load the file into the edit_buffer */

   l = length - sizeof(head);
   if ((l = read(fd, pointer, l)) == -1) {
      err(1, "Error loading sample!");
      return;
   }

   close(fd);
firstload=1;
   /* drawing area will be updated automatically */
/*  update_display();  */
}


char * check_file_buf(int type,char *tmp_sng_name){

   int fd;
   char *pointer;
   wave_header head;
   char name[NAME_LEN];
   int i,ns,n,saved;
   DWORD l, length;
   char *extension[2];
   char song_name_buf[NAME_LEN];
   char *args1[30];



if(graph_data)
strcpy(name ,song_name_buf2);
else 
strcpy(name,song_name_buf1);

if(type == 1){
if (graph_data)
   pointer = edit_buf2;
else
   pointer = edit_buf1;
}
else if(type == 2 ){
   pointer = temp_buf1;
 strcpy(name, "temp.fil");
}
else if(type == 3 ){
   pointer = env_buf;
strcpy(name, "env.1");
}


strncpy(tmp_sng_name, name, sizeof(name));
return(pointer);

}


void chk_file_ext(int type, char *name){
/*********** check file extension for conversion info ******/
   int fd;
   char *pointer;
   wave_header head;
   int i,ns,n,saved;
   DWORD l, length;
   char *extension[2];
   char *tmp_sng_name, song_name_buf[NAME_LEN];
   char *args1[30];


read_args2_buf(conv_buf,convert_res);

for( i = 0 ; i< 20 ; i++){
        ns=split1(conv_buf[i],':',av) ;
if (!strcmp("save",av[0])){
convert_name[i]=av[1];   }
}
for( i = 0 ; i< 30; i++)
av[i]=NULL;

tmp_sng_name = XtMalloc(200);
strcpy(tmp_sng_name,name);
split1(tmp_sng_name,'.',extension) ;

for( i=0 ; i<20 ; i++)
if(!strcmp(extension[1],convert_name[i])){
read_args2_buf(conv_buf,convert_res);
ns=split1(conv_buf[i],':',av) ;
progt = av[2];
for ( n=0 ; n<ns ; n++)
av[n] = av[n+3];

for( n=ns-3 ; n<20 ; n++)
av[n]=NULL;

for(n=0 ; n<ns+1 ; n++){
if(!strcmp(av[n],"$1"))
av[n]=name;
if(!strcmp(av[n],"$t"))
av[n]="/sound/temp.wav";
}
}
}


void save_file(int type)
{
   int fd;
   char *pointer;
   wave_header head;
   char name[20];
   int i,ns,n,saved;
   DWORD l, length;
   char *extension[2];
   char *tmp_sng_name, song_name_buf[NAME_LEN];
   char *args1[30];

tmp_sng_name = XtMalloc(200);
pointer=check_file_buf(1,tmp_sng_name);
   
/*song_name_buf = XtMalloc(200);*/
strcpy(song_name_buf, tmp_sng_name);
split1(song_name_buf,'.',extension) ;
strcpy(song_name_buf, tmp_sng_name);

if(strcmp(extension[1],"wav"))
strcpy(tmp_sng_name, "/newapps/sound/temp.wav");

   /* remove file, if alread exists */
   remove(tmp_sng_name);     

   if ((fd = open (tmp_sng_name, O_WRONLY | O_CREAT, 0666)) == -1) {
      err(1, "Could not open file");
      return;
   }
if(type==1){
   memcpy(&head, pointer, sizeof(head));
   write(fd, pointer, sizeof(head));
   pointer += sizeof(head);
   write(fd, pointer, head.data_length);
saved = fsync(fd);
  close(fd);
 }
if(type==3){
   write(fd, pointer,sizeof(env_buf));
saved = fsync(fd);
   close(fd);
 }

else{
   memcpy(&head, pointer, sizeof(head));
   write(fd, pointer, sizeof(head));
   pointer += sizeof(head);
   write(fd, pointer, head.data_length);
saved = fsync(fd);
   close(fd);

}

 modified = 0;
   XtSetArg(args[0], XtNstring, name); 
if(graph_data)
   XtSetValues(ww.song_title2, args, 1);
else 
   XtSetValues(ww.song_title1, args, 1);
   XFlush(dpy);



/*********** check file extension for conversion info ******/

read_args2_buf(conv_buf,convert_res);

for( i = 0 ; i< 20 ; i++){
        ns=split1(conv_buf[i],':',av) ;
if (!strcmp("save",av[0])){
convert_name[i]=av[1];   }
}
for( i = 0 ; i< 30; i++)
av[i]=NULL;

for( i=0 ; i<20 ; i++)
if(!strcmp(extension[1],convert_name[i])){
read_args2_buf(conv_buf,convert_res);
ns=split1(conv_buf[i],':',av) ;
progt = av[2];
for ( n=0 ; n<ns ; n++)
av[n] = av[n+3];

for( n=ns-3 ; n<20 ; n++)
av[n]=NULL;

for(n=0 ; n<ns+1 ; n++){
if(!strcmp(av[n],"$1"))
av[n]=name;
if(!strcmp(av[n],"$t"))
av[n]="/newapps/sound/temp.wav";
}
printf(stderr," exec %s %s %s %s %s %s",progt,av[0],av[1],av[2],av[3],av[4],av[5]);

interface_exec(progt,av,0);

printf(" exec %s %s %s %s %s %s",progt,av[0],av[1],av[2],av[3],av[4],av[5]);
printf("finished !");
}


}


void popup_file_dialog (Widget w, String str, String def_fn, void (*func)() )
/* Pops up a file dialog for widget w, label str, default filename def_fn */
/* calls func if the user clicks on OK */
{
   DialogInfo *file_info;
   Widget file_dialog;

   Widget shell = XtCreatePopupShell("file_dialog_shell", 
   				     transientShellWidgetClass, 
          		             top_level, NULL, 0);

   if (dialog_context == None) dialog_context = XUniqueContext();

   file_dialog = MW ("file_dialog", dialogWidgetClass, shell, 
      XtNlabel, str, 
      XtNvalue, def_fn, 
      NULL);

   file_info = XtNew(DialogInfo);
   file_info->func = func;
   file_info->arg = 1;

   if (XSaveContext(dpy, (Window) file_dialog, 
      dialog_context, (caddr_t) file_info) != 0) {
      fprintf(stderr, "Error while trying to save context\n");
      XtDestroyWidget(shell);
      return;
   }

   XawDialogAddButton(file_dialog, "OK", popdown_file_dialog, (XtPointer) 1);
   XawDialogAddButton(file_dialog, "Cancel", popdown_file_dialog, NULL);

   popup_centered(shell);

}

void popup_centered(Widget w)
{
   int win_x, win_y; 
   int x, y;
   Dimension width, height, b_width;
   unsigned int mask;
   Window root, child;
   Cardinal num_args;
   Widget v;

   XtRealizeWidget(w);

   XQueryPointer(dpy, XtWindow(w), 
    		 &root,  		/* root window under the pointer */
    		 &child, 		/* child window under the pointer */
    		 &x, &y, 		/* pointer coords relative to root */
	 	 &win_x, &win_y, 	/* pointer coords relative to window */
		 &mask);		/* state of modifier keys and buttons */
    		  
   num_args = 0;
   XtSetArg(args[num_args], XtNwidth, &width); num_args++;
   XtSetArg(args[num_args], XtNheight, &height); num_args++;
   XtSetArg(args[num_args], XtNborderWidth, &b_width); num_args++;
   XtGetValues(w, args, num_args);

   width += 2 * b_width;
   height += 2 * b_width;

   x -= ((int) width/2);
   y -= ( (Position) height/2 );

   num_args = 0;
   XtSetArg(args[num_args], XtNx, x); num_args++;
   XtSetArg(args[num_args], XtNy, y); num_args++;
   XtSetValues(w, args, num_args);
 
   XtPopup(w, XtGrabExclusive);

}

void popdown_file_dialog_action(Widget w, XEvent *event, String *params, 
                                Cardinal *num_params)
{
   char buf[80];
   Boolean val;

   if (*num_params != 1) {
      sprintf(buf, "Action `%s' must have exactly one argument.", 
              "popdown_file_dialog");
      err(1, buf);
      return;
   }

   XmuCopyISOLatin1Lowered(buf, params[0]);

   if (!strcmp(buf, "cancel"))
      val = FALSE;
   else if (!strcmp(buf, "okay"))
      val = TRUE;
   else {
      sprintf(buf, "Action %s's argument must be either `cancel' or `okay'.",
              "popdown_file_dialog");
      err(1, buf);
      return;
   }

   popdown_file_dialog(w, (XtPointer) val, (XtPointer) NULL);
}

void popdown_file_dialog(Widget w, XtPointer client_data, XtPointer call_data)
{
   Widget dialog = XtParent(w);
   caddr_t file_info_ptr;
   DialogInfo * file_info;

   if (XFindContext(dpy, (Window) dialog, dialog_context,
                    &file_info_ptr) == XCNOENT) {
      fprintf(stderr, "Error while trying to find context\n");
   }

   (void) XDeleteContext(dpy, (Window)dialog, 
                         dialog_context);

   file_info = (DialogInfo *) file_info_ptr;

   XtPopdown(XtParent(dialog));
   XtDestroyWidget(XtParent(dialog));
   XFlush(dpy);

   if ( ((Boolean) client_data) == 1 ) {
       String filename = XawDialogGetValueString(dialog);
if(graph_data)
       strncpy(song_name_buf2, filename, sizeof(song_name_buf2));
else 
       strncpy(song_name_buf1, filename, sizeof(song_name_buf1));
       (*file_info->func)(); 		/* call handler */
   }

   XtFree( (XtPointer) file_info); 	/* Free data. */
}

/* X11-error handler */
void err(int severity, char *text)
{
   Widget shell, dialog; 

   /* do something tricky to avoid changing the whole errorhandler */
   /* if pid=-1 or pid>0 we are the main process and are able to   */
   /* open an error dialog; if pid = 0, we aren't!                 */

   if (!pid) { 
      fprintf(stderr, "%s\n", text);
      return;
   }

   shell = XtCreatePopupShell("dialog_shell", 
   				     transientShellWidgetClass, 
          		             top_level, NULL, 0);

   dialog = MW ("warning", dialogWidgetClass, shell, 
      XtNlabel, text, 
      NULL);

   XawDialogAddButton(dialog, "OK", close_error, NULL);

   popup_centered(shell);
}

void close_error(Widget w, XtPointer client_data, XtPointer call_data)
{
   Widget dialog = XtParent(w);

   XtPopdown(XtParent(dialog));
   XtDestroyWidget(XtParent(dialog));
   XFlush(dpy);
}

void discard_question(int flag)
/* click on YES: execute flag dependend action */ 
{
   Widget dialog;
   DialogInfo *info;

   Widget shell = XtCreatePopupShell("dialog_shell", 
   				     transientShellWidgetClass, 
          		             top_level, NULL, 0);

   if (dialog_context == None) dialog_context = XUniqueContext();

   dialog = MW ("dialog", dialogWidgetClass, shell, 
      XtNlabel, "Discard modified file?", 
      NULL);

   info = XtNew(DialogInfo);
   info->flag = flag;

   if (XSaveContext(dpy, (Window) dialog,
      dialog_context, (caddr_t) info) != 0) {
      fprintf(stderr, "Error while trying to save context\n");
      XtDestroyWidget(shell);
      return;
   }

   XawDialogAddButton(dialog, "Yes", discard_answer, (XtPointer) 1);
   XawDialogAddButton(dialog, "No", discard_answer, NULL);

   popup_centered(shell);
}

void discard_answer(Widget w, XtPointer client_data, XtPointer call_data)
{
   Widget dialog = XtParent(w);
   caddr_t info_ptr;
   DialogInfo *info;

   get_changeable_options();

   if (XFindContext(dpy, (Window) dialog, dialog_context, &info_ptr) ==
       XCNOENT) {
      fprintf(stderr, "Error while trying to find context\n");
   }

   (void) XDeleteContext(dpy, (Window) dialog, dialog_context);

   info = (DialogInfo *) info_ptr;

   XtPopdown(XtParent(dialog));
   XtDestroyWidget(XtParent(dialog));
   XFlush(dpy);

   if ((Boolean) client_data == 1) {
x1_old = x2_old = 0;

if(graph_data){
      XtFree(edit_buf2);
      edit_buf2=NULL;
      strcpy(song_name_buf2, "");
      XtSetArg(args[0], XtNstring, song_name_buf2);
      XtSetValues(ww.song_title2, args, 1);
}
else{
      XtFree(edit_buf1);
      edit_buf1=NULL;
      strcpy(song_name_buf1, "");
      XtSetArg(args[0], XtNstring, song_name_buf1);
      XtSetValues(ww.song_title1, args, 1);
}
      update_display();
      XFlush(dpy);
      modified = 0;
      switch (info->flag) {
         case DISC_CON_QUIT:
            quit_application();
            break;
         case DISC_CON_LOAD:
if(graph_data)
            popup_file_dialog (w, "Load file: ", song_name_buf2, load_file);
else
            popup_file_dialog (w, "Load file: ", song_name_buf1, load_file);
            break;
         case DISC_CON_RECORD:
            record_sample();
            break;
         default:
           fprintf(stderr, "internal error: no valid continuation flag\n");
           exit(-1);
     }
   }
   XtFree( (XtPointer) info); 	/* Free data. */
}

void expose_graph_action (Widget w, XEvent *event, String *params, 
                          Cardinal *num_params)
{
   if ((event->type == Expose) &&
       (event->xany.window == XtWindow(w))) {
      if (!event->xexpose.count) {   /* use only the last event */
         update_display();
      }
   }
}

