#include <stdlib.h>
#include <stdio.h>
#include "../PVLIB/pv.h"

complex zero = { 0., 0. };
complex one = { 1., 0. };
float IPI;
float TWOPI;
float synt = 0.;
extern char *arg_option;

main(argc, argv)
    int argc; char *argv[];
{
    int 	R=44100,
		N=1024,
		N2,
		Nw = 8192,
		Nw2, 
		D = 512, 
		I = 512,
		i,
		hoop,			/* looping variable */
		in,
		on,
		eof = 0,
		obank = 0,
		aflag = 0,
		sflag = 0;
    float 	P = 0.,
		high_thresh = .01,
		low_thresh = .0001,
		high_gain = .2,
		low_gain = 5.0,
		mid_gain,
		high_gain_fix, 
		low_gain_fix, 
		mid_gain_fix,
		high_thresh_amp,
		low_thresh_amp,
		maxampval,
		*Hwin,
		*Wanal,
		*Wsyn,
		*input,
		*winput,
		*buffer,
		*channel,
		*output;
    char	ch,
		*dbuf;
int lowcount=0, highcount=0;
int dohighs=1, dolows=1;
int avehigh, avelow, lasthigh=0, lastlow=0, framecount=0;
float zmapp();
float duration=0.0, realtime, tadv;
float ampsum1, ampsum2, amp_rescale;
int midflag=0, fflag=0, dflag=0, Aflag=0, Fflag=0;
char fname[128];
float *sfunc;
float imult;
FILE *fp, *fopen();
int flen, ipos;
    if (isatty(0))
	usage(1);

    while( (ch= crack( argc, argv, "R|N|M|D|I|P|p|g|a|T|t|X|x|f|l|m|d|A|s|F|h", 0  )) != NULL ) {
	switch(ch) {
	    case 'R':	R = atoi(arg_option);
			break;
	    case 'N':	N = atoi(arg_option);
			break;
	    case 'M':	Nw = atoi(arg_option);
			break;
	    case 'D':	D = atoi(arg_option);
			break;
	    case 'I':	I = atoi(arg_option);
			break;
	    case 'P':	P = atof(arg_option);
			break;
	    case 'g':	synt = atof(arg_option);
			break;
	    case 'T':	high_thresh = atof(arg_option);
	                 break;
	    case 't':	low_thresh = atof(arg_option);
	                 break;
	    case 'X':	high_gain = atof(arg_option);
	                 break;
	    case 'x':	low_gain = atof(arg_option);
	                 break;
	    case 'f':	strcpy(fname, arg_option);
	    		fflag = 1;
	                 break;
	    case 'l':	duration = atof(arg_option);
	                 break;
	    case 'm':	mid_gain = atof(arg_option);
	    		midflag = 1;
	                 break;
	    case 'd':	dflag = 1;
	                 break;
	    case 'A':	Aflag = 1;
	                 break;
	    case 'F':	Fflag = 1;
	                 break;
	    case 'a':	aflag = 1;
			break;
	    case 's':	sflag = 1;
			break;
	    case 'h':	usage(1);
	}
    }
if( high_gain == 1.0 ){
   dohighs = 0;
   fprintf(stderr,"NOT RESCALING HIGH AMPLITUDES\n");
   }
if( low_gain == 1.0 ){
   dolows = 0;
   fprintf(stderr,"NOT RESCALING LOW AMPLITUDES\n");
   }
    if (Nw == 0)
	Nw = N;

    if (aflag && sflag) {
	fprintf(stderr,"specify either -a or -s not both\n");
	exit(1);
    }
    if( fflag && duration == 0.0 ){
       fprintf(stderr,"You must specify input duration when using function control\n");
       exit(-1);
    }
    if (aflag)
	I = 0;
    else
	if (I == 0)
	    I = D;

/* SET UP FOR FUNCTION CONTROL   */
    if( fflag ){
      if( (fp=fopen(fname, "r")) == NULL ) readerr( fname );
      flen = readin( fp, &sfunc);
      for(i = 0; i < flen; i++ )
        if( (sfunc[i] < 0.0) || (sfunc[i] > 1.0) ){
          fprintf(stderr,"Lookup function exceeds enforced boundaries 0.0-1.0\n");
	  exit(-1);
        }
       realtime = 0.0;
       tadv = (float)D/(float)R ;
       high_gain_fix = high_gain;
       low_gain_fix = low_gain;
       mid_gain_fix = mid_gain;
    }
    if( Fflag ){
      high_thresh_amp = high_thresh;
      low_thresh_amp = low_thresh;
    }
    if (sflag)
      D = 0;

    IPI = 4.*atan(1.);
    TWOPI = 8.*atan(1.);
    obank = P != 0.;
    N2 = N>>1;
    Nw2 = Nw>>1;
/*  MEMORY ALLOCATION    */
    Wanal = (float *) space( Nw, sizeof(float) );	/* analysis window */
    Wsyn = (float *) space( Nw, sizeof(float) );	/* synthesis window */
    input = (float *) space( Nw, sizeof(float) );	/* input buffer */
    Hwin = (float *) space( Nw, sizeof(float) );	/* plain Hamming window */
    winput = (float *) space( Nw, sizeof(float) );	/* windowed input buffer */
    buffer = (float *) space( N, sizeof(float) );	/* FFT buffer */
    channel = (float *) space( N+2, sizeof(float) );	/* analysis channels */
    output = (float *) space( Nw, sizeof(float) );	/* output buffer */
  
    makewindows( Hwin, Wanal, Wsyn, Nw, N, I, obank );
    in = -Nw;
    if ( D )
	on = (in*I)/D;
    else
	on = in;
/* MAIN LOOP      */
while ( !eof ) {
   in += D;
   on += I;
   if( fflag ){
      ipos = (int)((realtime/duration)*(float)(flen -1));
      if( ipos >= flen) {
         fprintf(stderr,"WHITECLAM: index out of bounds\n");
         ipos = flen - 1;
      }
      imult =  sfunc[ ipos ];
      realtime += tadv;
   }
   /* READ ANALYSIS   */
   if ( D == 0 ) {
      for ( hoop=0; hoop < N+2; hoop++ ) {
         if ( fread(channel+hoop,sizeof(float),1,stdin) <= 0 )
            eof = 1;
      } 
   } 
   /* READ TIME SERIES     */
   else {
      eof = shiftin( input, Nw, D );
      fold( input, Wanal, Nw, buffer, N, in );
      rfft( buffer, N2, FORWARD );
      leanconvert( buffer, channel, N2, D, R );
   }
   
   /* AVOID OVERSHOOTING FUNCTION WHEN EXTRA SOUND IS GENERATED   */
   
   if( realtime >= duration ) realtime = duration;
   
   /* DYNAMICALLY ADJUST AMPLITUDE RESCALING ONLY WHEN
   // USING FUNCTION CONTROL   */
   
   if( fflag ){
      high_gain = zmapp( imult, high_gain_fix );
      if( midflag)
         mid_gain = zmapp( imult, mid_gain_fix );
      low_gain = zmapp( imult, low_gain_fix );
   }
   if( !Fflag ){
      maxampval = 0.0;
      for(i=0;i<N2;i+=2){
        if(channel[i] > maxampval ) maxampval = channel[i];
        }
      high_thresh_amp = maxampval * high_thresh;
      low_thresh_amp = maxampval * low_thresh;
   }
   if( Aflag ){
      ampsum1 = ampsum2 = 0.0;
      for(i=0;i<N2;i+=2){
         ampsum1 += channel[i];
      }
   }
   if( dflag ){
      lastlow = lowcount;
      lasthigh = highcount;
   }
   for(i=0;i<N2;i+=2){
     if( channel[i] >= high_thresh_amp && dohighs){
         channel[i] *= high_gain;
	++highcount;
     }
     else if( channel[i] <= low_thresh_amp && dolows ){
        channel[i] *= low_gain;
	++lowcount;
     }
     else if( midflag ){
        channel[i] *= mid_gain;
     }
     if( Aflag )
        ampsum2 += channel[i];
  }
  if( Aflag && ampsum2 != 0.0){
     amp_rescale = ampsum1/ampsum2 ;
     for(i=0;i<N2;i+=2){
        channel[i] *= amp_rescale ;
     }
  }
  ++framecount;
  if( dflag ){
     fprintf(stderr,"processed %d high bins, %d low bins\n",
     highcount-lasthigh,lowcount-lastlow);
     if( Aflag ){
        fprintf(stderr,"regain factor = %f\n",amp_rescale);
     }
   }
	if ( aflag ) {  /* analysis output */
	    fwrite( channel, sizeof(float), N+2, stdout );
	    fflush( stdout );
	    continue;
	}

	if ( obank ) {
	    noscbank( channel, N2, R, Nw, I, P, output );
	    shiftout( output, Nw, I, on+Nw-I );
	} 

	else {
	    leanunconvert( channel, buffer, N2, I, R );
	    rfft( buffer, N2, INVERSE );
	    overlapadd( buffer, N, Wsyn, output, Nw, on );
	    shiftout( output, Nw, I, on );
	}
    }
    fprintf(stderr,"WHITECLAM: RESYNTHESIS COMPLETED\n");
    fprintf(stderr,"\taverage number of rescaled high bins: %d\n\taverage number of rescaled low bins: %d\n",highcount/framecount,lowcount/framecount);
    exit(0);
}


usage(woof)
{
    fprintf(stderr, "%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s",
	"whiteclam:  threshold amplitude distortion\n",
	"whiteclam   [flags] < floatsams > floatsams\n",
	"	R:	sampling rate [44100]\n",
	"	N:	fft length [1024]\n",
	"	M:	window size in samples [8192]\n",
	"	D:	decimation factor in samples [512]\n",
	"	I:	interpolation factor in samples [512]\n",
	"	P:	oscillator bank pitch factor [0.0]\n",
	"	T:	high amp threshold [.01]\n",
	"	t:	low amp threshold [.0001]\n",
	"	X:	high amp gain [.2]\n",
	"	x:	low amp gain [5.0]\n",
	"	m:	optional midrange gain [1.0]\n",
	"	A:	maintain average frame amplitude\n",
	"	F:	interpret thresholds as fixed amplitudes\n",
	"	f:	optional function to control strength of effect\n",
	"	l:	length [needed only if using function control]\n",
	"	d:	display affected bins\n",
	"	s:	synthesize analysis input\n"
	);
    exit(woof);
}
float zmapp( in, omax ) float in, omax;
{
   if( in < 0.0 || in > 1.0 ){
      fprintf(stderr,"zmapp: warning map value out of expected 0-1 range\n");
   }
   return( 1. + ((omax-1.0) * in) );
}


