#include <stdio.h>
#include "../PVLIB/pv.h"
#define DEBUG (0)
/*
ANALYSIS INPUT VERSION OF pvinsert
*/
complex zero = { 0., 0. };
complex one = { 1., 0. };
typedef struct {
   int stbin;
   int endbin;
} binny ;
typedef struct {
   float stfreq;
   float endfreq;
} finny ;

float IPI;
float TWOPI;
float synt = 0.;
extern char *arg_option;
main(argc, argv)
    int argc; char *argv[];
{
  int R=44100, N=1024, N2, Nw = 4096, Nw2, D = 512, I = 512, in, on, 
  eof = 0, obank = 0, aflag = 0, sflag = 0;
  float P = 0., len, tincr, tpos, *Hwin, *Wanal, *Wsyn, *input, *winput,
  *buffer, *channel, *output; 
  char	ch, *dbuf;
  char leakfuncname[128] = "leakfunc", lookfuncname[128] = "func";
  char pvname1[128] = "pvanal1.i";
  char pvname2[128] = "pvanal2.i";
  float duration=0., outdur=0.;
  int pvcount = 0;
  int N_Frames1 = 0, N_Frames2 = 0;
  int N_OutFrames;
  int i,j, k,l;
  int flen, leaklen;
  float **wherehouse1, **wherehouse2;
  float *lookupfunc, *tfunc, *leakfunc, *lookup1, *lookup2;
  FILE *openfile(), *fp, *fp1, *fp2, *fp3, *fp4;
  int bad_read_flag;
  int new_frame_len;
  int ioffset;
  int pos1, pos2, leakpos;
  float time_offset = 0.0;
  float funcbot=0., functop=1.;
  float indur1, indur2 ;
  int *sieve;
  int exchange ;
  int rescaleflag = 0;
  int FILE2_FRAME_START;
  float file2_starttime = 0.0 ;
  int file2_ends_first=0, file1_ends_first=0, they_end_together=0;
  int lineflag = 0;
  int show = 0;
  int LeakFrames;
  int bcnt;
  int ampx, freqx ;
  int z ;
    char datafile[128] = "idata" ;
    binny binsert[512];
    finny freqlist[512];
    while( (ch= crack( argc, argv, "R|N|M|I|d|D|o|O|s|S|f|l|p|P|L|l|", 0  )) != NULL ) {
	switch(ch) {
	    case 'R':	R = atoi(arg_option);
			break;
	    case 'N':	N = atoi(arg_option);
			break;
	    case 'M':	Nw = atoi(arg_option);
			break;
	    case 'I':	I = atoi(arg_option);
			break;
	    case 'l':   indur1 = atof(arg_option);
			break;
	    case 'L':   indur2 = atof(arg_option);
			break;
	    case 'D':  D = atoi(arg_option);
			break;
	    case 'o':   outdur = atof(arg_option);
	    		break;
	    case 'O':   time_offset = atof(arg_option);
	    		break;
	    case 'f': strcpy(datafile, arg_option);
			break;
	    case 'p': 	strcpy(pvname1, arg_option);
	    		break;
	    case 'P': 	strcpy(pvname2, arg_option);
	    		break;

	    case 'h':	usage(1);
	}
    } 
    if( indur1 <= 0.0  || indur2 <= 0.0) {
      fprintf(stderr,"must specify input durations\n");
      usage(-1);
      exit(-1);
    }
    N_Frames1 = (int) ((((float)R+(float)Nw)/(float)I)*indur1);
    N_Frames2 = (int) ((((float)R+(float)Nw)/(float)I)*indur2);
    FILE2_FRAME_START = ((float)(R)/(float)I) * file2_starttime ;
    if (Nw == 0)
	Nw = N;
    if (I == 0)
	I = D;
	/* SCAN DATA FOR INSERTION   */
     fp = openfile( datafile, "r" ); 
     while( fscanf(fp,"%f %f",&freqlist[bcnt].stfreq, &freqlist[bcnt].endfreq)!= EOF){
        ++bcnt ;
	}
    for(i = 0; i < bcnt; i++ ){
       binsert[i].stbin = freq2bin( freqlist[i].stfreq,N , R );
       binsert[i].endbin = freq2bin( freqlist[i].endfreq, N, R );
       fprintf(stderr,"bin pair %d: %d %d\n", i+1, binsert[i].stbin ,binsert[i].endbin);
       if( binsert[i].stbin == binsert[i].endbin )
         ++(binsert[i].endbin);
    }

    IPI = 4.*atan(1.);
    TWOPI = 8.*atan(1.);
    obank = P != 0.;
    N2 = N>>1;
    Nw2 = Nw>>1;
    Wanal = (float *) space( Nw, sizeof(float) );
    Wsyn = (float *) space( Nw, sizeof(float) );
    input = (float *) space( Nw, sizeof(float) );
    Hwin = (float *) space( Nw, sizeof(float) );
    winput = (float *) space( Nw, sizeof(float) );
    buffer = (float *) space( N, sizeof(float) );	   
    channel = (float *) space( N+2, sizeof(float) );    
    output = (float *) space( Nw, sizeof(float) );
    lookup1 = (float *) space( flen, sizeof(float) );	
    lookup2 = (float *) space( flen, sizeof(float) );	
    sieve = (int *) space( N+2, sizeof(int) );	

    if( ( wherehouse1 = (float **) calloc(N_Frames1, sizeof(float *) ) ) == NULL) 
       memerr();
    for ( i=0; i < N_Frames1; i++ ) 
       if( (*(wherehouse1+i) = (float *) calloc(N+2, sizeof(float)) ) == NULL) 
          memerr();
    if( ( wherehouse2 = (float **) calloc(N_Frames2, sizeof(float *) ) ) == NULL) 
       memerr();
    for ( i=0; i < N_Frames2; i++ ) 
       if( (*(wherehouse2+i) = (float *) calloc(N+2, sizeof(float)) ) == NULL) 
          memerr();

    makewindows( Hwin, Wanal, Wsyn, Nw, N, I, obank );

    in = -Nw;
    on = in;

bad_read_flag = 0;
   fp3 = openfile( pvname1, "r" ); 
   for( i = 0 ; i < N_Frames1; i++ ){
      for( j = 0; j < N+2; j++ )
	 if ( fread(&wherehouse1[i][j],sizeof(float),1,fp3) == NULL ){
	    bad_read_flag = 1;
	    break;
         }
    }
    if( bad_read_flag) N_Frames1 = i;
   fprintf(stderr,"PVASSERT: ANALYSIS SCAN 1 COMPLETED, READ %d FRAMES\n", N_Frames1);
   fp4 = openfile( pvname2, "r" ); 
   for( i = 0 ; i < N_Frames2; i++ ){
      for( j = 0; j < N+2; j++ )
	 if ( fread(&wherehouse2[i][j],sizeof(float),1,fp4) == NULL ){
	    bad_read_flag = 1;
	    break;
         }
    }
    if( bad_read_flag) N_Frames2 = i;
    fprintf(stderr,"PVASSERT: ANALYSIS SCAN 2 COMPLETED, READ %d FRAMES\n", N_Frames2);

    if( FILE2_FRAME_START + N_Frames2 > N_Frames1 ){
        file1_ends_first = 1;
	N_OutFrames = FILE2_FRAME_START + N_Frames2 ;
    } else if ( FILE2_FRAME_START + N_Frames2 < N_Frames1 ){
        file2_ends_first = 1;
	N_OutFrames = N_Frames1 ;
    } else if ( FILE2_FRAME_START + N_Frames2 == N_Frames1 ){
        they_end_together = 1;
	N_OutFrames = N_Frames1 ;
    }
    /* SYNTHESIS LOOP */
    pos1 = 0;
    pos2 = 0;
    for(j = 0; j < N_OutFrames ; j++) {
        pos1 = j;
	pos2 = pos1 - FILE2_FRAME_START ;
	on += I;
/* CURRENT FUNCTION DIRECTLY RETURNS FRAME (int) SUBSCRIPT   */
        if( j == FILE2_FRAME_START + N_Frames2 ){
	   fprintf(stderr," we have just left file2 behind\n");
	}
	if( pos2 < 0 || pos2 >= N_Frames2 ){
	   cpfunc( channel, wherehouse1[pos1], N+2 ); 
	} else if( pos1 >= N_Frames1 ){
	   if( pos1 == N_Frames1 ){
	      fprintf(stderr,"we have just left file1 behind\n");
	   }
           cpfunc( channel, wherehouse2[pos2], N+2 ); 
	}
	else if(pos2 >= N_Frames2 && pos1 >= N_Frames1)
	{
	  printf(stderr,"Reached end of tether. Bye.\n");
	  exit(0);
	} 
	else {
	   if( j == FILE2_FRAME_START ){
	      fprintf(stderr,"starting interpolation of file2\n");
	   }
	   /* INSERTION HERE     */
	cpfunc( channel, wherehouse1[pos1], N+2 ); 
	for( k = 0 ; k < bcnt; k++ ){
	  for( z = binsert[k].stbin; z < binsert[k].endbin; z++){
	     ampx = z<<1;
	     freqx = ampx + 1;
	     channel[ampx] = wherehouse2[pos2][ampx];
	     channel[freqx] = wherehouse2[pos2][freqx];
	  }
	}

	}
/* GENERATE WAVEFORM    */
	unconvert( channel, buffer, N2, I, R );
        rfft( buffer, N2, INVERSE );
	overlapadd( buffer, N, Wsyn, output, Nw, on );
	shiftout( output, Nw, I, on );
    } 
/* TERMINATE   */
    fprintf(stderr,"PVASSERT: SYNTHESIS COMPLETED\n");
    exit(0);
}

usage(meow)
{
    fprintf(stderr, "%s",
	"pvassert:  fft fade in\n"
	"pvassert   [flags]  > floatsams\n"
	"	N:	fft length [1024]\n"
	"	R:	sampling rate [44100]\n"
	"	M:	window size in samples [4096]\n"
	"	I:	interpolation factor in samples [512]\n"
	"	D:	interpolation factor in samples [512]\n"
	"	l:	duration of input1 [undefined]\n"
	"	L:	duration of input2 [undefined]\n"
	"	f:	name insertion datafile [idata]\n"
	"	p:	name of analysis file 1 [pvanal1.i]\n"
	"	P:	name of analysis file 2 [pvanal2.i]\n"
	);
    exit(meow);
}
cpfunc( arr1, arr2, len ) float *arr1, *arr2; int len;
{
   int i;
   for(i=0;i<len;i++)
      arr1[i] = arr2[i];
}

memerr()
{
fprintf(stderr,"Richard Wagner Alert: No Memory Left\n");
exit(-1);
}
