#include <stdlib.h>
#include <stdio.h>
#include "../PVLIB/pv.h"
#define THRESH (.0000001)
complex zero = { 0., 0. };
complex one = { 1., 0. };
float IPI;
float TWOPI;
typedef struct{
   float amp1;
   float amp2;
   int Nframes;
   int curframe;
} MEMBER ;
extern char *arg_option;
main(argc, argv)
    int argc; char *argv[];
{
    int 	R=44100,
		N=1024,
		N2,
		Nw = 4096,
		Nw2, 
		I = 512,
		i,
		in,
		on;
    float 	P = 0.,
		*Hwin,
		*Wanal,
		*Wsyn,
		*input,
		*winput,
		*buffer,
		*channel,
		*output;
    char	ch,
		*dbuf;
		int first = 1;
		float odds = .95;
float FDEVmax;
float FDEVmin;
FILE  *openfile();
float randf();
int j;
float minseg=.1, maxseg=.8 ;
int multflag = 0;
int freqflag = 1;
float freqdevo=0.01 ;
float duration=0.0, realtime, tadv;
int Seed = 0;
char fname[128];
float *nowfilt;
float *multfilt;
MEMBER *filtdata;
int Nframes, framecount, minframe, maxframe;
float phaseinc, freq, finescale=.1;
float obank;
FILE *fp, *fopen();
int flen, ipos;
int count = 0;
    while( (ch= crack( argc, argv, "R|N|M|I|d|u|l|s|h|o|f|m|x|", 0  )) != NULL ) {
	switch(ch) {
	    case 'R':	R = atoi(arg_option);
			break;
	    case 'N':	N = atoi(arg_option);
			break;
	    case 'M':	Nw = atoi(arg_option);
			break;
	    case 'I':	I = atoi(arg_option);
			break;
	    case 'd':	duration = atof(arg_option);
			break;
	    case 'u':	maxseg = atof(arg_option);
	                 break;
	    case 'l':	minseg = atof(arg_option);
	                 break;
	    case 'o':	odds = atof(arg_option);
	                 break;
	    case 'f':	finescale = atof(arg_option);
	                 break;
	    case 'm':	multflag = 1;
	                strcpy(fname, arg_option);
	                break;
	    case 'x':   freqdevo = atof(arg_option);
	                 break;
	    case 's':	Seed = atoi(arg_option);
	                 break;
	    case 'h':	usage(1);
	}
    }
    if( duration <= 0.0 )
       usage(1);

    if( I == 0 ){
       fprintf(stderr,"I must be > 0\n");
       exit(-1);
    }
    if( freqdevo == 0.0 )
       freqflag = 0;
    else{
       freqflag = 1;
       FDEVmax = 1.0 + freqdevo;
       FDEVmin = 1.0 / FDEVmax;
    }
    minframe = sec2frame( minseg, I, R );
    if( minframe < 1 ){
       minframe = 1;
       fprintf(stderr,"minimum frame set to 1\n");
    }
    maxframe = sec2frame( maxseg, I, R );
    tadv = (float)I/(float)R ;
    duration += tadv;
    framecount = Nframes = 0;
    if( Seed == 0 )
       Seed = time( 0 );
    srandom( Seed );
    fprintf(stderr,"seed is %d\n",Seed);
    if (Nw == 0)
	Nw = N;
    IPI = 4.*atan(1.);
    TWOPI = 8.*atan(1.);
    N2 = N>>1;
    Nw2 = Nw>>1;
    if( multflag ){
       fp = openfile( fname, "r" );
       flen = readin( fp, &multfilt ); 
       if( flen != N2 ){
          fprintf(stderr,"filter function must be of length %d\n",N2);
	  exit(-1);
	  }
    }
    Wanal = (float *) space( Nw, sizeof(float) );	
    Wsyn = (float *) space( Nw, sizeof(float) );
    input = (float *) space( Nw, sizeof(float) );
    Hwin = (float *) space( Nw, sizeof(float) );
    winput = (float *) space( Nw, sizeof(float) );
    buffer = (float *) space( N, sizeof(float) );
    channel = (float *) space( N+2, sizeof(float) );
    output = (float *) space( Nw, sizeof(float) );
    nowfilt = (float *) space(N2, sizeof(float) );
    filtdata = (MEMBER *) space(N2, sizeof(MEMBER) );
    phaseinc = (float) R/(float) N ;
    phaseinc *= 2.0;
    freq = phaseinc;
    for( i = 3; i < N ; i+= 2 ){
       channel[i] = freqflag ? freq * (randf(FDEVmin, FDEVmax)) : freq;
       freq += phaseinc;
    }
    makewindows( Hwin, Wanal, Wsyn, Nw, N, I, obank );
    in = -Nw;
    on = in;
/* INITIALIZE DATASET    */
for(i = 0; i < N2; i++ ){
   filtdata[i].Nframes = filtdata[i].curframe = 0;
   filtdata[i].amp1 = filtdata[i].amp2 = 0.0;
   }
realtime = 0.0;
   while ( realtime <= duration) {
      on += I;
      realtime += tadv;
      /* RESET FREQUENCY VALUES    */
      if( freqflag ){
         freq = phaseinc;
         for( i = 3; i < N ; i+= 2 ){
            channel[i] = freq * (randf(FDEVmin, FDEVmax));
            freq += phaseinc;
         }
      }
      if( multflag )
         mSetFrameData( filtdata, N2, odds, finescale, minframe, maxframe, multfilt );
      else
         SetFrameData( filtdata, N2, odds, finescale, minframe, maxframe );
      BuildFrame( nowfilt, filtdata, N2 );
      setamp( channel, nowfilt, N2 );
      leanunconvert( channel, buffer, N2, I, R );
      rfft( buffer, N2, INVERSE );
      overlapadd( buffer, N, Wsyn, output, Nw, on );
      shiftout( output, Nw, I, on );
      ++framecount;
    }
    fprintf(stderr,"JONES: SYNTHESIS COMPLETED\n");
    exit(0);
}


SetFrameData( data, N, odds, fine, minframe, maxframe )
MEMBER *data;
int N;
float odds, fine;
int   minframe, maxframe;
{
float randf();
int i;
float val;
static float scale;
static float finescale;
static int first = 1;
static int fineflag = 1;
if(first){
   scale = .1 / (((float) N) * 8.0);
   if( fine < THRESH ){
      fineflag = 0;  
      fprintf(stderr,"not making fine spectrum\n");
      }
   else finescale = scale * fine ;
   first = 0;
}
   for( i = 0; i < N; i++ ){
      /* curframe IS INCREMENTED IN BuildFrame   */
      if( data[i].curframe == data[i].Nframes ){
         data[i].Nframes = randi( minframe, maxframe );
	 data[i].curframe = 0;
	 data[i].amp1 = data[i].amp2;
         val = randf(0.0, 1.0 );
         if( val > odds )
            data[i].amp2 = randf( 0., scale );
         else if( fineflag )
            data[i].amp2 = randf( 0., finescale ) ;
         else data[i].amp2 = 0.0 ;
      }
   }
}
mSetFrameData( data, N, odds, fine, minframe, maxframe, filt )
MEMBER *data;
int N;
float odds, fine;
int   minframe, maxframe;
float *filt;
{
float randf();
int i;
float val;
static float scale;
static float finescale;
static int first = 1;
static int fineflag = 1;
if(first){
   scale = .1 / (((float) N) * 8.0);
   if( fine < THRESH ){
      fineflag = 0;  
      fprintf(stderr,"not making fine spectrum\n");
      }
   else finescale = scale * fine ;
   first = 0;
}
   for( i = 0; i < N; i++ ){
      /* curframe IS INCREMENTED IN BuildFrame    */
      if( data[i].curframe == data[i].Nframes ){
         data[i].Nframes = randi( minframe, maxframe );
	 data[i].curframe = 0;
	 data[i].amp1 = data[i].amp2;
         val = randf(0.0, 1.0 );
         if( val > odds )
            data[i].amp2 = (randf( 0.,scale )) * filt[i];
         else if( fineflag )
            data[i].amp2 = (randf( 0., finescale )) * filt[i] ;
         else data[i].amp2 = 0.0 ;
      }
   }
}

BuildFrame( dest, data, N )
float *dest;
MEMBER *data;
int N;
{
int i;
float amult, bmult;

for( i = 0; i < N; i++ ){
   if(data[i].curframe == 0)
      dest[i] = data[i].amp1;
   else{
      bmult = (float) data[i].curframe/(float)data[i].Nframes;
      amult = 1.0 - bmult;
      dest[i] = data[i].amp1*amult + data[i].amp2*bmult;
      }
   ++(data[i].curframe);
   }
}

setamp( chan, filt, N2 )
float chan[], filt[];
int N2;
{
   int i, j;
   for( i = 0, j = 0; i < N2; i += 2, j++ ){
      chan[i] = filt[j];
   }
}
int sec2frame( sec, I, R )
float sec; int I, R ;
{
float Itime;
   Itime = (float) I / (float) R ;
   return( sec / Itime ) ;
}
float randf( min, max ) float min, max;
{
return( ((float)(random()/(float)0x7fffffff)*(max-min))+min );
}
int randi( min, max ) int min, max;
{
return( ((random()%(max-min))+min ));
}
usage(woof)
{
    fprintf(stderr, "%s",
	"jones:  baroque random spectral synthesizer\n"
	"jones   [flags]  > floatsams\n"
	"	R:	sampling rate [44100]\n"
	"	N:	fft length [1024]\n"
	"	M:	window size in samples [4096]\n"
	"	I:	interpolation factor in samples [512]\n"
	"	l:	minimum spectral duration [.1]\n"
	"	u:	maximum spectral duration [.8]\n"
	"	d:	duration [undefined]\n"
	"	o:	odds against amplitude appearing [.95]\n"
	"	f:	scaling for fine components[.1]\n"
	"	m:	optional function for rescaling spectrum\n"
	"	x:	bin frequency deviation percentage [0.01]\n"
	"	s:	optional seed\n"
	);
    exit(woof);
}
