// wavpic.h - cute happy-fun header file for wavpic.cc

#include "waveform.h"

// macros
#define DRAWCURSOR(color) gl_fillbox(mouse_getx(),mouse_gety()-8,2,16,(color))
// draw/erase the mouse cursor

// colors for various objects
#define CURSOR 255
#define WAVE 112
#define SELECT 64
#define BACKGROUND 2
#define CHARS 255


// function declarations
void DrawMouse(void);
// Draw the mouse cursor in its place

inline void DrawWave(waveform *sample);
// Draw the bloody waveform!
//
// Parameters:
//   wave - the waveform to draw

void Selection(waveform *sound);
// Draw the wave-form...taking selections into account

void SelectBox(waveform *sound, int color);
// Draw the selection box
//
// Parameters:
//   sound - the waveform in to use
//   color - the color in which to draw the box

inline void Refresh(waveform *sound);
// Refresh the screen - redraw the waveform and selection box
//
// Parameters:
//   sound - waveform to refresh

void MouseShadow(int action);
// save and restore the mouse shadow
// Parameters:
//   action - operation to perform
//     1) restore the mouse shadow
//     2) save new mouse shadow
//     3) update current mouse shadow

void PlayWave(ms_wav *sound);
// Play the current waveform, using the /dev/dsp device
//
// Parameters:
//   sound - the waveform to play back

int vga_getkey(void);
// source code snagged from one of the soundIt demo files, which was in
// turn lifted from the source for vgalib.  Useful stuff.

char *vga_gettext(char *prompt);
// Use svgalib to prompt for (and retrieve) a block of text
//
// Parameters:
//   prompt - the prompt string
//
// returns - the user's input

void init_screen(void);
// initialize svgalib

void init_mouse(void);
// initialize svgalib mouse

void init_curses(void);
// initialize curses, so I can get decent keyboard handling
