// waveform.h - header file for the waveform management code


#include "format.h"


#ifndef __WAVEFORM_H__
#define __WAVEFORM_H__

// data types
struct wavedata
{
unsigned char *data;
unsigned long size;
};

struct selecttype
{
unsigned long startindex, endindex;
int valid;
};


// C++ class definitions
class waveform
{
 public:
// constructors
waveform(char *filename); // open a file and read wave data
waveform(void); // no wave data
waveform(wavedata sound); // dump old waveform, and use the one given

virtual void WriteWave(char *filename);
// Write the waveform buffer to disk
//
// Parameters:
//   filename - the file name to save under

// wavedata info retrieval
inline long wave_size(void) {return noise.size;}
// return the size of the waveform in memory

inline unsigned char *const wave_data(void) {return noise.data;}
// return a pointer to the waveform data
// **********************************
// *                                *
// *             DANGER             *
// *                                *
// * Messing with the waveform data *
// *  without telling the waveform  *
// * class about it could result in *
// *      bad things happening!     *
// *                                *
// **********************************

// SelectRange function
inline int select_valid(void) {return SelectRange.valid;}
// Return the validity of the selection range.

inline unsigned long select_start(void);
// return the beginning of the selection range

inline unsigned long select_end(void);
// return the end of the selection range

// clipboard-related functions
void Select(long start, long end);
// Create a selection area in the wave.
// Parameters:
//   start - the file index of the beginning of the selection
//   end - the file index of the end of the selection

wavedata Cut(void);
// Cut the selection from the wave, and return a pointer to the Cut portion of
// the waveform.
//
// returns - a pointer to the waveform which was cut

wavedata Copy(void);
// Copy the selection, and return a the copied data
//
// returns - a copy of the selection

void Paste(wavedata sound, unsigned long insert);
// Paste a waveform segment into the waveform at the given location
//
// Parameters:
//   sound - the waveform segment to be inserted
//   insert - where to insert the waveform

 protected:
// private functions
void ReadWave(char *filename);
// Read the wave-form from disk
//
// Parameters:
//   filename - the name of the waveform file

// private data
wavedata noise;
selecttype SelectRange;
};


// Microsoft wav-format files
class ms_wav: public waveform
{
 public:
// constructors
ms_wav(char *filename); // open the specified file, and read it in
ms_wav(void); // dump the current waveform, if any
ms_wav(wavedata sound, WaveHeader *info); // replace current wave with new one

virtual void WriteWave(char *filename);
// Write a microsoft .wav file to disk
//
// Parameters:
//   filename - the name of the .wav file to create

// get and set the frequency
inline int get_freq(void) {return frequency;}
inline void set_freq(int new_freq) {frequency = new_freq;}

 protected:
// private data
int frequency; // playback frequency
int is_wav; // boolean - is it a valid .wav file?
WaveHeader *headers; // .wav file headers
};

#endif
