/* Definitions for Microsoft WAVE format */

#ifndef __FORMAT_H__
#define __FORMAT_H__

#define RIFF_ID		0x46464952	
#define WAVE_ID		0x45564157
#define FMT		0x20746D66
#define DATA		0x61746164
#define PCM_CODE	1
#define WAVE_MONO	1
#define WAVE_STEREO	2

/* it's in chunks like .voc and AMIGA iff, but my source say there
   are in only in this combination, so I combined them in one header;
   it works on all WAVE-file I have
*/
typedef struct _waveheader {
  u_long	main_chunk;	/* 'RIFF_ID' */
  u_long	length;		/* filelen */
  u_long	chunk_type;	/* 'WAVE_ID' */

  u_long	sub_chunk;	/* 'fmt ' */
  u_long	sc_len;		/* length of sub_chunk, =16 */
  u_short	format;		/* should be 1 for PCM-code */
  u_short	modus;		/* 1 Mono, 2 Stereo */
  u_long	sample_fq;	/* frequence of sample */
  u_long	byte_p_sec;
  u_short	byte_p_spl;	/* samplesize; 1 or 2 bytes */
  u_short	bit_p_spl;	/* 8, 12 or 16 bit */ 

  u_long	data_chunk;	/* 'data' */
  u_long	data_length;	/* samplecount */
} WaveHeader;

#endif
