
/* Generated by Interface Builder */
#import <appkit/appkit.h>
#import "Pvc_Document.h"
#import "Pvc_Control.h"

@implementation Pvc_Control

-newFrom:sender
{
    [Pvc_Document new];  // May want to put it in its own zone
    return self;
}

static id documentInWindow(id window)
/*
 * Checks to see if the passed window's delegate is a DrawDocument.
 * If it is, it returns that document, otherwise it returns nil.
 */
{
    id document = [window delegate];
    return [document isKindOf:[Pvc_Document class]] ? document : nil;
}

static id openFile(const char *directory, const char *name, BOOL display)
/*
 * Opens a file with the given name in the specified directory.
 * If we already have that file open, it is ordered front.
 * Returns the document if successful, nil otherwise.
 */
{
    char buffer[MAXPATHLEN+1], path[MAXPATHLEN+1];

    if (name && *name) {
	if (!directory) {
	    directory = ".";
	} else if (*directory != '/') {
	    strcpy(buffer, "./");
	    strcat(buffer, directory);
	    directory = buffer;
	}
	if (!chdir(directory) && getwd(path)) {
	    strcat(path, "/");
	    strcat(path, name);
	    return [Pvc_Document newFromFile:path];
	} else {
	    NXRunAlertPanel("Open", "Invalid path: %s", "OK", NULL, NULL, directory);
	}
    }

    return nil;
}

- openFrom:sender
/*
 * Called by pressing Open... in the Window menu.
 */
{
#if 0

    static int haveOpenedDocument = 0;
    static char directory[1024] = {0};
    const char *const *files;
    static const char *const sndType[2] = {"snd", NULL};
    id openpanel = [[OpenPanel new] allowMultipleFiles:YES];

    if (directory && (*directory == '/')) [openpanel setDirectory:directory];
    if ([openpanel runModalForTypes:sndType]) {
	files = [openpanel filenames];
	directory = (char *)[openpanel directory];
	while (files && *files) {
	    haveOpenedDocument = openFile(directory, *files, YES) || haveOpenedDocument;
	    files++;
	}
    }
   fprintf(stderr,"Not implemented yet\n");
   return self;

#endif
}

-saveFrom:sender
{
   fprintf(stderr,"Not implemented yet\n");
   return self;
}

-saveAsFrom:sender
{
   fprintf(stderr,"Not implemented yet\n");
   return self;
}

-closeFrom:sender
{
   fprintf(stderr,"Not implemented yet\n");
   return self;
}

- info:sender
    /* Display the info panel, unarchiving it if necessary. */
{
    if (!infoPanel) {
	infoPanel = [self loadNibSection:"info.nib" owner:self withNames:NO];
	[infoPanel center];
    }
    [infoPanel orderFront:self];

    return self;
}

@end
