/*
 * various utilities. 
 */


#include <math.h>

/* realisiert eine linare Abbildung von x von domain dl-dh auf range rl-rh */ 
float map(float dl, float dh, float rl, float rh, float x)
{	float alpha = (rh - rl) / (dh - dl);
	float b = rl - alpha * dl;
	return x * alpha + b;
}

#define CHROMBASE 1.0594631
/* liefert die frequenz in Hz des n-ten Halbtons */
float semitoneInHz (int semitone)
{	return pow (CHROMBASE, semitone);
}

/* baut eine Tabelle mit Chromatischen Werten auf. */
void buildChromTable (float *table, int first, int no)
{	int i;
	for (i = 0; i < no; i++) *(table + i) = semitoneInHz (i + first);
}

#define AMPTBLSZ 4096
float amptable[AMPTBLSZ];

/* baut eine Tabelle mit Faktoren fuer db-Werte von 100 dB bis -100 dB */
void buildDBTable ()
{	int i;
	for (i=0;i<AMPTBLSZ;i++) 
	{	amptable[i] = pow(10., map (0., AMPTBLSZ, -100., 100., i) / 20.);
	}
}        

float dBtoFactor (float dB)
{	/* return amptable[(int) (map (-100., 100., 0., AMPTBLSZ, dB) / 20.)]; */
	return pow (10., dB / 20.);
}
