/* 
 * contains cheap random number generators.
 */


#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <sys/time.h>
#include <limits.h>
#include "main.h"
#include "utils.h"
#include "synthesis.h"

/* #define rnd() (1. - 2. * ((float) rand() / RAND_MAX)) */ /* Zufallszahl zw -1 und 1 */
#define abs(x) ((x > 0) ? x : -x)

static 	double divisor;
static  struct timeval  tt;
static  struct timezone tz;

unsigned int	nowrnd = 1;
unsigned int 	rndfac = 1234567;

/* schneller, schlechter Zufall; liefert Resultat zwischen 0 und max */
float fastrnd (float max)
{	nowrnd *= rndfac;
	return (float) nowrnd / (float) UINT_MAX * max;
}

double rnd(lb, ub)
        double lb, ub;
{
        static first=1;
        if (first)
        {       gettimeofday(&tt,&tz);
                srandom(tt.tv_usec);
                first = 0;
        }
        if (divisor == 0)
                divisor = pow(2.0, (double) ((sizeof(int) * 8) - 1)) - 1.0;
        return((ub - lb) * (random() / divisor) + lb);
}

void drunk(int no)
{	float max = (fader_max[no] > fader_min[no]) ? fader_max[no] : fader_min[no];
	float min = (fader_min[no] < fader_max[no]) ? fader_min[no] : fader_max[no];
	float rndno = rnd(-1.,1.) * fader_rnd[no];
	if ((fader_value[no] + rndno) > max) fader_value[no] = max - rndno;
        if ((fader_value[no] + rndno) < min) fader_value[no] = min - rndno;
	printf ("randomizing %s: %f\n", fader_name[no], fader_value[no]);
}

/* erzeugt eine Zufallsabweichung gemaess fader_rnd[] fuer jeden Regler
(Regler, deren fader_rnd[] - Wert 0 ist bleiben unbeeinflusst */
void random_deviation()
{	int i;
	for (i = 0; i < faders_count; i++) if (fader_rnd[i] != 0) drunk (i);
	mapping();
}

void randomize(int no)
{	fader_value[no] = rnd (fader_min[no], fader_max[no]);
}

void randomize_all()
{	int i;
	for (i = 0; i < faders_count; i++) if (fader_rnd[i] != 0) randomize (i);
	mapping();
}

/* 
 * frand - return a double precision floating point random number scaled
 * to be in the range [lb,ub].
 */
double frand(lb, ub)
	double lb, ub;
{
	static first=1;
	if (first)  
	{	gettimeofday(&tt,&tz);
		srandom(tt.tv_usec); 
		first = 0;
	}	
	if (divisor == 0) 
		divisor = pow(2.0, (double) ((sizeof(int) * 8) - 1)) - 1.0;
	return((ub - lb) * (random() / divisor) + lb);
}
