#include <stdio.h>
#include <sys/types.h>
#include <math.h>
#include <audio.h>
#include <signal.h>
#include <sys/schedctl.h>
#include <ulocks.h>
#include <stropts.h>
#include <poll.h>
#include <sys/prctl.h>
#include <ulocks.h>
#include <errno.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Cardinals.h>	
#include "faders.h"
#include "main.h"
#include "synthesis.h"

ALport port;
ALconfig config;
XtInputId xt_input_id;

extern int xplotinit();
extern int xplotdata();

void run_realtime(XtPointer client_data, int *fd, XtInputId *id)
{
  beforeWritesamps();
  ALwritesamps(port,flbuf,bufsize);
  afterWritesamps();
}

void play_init(void *v)
{	int pid;
	long pvbuf[4];
	pvbuf[0] = AL_OUTPUT_RATE;
	pvbuf[2] = AL_OUTPUT_COUNT;
	ALgetparams(AL_DEFAULT_DEVICE, pvbuf, 4);
	if (samplerate) 
	{	if (pvbuf[1] != samplerate) 
		{	if (pvbuf[3] > 0) printf ("Samplerate mismatch\n");
			else 
			{	pvbuf[1] = samplerate;
				printf ("attemmting to set output samplerate to %d Hz\n", samplerate);
				ALsetparams(AL_DEFAULT_DEVICE, pvbuf, 2);
	}	}	}
	else samplerate = pvbuf[1];
 	config = ALnewconfig();
	ALsetqueuesize(config, queuesize);
	ALsetchannels(config, nochannels);
	ALsetsampfmt(config, AL_SAMPFMT_FLOAT);
	ALsetfloatmax(config, 1.0);
	port = ALopenport("granular","w",config);
	pid = getpid();
	schedctl(NDPRI,pid,NDPHIMIN);
	
	ALsetfillpoint(port,fillpoint);

	xt_input_id = XtAppAddInput(app_con, ALgetfd(port),
				    (XtPointer)XtInputWriteMask, run_realtime, NULL);

}

update()
{	mapping();
}

play_stop()
{	ALfreeconfig(config);
	ALcloseport(port);
	exit(0);
}

