/*	UGENS2.H Modified by Robin Whittle 28 August 1995 
 *	
 *	Alterations to table, tablei, itable and itablei code.
 *
 *	ugens2.h has been modified to comment the data structures.  It 
 * 	also contains new variables in the TABLE data structure
 * 	to support the new code which allows k rate control of table
 * 	number.
 */		


/*								UGENS2.H */

typedef struct {
	OPDS	h;
	float	*sr, *xcps, *iphs;
	float	curphs;
} PHSOR;

/*--------------------------------------------------------------------------*/

					/* TABLE data structure for the 
					 * table read code.
					 */

typedef struct {
					/* Opcode data structure see CS.H
 					 */
	OPDS	h;

					/* Pointers to input parameters.
					 *
					 * *rslt	Where to put output of
					 *		the function.
					 *
					 * *xndx	Index - where to look
					 *		into the table.
					 *
					 * *xfn		Number of the function
					 *		table we want to read.
					 *	
					 * *ixmode	1 to make indx and 
					 *		ixoff operate from a 
					 *		0 to 1 range.  
					 *		Otherwise their range 
					 *		is the same as the 
					 *		length of the table.
					 *
					 * *ixoff	Where in the table to 
					 *		start the indexing 
					 *		from. Fractional steps
					 * 		between locations in
					 * 		table are ignored.		
					 *
					 * *iwrap	1 turns on wrap mode 
					 *		for indx, modulo the
					 *		table length.
					 *
					 * *rslt and *indx may point to one
					 * output and input float each, or if
					 * this an a rate operation, they 
					 * point to the start of an array of 
					 * output and input values.
					 *
  					 * The others are to single values, 
					 * and they are unchanging. See lines
					 * in entry.c for details of argument
					 * types.
					 */

	float	*rslt, *xndx, *xfn, *ixmode, *ixoff, *iwrap;


					/* Local variables - local to this
					 * instance of the unit generators.
					 * Used for sharing data from the 
					 * initialisation function tblchk()
					 * to those which process the data.
					 *
					 * pfn		Previous function
					 *		table number - used
					 * 		to detect a change in
					 * 		table number when this
					 *		is supplied by a k rate
				 	 *		input parameter.
					 *
  					 * offset	= ixoff if ixmode = 0
					 *		= ixmode * tablelength
					 *		if ixmode = 1. 
					 *	
					 * xbmul	= 1 if ixmode = 0
					 *		= table length if
					 *		ixmode = 1.
					 *
					 * wrap		= iwrap
					 */
	long	pfn;

	float   offset;

	long   	xbmul, wrap;

					/* Data structure to access the 
					 * function table.
					 */
	FUNC	*ftp;
} TABLE;


/*--------------------------------------------------------------------------*/

typedef struct {
	OPDS	h;
	float	*rslt, *idel, *kamp, *idur, *ifn;
	long 	kinc, phs;
	long 	dcnt;
	FUNC	*ftp;
} OSCIL1;

typedef struct {
	OPDS	h;
	float	*sr, *xamp, *xcps, *ifn, *iphs;
	long	lphs;
	FUNC	*ftp;
} OSC;
