#include "cs.h"			/*				 MAIN.C	*/
#include "soundio.h"
						/* 9 September 1995.
						 * Mods by Robin Whittle to 
						 * make errors and reports
						 * go to the standard output
					 	 * rather than stderr.
						 *
						 * Many fprintf(stderr, . . 
						 * have been changed.
						 * This is only for the benefit
						 * of MSDOS.
						 * 
						 * Also some identification of 
						 * the program and its
						 * new features at the start
						 * and at the end of the 
						 * usage list.
						 * For ugrw1.c and ugrw2.c.
 						 */		
#ifdef THINK_C
#define main tc_main
#endif

#ifdef __ZTC__
unsigned int _stack = 0xFFF0U;
#endif

static  int	ScotScore = 0, stdinassgn = 0;
static  char	*scorename = NULL;
static  char	*xfilename = NULL;
static  char	*sortedscore = "score.srt";
static  char	*xtractedscore = "score.xtr";
static  char	*playscore = "score.srt";     /* unless we extract */
static  FILE    *scorin, *scorout, *xfile;
static  void    dieu(char *), usage(void), progid(void);
extern	OPARMS	O;
char	*orchname = NULL;  /* used by rdorch */

#define FIND(MSG)   if (*s == '\0')  \
			if (!(--argc) || ((s = *++argv) != NULL) && *s == '-') \
			    dieu(MSG);

int main(int argc, char **argv)
{
	register char c, *s;
	char  outformch, *filnamp, *envoutyp = NULL;
	int   n;
extern  int   getsizformat(int), musmon(void);
extern  char  *getstrformat(int);
extern  void  hetro(int, char **), lpanal(int, char **), pvanal(int, char **),
              cvanal(int, char **), sndinfo(int, char **);

#ifdef __ZTC__
#ifdef WITHx87
	extern int _8087;
	if (_8087 == 0)
	    die("This Csound needs an 80x87");
#endif
#endif
#ifndef THINK_C
	{
	    char *getenv(const char*);
	    if ((envoutyp = getenv("SFOUTYP")) != NULL) {
	        if (strcmp(envoutyp,"AIFF") == 0)
		    O.filetyp = TYP_AIFF;
		else if (strcmp(envoutyp,"WAV") == 0)
		    O.filetyp = TYP_WAV;
		else {
		    sprintf(errmsg,"%s not a recognized SFOUTYP env setting",
			    envoutyp);
		    dieu(errmsg);
		}
	    }
	}
#endif
	O.filnamspace = filnamp = mmalloc((long)1024);

						/* Identify the program!
						 * Robin Whittle July 95
						 */
	progid();

	if (!(--argc))
	    dieu("insufficient arguments");
	do {
	    s = *++argv;
	    if (*s++ == '-')    		      /* read all flags:  */
	        while ((c = *s++) != '\0')
		    switch(c) {
		    case 'U': FIND("no utility name")
		              if (strcmp(s,"hetro") == 0) {
				  printf("util HETRO:\n");
				  hetro(argc,argv);
			      }
		              if (strcmp(s,"lpanal") == 0) {
				  printf("util LPANAL:\n");
				  lpanal(argc,argv);
			      }
		              if (strcmp(s,"pvanal") == 0) {
				  printf("util PVANAL:\n");
				  pvanal(argc,argv);
			      }
		              if (strcmp(s,"sndinfo") == 0) {
				  printf("util SNDINFO:\n");
				  sndinfo(argc,argv);
			      }
		              if (strcmp(s,"cvanal") == 0) {
				  printf("util CVANAL:\n");
				  cvanal(argc,argv);
			      }
		              dies("-U %s not a valid UTIL name",s);
		    case 'C': O.usingcscore = 1;     /* use cscore processing  */
		              break;
		    case 'I': O.initonly = 1; 		/* I-only implies */
		    case 'n': O.sfwrite = 0;  		/* nosound	  */
		              break;
		    case 'i': FIND("no infilename")
		              O.infilename = filnamp;	/* soundin name */
		              while ((*filnamp++ = *s++));  s--;
		              if (strcmp(O.infilename,"stdout") == 0)
				  dieu("-i cannot be stdout");
		              if (strcmp(O.infilename,"stdin") == 0)
#ifdef THINK_C
				  dieu("stdin audio not supported");
#else
		              {
				  if (stdinassgn)
				      dieu("-i: stdin previously assigned");
				  stdinassgn = 1;
			      }
#endif
		              O.sfread = 1;
		              break;
		    case 'o': FIND("no outfilename")
		              O.outfilename = filnamp;		/* soundout name */
		              while ((*filnamp++ = *s++)); s--;
		              if (strcmp(O.outfilename,"stdin") == 0)
				  dieu("-o cannot be stdin");
		              if (strcmp(O.outfilename,"stdout") == 0) {
#if defined THINK_C || defined BCC || defined __unix
				  dieu("stdout audio not supported");
#else
				  if ((O.stdoutfd = dup(1)) < 0) /* redefine stdout */
				      die("too many open files");
				  dup2(2,1);                /* & send 1's to stderr */
#endif
			      }
		              break;
		    case 'b': FIND("no iobufsamps")
		              sscanf(s,"%d",&O.outbufsamps);/* defaults in musmon.c */
		              O.inbufsamps = O.outbufsamps;
		              while (*++s);
		              break;
		    case 'B': FIND("no hardware bufsamps")
			      sscanf(s,"%ld",&O.oMaxLag);/* defaults in rtaudio.c */
		              while (*++s);
		              break;
		    case 'A': if (O.filetyp == TYP_WAV) {
		                  if (envoutyp == NULL) goto outtyp;
				  warning("-A overriding local default WAV out");
			      }
		              O.filetyp = TYP_AIFF;     /* AIFF output request  */
		              break;
		    case 'W': if (O.filetyp == TYP_AIFF) {
		                  if (envoutyp == NULL) goto outtyp;
				  warning("-W overriding local default AIFF out");
			      }
		              O.filetyp = TYP_WAV;      /* WAV output request  */
		              break;
		    case 'h': O.sfheader = 0;           /* skip sfheader  */
		              break;
		    case 'c': if (O.outformat) goto outform;
		              outformch = c;
		              O.outformat = AE_CHAR;	/* 8-bit char soundfile */
		              break;
		    case 'a': if (O.outformat) goto outform;
		              outformch = c;
		              O.outformat = AE_ALAW;	/* a-law soundfile */
		              break;
		    case 'u': if (O.outformat) goto outform;
		              outformch = c;
		              O.outformat = AE_ULAW;	/* mu-law soundfile */
		              break;
		    case 's': if (O.outformat) goto outform;
		              outformch = c;
		              O.outformat = AE_SHORT;	/* short_int soundfile */
		              break;
		    case 'l': if (O.outformat) goto outform;
		              outformch = c;
		              O.outformat = AE_LONG;	/* long_int soundfile */
		              break;
		    case 'f': if (O.outformat) goto outform;
		              outformch = c;
		              O.outformat = AE_FLOAT;	/* float soundfile */
		              break;
		    case 'r': FIND("no sample rate")
		              sscanf(s,"%ld",&O.sr_override);
		              while (*++s);
		              break;
		    case 'k': FIND("no control rate")
		              sscanf(s,"%ld",&O.kr_override);
		              while (*++s);
		              break;
		    case 'v': O.odebug = odebug = 1;	/* verbose otran  */
		              break;
		    case 'm': FIND("no message level")
		              sscanf(s,"%d",&O.msglevel);
		              while (*++s);
		              break;
		    case 'd': O.displays = 0;         	/* no func displays */
		              break;
		    case 'g': O.graphsoff = 1;         	/* don't use graphics */
		              break;
		    case 'S': ScotScore++;
		              break;
		    case 'x': FIND("no xfilename")
		              xfilename = s;  		/* extractfile name */
		              while (*++s);
		              break;
		    case 't': FIND("no tempo value")
		              sscanf(s,"%d",&O.cmdTempo);/* use this tempo ..  */
		              while (*++s);
			      if (O.cmdTempo <= 0) dieu("illegal tempo");
			      O.Beatmode = 1;        /* on uninterpreted Beats */
		              break;
		    case 'L': FIND("no Linein score device_name")
		              O.Linename = filnamp;	/* Linein device name */
		              while ((*filnamp++ = *s++));  s--;
		              if (!strcmp(O.Linename,"stdin")) {
				  if (stdinassgn)
				      dieu("-L: stdin previously assigned");
				  stdinassgn = 1;
			      }
	                      O.Linein = 1;
		              break;
		    case 'M': FIND("no midi device_name")
		              O.Midiname = filnamp;	/* Midi device name */
		              while ((*filnamp++ = *s++));  s--;
		              if (!strcmp(O.Midiname,"stdin")) {
				  if (stdinassgn)
				      dieu("-M: stdin previously assigned");
				  stdinassgn = 1;
				}
	                      O.Midiin = 1;
		              break;
		    case 'F': FIND("no midifile name")
		              O.FMidiname = filnamp;	/* Midifile name */
		              while ((*filnamp++ = *s++));  s--;
		              if (!strcmp(O.FMidiname,"stdin")) {
				  if (stdinassgn)
				      dieu("-F: stdin previously assigned");
				  stdinassgn = 1;
				}
	                      O.FMidiin = 1;          /***************/
		              break;
		    case 'P': FIND("no pedal threshold")
		              sscanf(s,"%d",&O.SusPThresh);
		              while (*++s);
		              break;
		    case 'R': O.rewrt_hdr = 1;
		              break;
		    case 'H': O.heartbeat = 1;
		              break;
		    case 'N': O.ringbell = 1;         	/* notify on completion */
		              break;
		    case 'T': O.termifend = 1;       /* terminate on midifile end */
			      break;
		    case 'D': O.gen01defer = 1;  /* defer GEN01 sample loads 
                                                    until performance time */
                              break;
		    default:  sprintf(errmsg,"unknown flag -%c", c);
		              dieu(errmsg);
		    }
	    else {
	        if (orchname == NULL)
		    orchname = --s;
	        else if (scorename == NULL)
		    scorename = --s;
		else dieu("too many arguments");
	    }
	} while (--argc);

	if (O.Linein || O.Midiin || O.FMidiin)
	    O.RTevents = 1;
	if (O.RTevents || O.sfread)
	    O.ksensing = 1;
	if (!O.outformat)                       /* if no audioformat yet  */
	    O.outformat = AE_SHORT;             /*  default to short_ints */
	O.outsampsiz = getsizformat(O.outformat);
	O.informat = O.outformat; /* informat defaults; resettable by readinheader */
	O.insampsiz = O.outsampsiz;
	if (O.filetyp == TYP_AIFF || O.filetyp == TYP_WAV) {
	    if (!O.sfheader)
	        dieu("can't write AIFF/WAV soundfile with no header");
	    if (O.outformat == AE_ALAW || O.outformat == AE_ULAW
	      || O.outformat == AE_FLOAT) {
	        sprintf(errmsg,"AIFF/WAV does not support %s encoding",
		     getstrformat(O.outformat));
		dieu(errmsg);
	    }
	}
	if (O.rewrt_hdr && !O.sfheader)
	    dieu("can't rewrite header if no header requested");
	if (O.sr_override || O.kr_override) {
	    long ksmpsover;
	    if (!O.sr_override || !O.kr_override)
	        dieu("srate and krate overrides must occur jointly");
	    ksmpsover = O.sr_override / O.kr_override;
	    if (ksmpsover * O.kr_override != O.sr_override)
	        dieu("command-line srate / krate not integral");
	}
	if (orchname == NULL)
	    dieu("no orchestra name");
	else printf("orchname:  %s\n", orchname);
	if (scorename != NULL)
	    printf("scorename: %s\n", scorename);
	if (xfilename != NULL)
	    printf("xfilename: %s\n", xfilename);
#ifdef SYS5
	{
	  static  char  buf[80];
	  VMSG(setvbuf(stdout,buf,_IOLBF,80);)
	}
#else
#ifndef THINK_C
	VMSG(setlinebuf(stdout);)
#endif
#endif
	if (scorename == NULL) {
	    if (O.RTevents) {
	        printf("realtime performance using dummy numeric scorefile\n");
		goto perf;
	    }
	    else scorename = "score.srt";
	}
	if (ScotScore) {                          /* if score in Scot format  */
	    if (!(scorin = fopen(scorename, "r")))
	        dies("cannot open scorefile %s", scorename);
	    if (!(scorout = fopen("score", "w")))
	        die("cannot open scotout score for writing");
	    printf("translating Scot score ...\n");
	    scot(scorin, scorout, scorename);      /*    do Scot translation  */
	    fclose(scorin);
	    fclose(scorout);
	    scorename = "score";                   /*    and use this "score" */
	}
	if ((n = strlen(scorename)) > 4            /* if score ?.srt or ?.xtr */
	  && (!strcmp(scorename+n-4,".srt")
	      || !strcmp(scorename+n-4,".xtr"))) {
	    printf("using previous %s\n",scorename);
	    playscore = sortedscore = scorename;            /*   use that one */
	}
	else {
	    if (!(scorin = fopen(scorename, "r")))          /* else sort it   */
	        dies("cannot open scorefile %s", scorename);
	    if (!(scorout = fopen(sortedscore, "w")))
	        dies("cannot open %s for writing", sortedscore);
	    printf("sorting score ...\n");
	    scsort(scorin, scorout);
	    fclose(scorin);
	    fclose(scorout);
	}
	if (xfilename != NULL) {                        /* optionally extract */
	    if (!strcmp(scorename,"score.xtr"))
	        dies("cannot extract %s, name conflict",scorename);
	    if (!(xfile = fopen(xfilename, "r")))
	        dies("cannot open extract file %s", xfilename);
	    if (!(scorin = fopen(sortedscore, "r")))
	        dies("cannot reopen %s", sortedscore);
	    if (!(scorout = fopen(xtractedscore, "w")))
	        dies("cannot open %s for writing", xtractedscore);
	    printf("  ... extracting ...\n");
	    scxtract(scorin, scorout, xfile);
	    fclose(scorin);
	    fclose(scorout);
	    playscore = xtractedscore;
	}	    
	printf("\t... done\n");

	s = playscore;
	O.playscore = filnamp;
	while ((*filnamp++ = *s++));	/* copy sorted score name */

perf:	O.filnamsize = filnamp - O.filnamspace;
	otran();		/* read orcfile, setup desblks & spaces     */
	return musmon();        /* load current orch and play current score */



outtyp: dieu("output soundfile cannot be both AIFF and WAV");

outform: sprintf(errmsg,"sound output format cannot be both -%c and -%c",
		outformch, c);
	dieu(errmsg);
}

static void dieu(char *s)
{

/*        printf("Csound Command ERROR:\t%s\n",s); */

						/* Make this goes to standard
						 * console out - not stderr 
						 * which cannot be redirected 
						 * to a file.
						 *
						 * Also modify the usage() 
						 * subroutine below similarly.
						 * 
						 * This is really a problem 
						 * with MSDOS - but I don't
						 * know any other means of 
						 * solving it.
						 *
						 * Robin Whittle 20 July 1995
						 */
        printf("Csound Command ERROR:\t%s\n",s);

	usage();
}

static void progid(void)
						/* Display the program 
						 * identification at the 
					 	 * start under all
						 * circumstances, but also
						 * at the end of the usage
						 * text.  This is so the 
						 * user can see it instead of
						 * it scrolling off the screen.      
						 *                            Limit --->|
						 *					|    
						 */
{
printf("\nMSDOS Csound Version 3.29 JPFF Version 12 RW Version 1.00 compiled with DJGPP,\n");
printf("based on source code from John Fitch at Bath University - Thanks!!!\n");
printf("With modifications by Robin Whittle  9 September 1995  rwhittle@ozonline.com.au\n");
printf("See CSRW_DOC.TXT and John Fitch's README.CSO 14 April 95.\n");
printf("Csound was written by Barry Vercoe - see the copyright notice in the doco.\n\n");
printf("1  - Usage and error messages now go to stdout so they can be redirected to a \n");
printf("     file in MSDOS systems:  CSOUND > BLAH.\n");
printf("2  - Table read ugens have had four bugs removed.\n");
printf("3  - New table read ugens for k rate control of table number.\n");
printf("4  - New table write ugens: tablew, itablew, tablewkt, itablewkt.\n");
printf("5  - New ugens: tablemix, tablecopy, tablegpw, tableleng.\n");
printf("6  - New ugens: tablera & tablewa read and write tables sequentially at a rate.\n");
printf("7  - New ugens: the zak system for patching and modulating.\n");
printf("8  - New ugens: for reading time.\n");
printf("9  - ipow and kpow: inorm parameter is now optional.\n");
printf("10 - New ugens: printk and printks for printing k rate variables as numbers.\n");
printf("11 - Maximum instrument number is now 1200. Maximum table number is 1000.\n");
printf("12 - New k rate filter ugens: kport, ktone, katone, kreson, kareson.\n");
printf("13 - New i, k and a rate ugens: limit and ilimit.\n");
printf("14 - 31 bit global pseudo-random generator for xlinrand etc. \n");
printf("15 - New ugen: xunirand 0 to 1 uniform distribution random number generator.\n");
}

static void usage(void)
{
#ifdef M_I286
fprintf(stderr, "See usage.txt\n");
#else
printf("Usage:\tcsound [-flags] orchfile scorefile\n");
printf("Legal flags are:\n");
printf("-U unam\trun utility program unam\n");
printf("-C\tuse Cscore processing of scorefile\n");
printf("-I\tI-time only orch run\n");
printf("-n\tno sound onto disk\n");
printf("-i fnam\tsound input filename\n");
printf("-o fnam\tsound output filename\n");
printf("-b N\tsample frames (or -kprds) per software sound I/O buffer\n");
printf("-B N\tsamples per hardware sound I/O buffer\n");
printf("-A\tcreate an AIFF format output soundfile\n");
printf("-W\tcreate a WAV format output soundfile\n");
printf("-h\tno header on output soundfile\n");
printf("-c\t8-bit signed_char sound samples\n");
printf("-a\talaw sound samples\n");
printf("-u\tulaw sound samples\n");
printf("-s\tshort_int sound samples\n");
printf("-l\tlong_int sound samples\n");
printf("-f\tfloat sound samples\n");
printf("-r N\torchestra srate override\n");
printf("-k N\torchestra krate override\n");
printf("-v\tverbose orch translation\n");
printf("-m N\ttty message level. Sum of: 1=note amps, 2=out-of-range msg, 4=warnings\n");
printf("-d\tsuppress all displays\n");
printf("-g\tsuppress graphics, use ascii displays\n");
printf("-S\tscore is in Scot format\n");
printf("-x fnam\textract from score.srt using extract file 'fnam'\n");
printf("-t N\tuse uninterpreted beats of the score, initially at tempo N\n");
printf("-L dnam\tread Line-oriented realtime score events from device 'dnam'\n");
printf("-M dnam\tread MIDI realtime events from device 'dnam'\n");
printf("-F fnam\tread MIDIfile event stream from file 'fnam'\n");
printf("-P N\tMIDI sustain pedal threshold (0 - 128)\n");
printf("-R\tcontinually rewrite header while writing soundfile (WAV/AIFF)\n");
printf("-H\tprint a heartbeat character at each soundfile write\n");
printf("-N\tnotify (ring the bell) when score or miditrack is done\n");
printf("-T\tterminate the performance when miditrack is done\n");
printf("-D\tdefer GEN01 soundfile loads until performance time\n");
printf("flag defaults: csound -s -otest -b%d -B%d -m7 -P128\n",
	IOBUFSAMPS, IODACSAMPS);
		
					/* Display program version.
					 */								
	progid();

        exit(1);
#endif
}
