#include "cs.h"                 /*                                 MUSMON.C     */
#include "cscore.h"
#include "midiops.h"
#include "soundio.h"

#define	SEGAMPS	01
#define	SORMSG	02

extern	INSTRTXT *instrtxtp[];
extern	INSDS	actanchor, *frstoff;

int	insno;
char	strmsg[100];

float	maxamp[4], *maxampend, smaxamp[4], omaxamp[4];
long	rngcnt[4], srngcnt[4], orngcnt[4];
short	rngflg = 0, srngflg = 0, multichan = 0;
int	sensType = 0;

extern  int	Mxtroffs, MTrkend;
extern  OPARMS  O;
extern  MEVENT  *Midevtblk, *FMidevtblk;
extern  EVTBLK	*Linevtblk;
static  EVTBLK	*scorevtblk;
static	short	offonly = 0;
static	short	sectno = 0;
static	long	kcnt = 0;
static	float	timtot = 0.;
static  float   betsiz, ekrbetsiz;

static void settempo(tempo)
 float tempo;
{
        if (tempo > 0.) {
	    betsiz = 60. / tempo;
	    ekrbetsiz = ekr * betsiz;
	}
}

void tempset(p)
 TEMPO *p;
{
        float tempo;

        if ((tempo = *p->istartempo) <= 0.)
	    initerror("illegal istartempo value");
        else {
	    settempo(tempo);
	    p->prvtempo = tempo;
	}
}

void tempo(p)
 TEMPO *p;
{
       if (*p->ktempo != p->prvtempo) {
	   settempo(*p->ktempo);
	   p->prvtempo = *p->ktempo;
       }
}

extern  MCHNBLK *m_chnbp[];
extern  void    RTLineset(), MidiOpen(), FMidiOpen();
extern  void    scsort(), oload(), cscorinit(), cscore();
extern  void    schedofftim(), infoff(), orcompact(), rlsmemfiles();
extern  void    timexpire(), beatexpire(), deact(), fgens();
extern	void    sfopenin(), sfopenout(), sfnopenout();
extern	void    iotranset(), sfclosein(), sfcloseout();
extern  long    kcounter;
extern  FILE    *scfp, *oscfp;
extern	OPARMS	O;

static  int     playevents(), lplayed = 0;
static  int     segamps, sormsg;
static	EVTBLK	*e = NULL;
static	float	*maxp;
static	long	*rngp;
static  EVENT   **ep, **epend;  /* pointers for stepping through lplay list */
static  EVENT   *lsect = NULL;
static  float   curbt, curp2;
void    beep();

int musmon()
{
	int	n;

#ifdef __ZTC__
#ifdef WITHx87
	fprintf(stderr,"MIT Csound:  %d86 with floating point, v%d.%d\n",
		__I86__, VERSION, SUBVER);
#else
	fprintf(stderr,"MIT Csound:  %d86, v%d.%d\n", __I86__, VERSION, SUBVER);
#endif
#else
	fprintf(stderr,"MIT Csound:\n");
#endif
	oload();			/* set globals and run inits */
	printf("orch now loaded\n");
	dispinit();	        /* initialise graphics or character display */

        multichan = (nchnls > 1) ? 1:0;
	maxampend = &maxamp[nchnls];
	segamps = O.msglevel & SEGAMPS;
	sormsg = O.msglevel & SORMSG;

	if (O.Linein)  RTLineset();               /* if realtime input expected	*/
	if (O.Midiin)  MidiOpen();                /*   alloc bufs & open files	*/
	if (O.FMidiin) FMidiOpen();
	if (O.outbufsamps < 0) {		/* if k-aligned iobufs requestd */
	    O.inbufsamps = O.outbufsamps *= -ksmps; /*  set from absolute value */
	    printf("k-period aligned audio buffering\n");
	}
	else {          			/* else keep the user values    */
	    if (!O.inbufsamps)  O.inbufsamps = IOBUFSAMPS;
	    if (!O.outbufsamps) O.outbufsamps = IOBUFSAMPS; /* or get defaults  */
	}
	printf("audio buffered in %d sample-frame blocks\n", O.outbufsamps);
	O.inbufsamps *= nchnls;			/* now adjusted for n channels  */
	O.outbufsamps *= nchnls;
	if (O.sfread)     			/* if audio-in requested,	*/
	    sfopenin();         		/*   open/read? infile or device */
	if (O.sfwrite)    			/* if audio-out requested,	*/
	    sfopenout();        		/*   open the outfile or device	*/
	else sfnopenout();
	iotranset();    		/* point recv & tran to audio formatter	*/

	curp2 = curbt = 0.0;
	if (O.Beatmode)                        /* if performing from beats	*/
	    settempo((float)O.cmdTempo);       /*   set the initial tempo  	*/

	if (!(scfp = fopen(O.playscore, "r")))
	    dies("cannot reopen %s", O.playscore);
	if (O.usingcscore) {
	    if (lsect == NULL) {
	        lsect = (EVENT *) mmalloc((long)sizeof(EVENT));
		lsect->op = 'l';
	    }
	    printf("using Cscore processing\n");
	    if (!(oscfp = fopen("cscore.out", "w")))	/* override stdout in   */
	        die("cannot create cscore.out");	/* rdscor for cscorefns */
	    cscorinit();
	    cscore();           /* call cscore, optionally re-enter via lplay() */
	    fclose(oscfp);
	    fclose(scfp);	
	    if (lplayed) goto done;

	    if (!(scfp = fopen("cscore.out", "r")))	/*   rd from cscore.out */
	        die("cannot reopen cscore.out");
	    if (!(oscfp = fopen("cscore.srt", "w")))	/*   writ to cscore.srt */
	        die("cannot reopen cscore.srt");
	    printf("sorting cscore.out ..\n");
	    scsort(scfp, oscfp);			/* call the sorter again */
	    fclose(scfp);
	    fclose(oscfp);
	    printf("\t... done\n");
	    if (!(scfp = fopen("cscore.srt", "r")))	/*   rd from cscore.srt */
	        die("cannot reopen cscore.srt");
	    printf("playing from cscore.srt\n");
	    O.usingcscore = 0;
	}
	if (e == NULL)
	    e = scorevtblk = (EVTBLK *) mmalloc((long)sizeof(EVTBLK));
	printf("SECTION %d:\n",++sectno);
	playevents();                      /* play all events in the score */

done:	printf("end of score.\t\t   overall amps:");
	for (maxp=omaxamp, n=nchnls; n--; )
	    printf("%9.1f", *maxp++);
	if (O.outformat != AE_FLOAT) {
	    printf("\n\t   overall samples out of range:");
	    for (rngp=orngcnt, n=nchnls; n--; )
		printf("%9ld", *rngp++);
	}
	printf("\n%d errors in performance\n",perferrcnt);
	if (O.sfread)
	    sfclosein();
	if (O.sfwrite)
	    sfcloseout();
	else printf("no sound written to disk\n");
	if (O.ringbell) beep();

	return dispexit();      /* hold or terminate the display output     */
				/* for Mac, dispexit returns 0 to exit immediately */
}

void beep()
{
	printf("%c\tbeep!\n",'\007');
}

void lplay(a)               /* cscore re-entry into musmon */
 EVLIST *a;
{
	lplayed = 1;
	if (!sectno)  printf("SECTION %d:\n",++sectno);
        ep = &a->e[1];            /* from 1st evlist member */
	epend = ep + a->nevents;  /*   to last              */
	playevents();             /* play list members      */
}

static playevents() {        /* play all events in a score or an lplay list */
	int	n;
	float	prvbt, nxtim, nxtbt, *smaxp;
	long	*srngp;
	char    opcod;

	while (1) {		/* read each score event:	*/
	        if (O.usingcscore) {         /*   i.e. get next lplay event  */
		    if (ep < epend)
			e = (EVTBLK *) &((*ep++)->strarg);     /* nxt event  */
		    else e = (EVTBLK *) &(lsect->strarg);      /* else lcode */ 
		}
		else if (!(rdscor(e)))       /*   or rd nxt evt from scorfil */
		     e->opcod = 'e';
	retest:	offonly = 0;
		switch(e->opcod) {
		case 'w':
		        if (O.Beatmode)               /* Beatmode: read 'w'  */
			    settempo(e->p2orig);      /*   to init the tempo */
			continue;                     /*   for this section  */
		case 'i':
		case 'f':
		case 'a':
			if (frstoff != NULL) {
			    if (O.Beatmode) {
				if (frstoff->offbet < e->p2orig)
				    goto setoff;
			    }
			    else {
				if (frstoff->offtim < e->p[2])
				    goto setoff;
			    }
			}
			nxtim = e->p[2];
			nxtbt = e->p2orig;
			break;
		case 'l':
			if (frstoff != NULL)
			    goto setoff;
			goto lcode;
		case 's':
		case 'e':
			if (frstoff == NULL)
			    goto scode;
	    setoff:	nxtim = frstoff->offtim;
	      		nxtbt = frstoff->offbet;
			offonly = 1;
			break;
		default:
			printf("error in score.  illegal opcode %c (ASCII %d)\n",
			       e->opcod, e->opcod);
			perferrcnt++;
			continue;
		}
		if (MTrkend && O.termifend && frstoff == NULL) {
		    printf("terminating. ");
		    return(0);                 /* aborting with perf incomplete */
		}
		if (O.Beatmode)
		    kcnt = (nxtbt - curbt) * ekrbetsiz + 0.5;
		else kcnt = (nxtim - curp2) * ekr + 0.5;
		if (kcnt > 0) { 		/* perf for kcnt kprds	*/
		    long kdone, kperf();
		    if (!O.initonly
		     && (kdone = kperf(kcnt)) < kcnt) { /* early rtn:  RTevent  */
			curp2 += kdone * onedkr;        /*    update only curp2 */
			if (sensType == 1) {            /*    for Linein,       */
			    e = Linevtblk;              /*      get its evtblk  */
			    e->p[2] = curp2;            /*      & insert curp2  */
			}
			if (!kdone)                     /* if null duration,    */
			    goto mtest;                 /*  chk for midi on-off */
			if (segamps || sormsg && rngflg)
			    printf("  rtevent:\t   T%7.3f TT%7.3f M:",
				   curp2,timtot+curp2);
		    }
		    else {                              /* else a score event:  */
			prvbt = curbt;
			curbt = nxtbt;                  /*    update beats too  */
			curp2 = nxtim;
			if (segamps || sormsg && rngflg)
			    printf("B%7.3f ..%7.3f T%7.3f TT%7.3f M:",
				prvbt,	curbt,	curp2,	timtot+curp2);
		    }
		    if (segamps || sormsg && rngflg) {
			for (n=nchnls, maxp=maxamp; n--;)
			    printf("%9.1f", *maxp++);
			putchar('\n');
			if (rngflg) {
			    printf("\t number of samples out of range:");
			    for (n=nchnls, rngp=rngcnt; n--;)
				printf("%9ld", *rngp++);
			    putchar('\n');
			    rngflg = 0;
			    srngflg++;
			}
		    }
		    for (n=nchnls,maxp=maxamp-1,smaxp=smaxamp-1,
			 rngp=rngcnt,srngp=srngcnt; n--; ) {
		        if (*++maxp > *++smaxp)
			    *smaxp = *maxp;
			*maxp = 0;
			*srngp++ += *rngp;
			*rngp++ = 0;
		    }
		}
		if (sensType == 0) {     /* if this was a score or turnoff time:  */
		    if (frstoff != NULL) {		/* if turnoffs pending,   */
		        if (O.Beatmode)
			    beatexpire(curbt + hfkprd);	/*  rm any expired instrs */
			else timexpire(curp2 + hfkprd);
		    }
		    if (offonly)
			goto retest;    		/*  if offonly, loop back */
		}
	mtest:	if (sensType >= 2) {                    /* Midievent:             */
		    register MEVENT *mep;
		    register MCHNBLK *chn;

		    if (sensType == 2)                  /* realtime or Midifile  */
		        mep = Midevtblk;
		    else mep = FMidevtblk;
		    chn = m_chnbp[mep->chan];
		    insno = chn->pgmno;
		    if (mep->type == NOTEON_TYPE && mep->dat2) { /* midi note ON: */
		        if (n = MIDIinsert(insno,chn,mep)) {  /* alloc,init,activ */
			    printf("\t\t   T%7.3f - note deleted. ", curp2);
			    printf("instr %d had %d init errors\n", insno, n);
			    perferrcnt++;
			}
		    }
		    else {                              /* else midi note OFF:    */
		        short pch = mep->dat1;
		        INSDS *ip = chn->kinsptr[pch];
			if (ip == NULL)                 /*  if already off, done  */
			    Mxtroffs++;
			else {
			    chn->kinsptr[pch] = NULL;   /*  mark this key off     */
			    if (chn->sustaining) {      /*  if sustain pedal on   */
			        chn->ksusptr[pch] = ip;
				chn->ksuscnt++;         /*    let the note ring   */
			    }
			    else {                      /*  else some kind of off */
				if (ip->xtratim) {      /*    if offtime delayed  */
				    ip->relesing = 1;   /*      enter reles phase */
				    ip->offtim = (kcounter + ip->xtratim) * onedkr;
				    schedofftim(ip);    /*      & put in offqueue */
				}
				else deact(ip);         /*    else off now        */
			    }
			}
		    }
		}
		else switch(e->opcod) {                 /* scorevt or Linevt:     */
		case 'i':
			insno = abs((int)e->p[1]);
			if (insno > MAXINSNO || instrtxtp[insno] == NULL) {
			    if (sensType) printf("\t\t   T%7.3f",curp2);
			    else  printf("\t  B%7.3f",curbt);
			    printf(" - note deleted. instr %d undefined\n",insno);
			    perferrcnt++;
			}
			else if (e->p[1] < 0.)  	/* if p1 neg,        	  */
			    infoff(-e->p[1]);           /*  turnoff any infin cpy */
			else {
			    if (O.Beatmode && e->p3orig >= 0.)
				e->p[3] = e->p3orig * betsiz;
			    if (n = insert(insno,e)) {  /* else aloc,init,activat */
			        if (sensType) printf("\t\t   T%7.3f",curp2);
				else  printf("\t  B%7.3f",curbt);
				printf(" - note deleted.  i%d had %d init errors\n",
				   insno, n);
				perferrcnt++;
			    }
			}
			break;
		case 'f':
			fgens(e);
			break;
		case 'a':
			curp2 = e->p[2] + e->p[3];
			curbt = e->p2orig + e->p3orig;
			printf("time advanced %5.3f beats by score request\n",
			       e->p3orig);
			break;
		}
		if (sensType) {                    /* RT event now done:          */
		    sensType = 0;
		    e = scorevtblk;                /*    return to score context  */
		    goto retest;                   /*    and resume the kperf     */
		}
		continue;                          /* else get next score event   */

	lcode:	printf("end of lplay event list\t      peak amps:");
		for (n=nchnls, maxp=smaxamp; n--; )
		    printf("%9.1f", *maxp++);
		putchar('\n');
		if (srngflg) {
		    printf("\t number of samples out of range:");
		    for (n=nchnls, srngp=srngcnt; n--; )
			printf("%9ld", *srngp++);
		    putchar('\n');
		    srngflg = 0;
		}
		return(0);

	scode:	if ((opcod = e->opcod) == 's'       /* for s, or e after s   */
		 || (opcod == 'e' && sectno > 1)) {
		    timtot += curp2;
		    prvbt = curbt = curp2 = 0;
		    printf("end of section %d\t sect peak amps:",sectno);
		    for (n=nchnls, maxp=smaxamp; n--; )
			printf("%9.1f", *maxp++);
		    putchar('\n');
		    if (srngflg) {
			printf("\t number of samples out of range:");
			for (n=nchnls, srngp=srngcnt; n--; )
			    printf("%9ld", *srngp++);
			putchar('\n');
			srngflg = 0;
		    }
		}
		for (n=nchnls, smaxp=smaxamp-1, maxp=omaxamp-1, 
				srngp=srngcnt,   rngp=orngcnt; n--; ) {
		    if (*++smaxp > *++maxp)
		        *maxp = *smaxp;		/* keep ovrl maxamps */
		    *smaxp = 0;
		    *rngp++ += *srngp;		/*   and orng counts */
		    *srngp++ = 0;
		}
		if (opcod == 's') {             	/* if s code,        */
		    orcompact();			/*   rtn inactiv spc */
		    if (actanchor.nxtact == NULL)       /*   if no indef ins */
		        rlsmemfiles();                  /*    purge memfiles */
		    curp2 = curbt = 0.0;		/*   reset sec times */
		    printf("SECTION %d:\n", ++sectno);
		}					/*   & back for more */
		else break;
	}
	return(1);  /* done with entire score */
}

