/*******************************************************************************
 *
 *         tc_backgrd.c
 *
 * This code allows mac Csound to run in the background.  Initial version by
 * Ross Bencina, Latrobe Australia.  Revisions by Bill Gardner & BV.
 *
 * The code below calls WaitNextEvent() every kForegroundTicks when Csound is
 * the front app, and every kBackgroundTicks when it's in the background.
 * Performance tweaks are possible by modifying these values:
 *
 * kForegroundTicks: Number of ticks (1/60 sec) between WaitNextEvent calls.
 * Affects how often background apps. get processing time when Csound is in
 * foreground, and also how quickly Csound responds to menu selection/program
 * switching.  The smaller the value, the less efficient Csound is.
 *
 * kBackgroundTicks: Number of ticks Csound will use the processor if given a
 * chance while in the background.  If response in foreground applications is
 * too slow, reduce this value.
 *
 * kSleep:  No of ticks background applications get while Csound is foreground.
 * A value of 0L will lock out background apps. (Unsure about backgrnd printing.) 
 *
 * Minor Problem: If table graphics are on, the ftable graphs are permanantly
 * erased if they get covered.  No current plans to fix this.
 *
 * When linking, must enable these SIZE flags in Set project type... menu:
 *      Multifinder aware
 *	Background Null events
 *	suspend/resume events.
 */

#include <console.h>

#define APPLE_ID         1  /*Apple menu ID*/
#define kForegroundTicks 30
#define kBackgroundTicks 5 
#define kSleep           0L

static int  inForeground = 0;     /* flag to keep track of foregrounding */
static long nxtChkTime = 0;

void DoMenuClick(long select);    /* prototype from tc_menu.c */

void STasks()
{
        EventRecord evt;
	WindowPtr   whichWindow;
	int         x, y, ch;
	long        thePart;
 
	if (Ticks < nxtChkTime)      /* Ticks is global tickcount since startup */
	    return;

	if (inForeground && isAbortEvent()) {
	    printf("ABORTING...\n");
	    ExitToShell();
	}
chkev:	if (WaitNextEvent(everyEvent, &evt, kSleep, (void *)0L)) {
	    switch (evt.what) {
	    case updateEvt:                 /* force console driver to update */
		cgetxy(&x, &y, stdout);
		break;
	    case osEvt:
		if ((evt.message & suspendResumeMessage) == resumeFlag)
		    inForeground = 1;
		else inForeground = 0;
		goto chkev;     /* chk Events again when switching betw apps. */
	    case mouseDown:
		thePart = FindWindow(evt.where,&whichWindow);
		switch(thePart) {
		case inMenuBar:
		    DoMenuClick(MenuSelect(evt.where));
		    break;
		case inSysWindow:
		    SystemClick(&evt,whichWindow);
		    break;
		case inDrag:
		    DragWindow(whichWindow,evt.where,&screenBits.bounds);
		    break;
		default:
		    break;
		}
	    }
	}
	if (inForeground)
	    nxtChkTime = Ticks + kForegroundTicks;
	else nxtChkTime = Ticks + kBackgroundTicks;
}


