#include "cs.h"			/*				 MAIN.C	*/
#include "soundio.h"

#ifdef THINK_C
#define main tc_main
#endif

int	odebug = 0;		/* orch control switches	*/
int	initonly = 0;		/*   and default values		*/
int	sfread = 0;
int	sfwrite = 1;
int	sfheader = 1;
int     aiffOut = 0;
int	inbufsamps = 0, outbufsamps = 0;
int	informat, outformat = 0;  /* set below */
int	insampsiz, outsampsiz;    /* set below */
int	displays = 1;
int	graphsoff = 0;
int	msglevel = 7;
int	Beatmode = 0, cmdTempo, oMaxLag = 0;
int	Linein = 0, Midiin = 0, FMidiin = 0;
int	RTevents = 0, ksensing = 0;
int	SusPThresh = 128;
int	ringbell = 0, termifend = 0;

char	*orchname;
char	*infilename;
char	*outfilename;
char	*Linename, *Midiname, *FMidiname;
int	infd = 0;
int	outfd = 0;

static  int	ScotScore = 0, stdinassgn = 0;
static  char	*scorename;
static  char	*xfilename;
static  char	*sortedscore = "score.srt";
static  char	*xtractedscore = "score.xtr";
static  char	*playscore = "score.srt";     /* unless we extract */
static  FILE    *scorin, *scorout, *xfile;
        FILE    *scfp = NULL;
static  void    usage();

#define FIND(MSG)   if (*s == '\0')  \
			 if (!(--argc) || (s = *++argv) && *s == '-') \
			     dieu(MSG);

main(argc,argv)
 int argc;
 char **argv;
{
	register char c, *s;
	char  outformch;
	int   n;
	extern int getsizformat();
	extern char *getstrformat();
	extern void musmon();

	if (!(--argc))
	    dieu("insufficient arguments");
	do {
	    s = *++argv;
	    if (*s++ == '-')    		      /* read all flags:  */
	        while ((c = *s++) != '\0')
		    switch(c) {
		    case 'I': initonly = 1; 		/* I-only implies */
		    case 'n': sfwrite = 0;  		/* nosound	  */
		              break;
		    case 'i': FIND("no infilename")
		              infilename = s;		/* soundin name */
		              while (*++s);
		              if (strcmp(infilename,"stdout") == 0)
				  dieu("-i cannot be stdout");
		              if (strcmp(infilename,"stdin") == 0)
#ifdef THINK_C
				  dieu("stdin audio not supported");
#else
		              {
				  if (stdinassgn)
				      dieu("-i: stdin previously assigned");
				  stdinassgn = 1;
			      }
#endif
		              sfread = 1;
		              break;
		    case 'o': FIND("no outfilename")
		              outfilename = s;		/* soundout name */
		              while (*++s);
		              if (strcmp(outfilename,"stdin") == 0)
				  dieu("-o cannot be stdin");
		              if (strcmp(outfilename,"stdout") == 0) {
#ifdef THINK_C
				  dieu("stdout audio not supported");
#else
				  if ((outfd = dup(1)) < 0)    /* redefine stdout */
				      die("too many open files");
				  dup2(2,1);              /* & send 1's to stderr */
#endif
			      }
		              break;
		    case 'b': FIND("no iobufsamps")
		              sscanf(s,"%d",&outbufsamps);  /* defaults in musmon.c */
		              inbufsamps = outbufsamps;
		              while (*++s);
		              break;
		    case 'B': FIND("no hardware bufsamps")
		              sscanf(s,"%d",&oMaxLag);  /* defaults in rtaudio.c */
		              while (*++s);
		              break;
		    case 'A': aiffOut = 1;              /* AIFF output request  */
		              break;
		    case 'h': sfheader = 0;             /* skip sfheader  */
		              break;
		    case 'c': if (outformat) goto outform;
		              outformch = c;
		              outformat = AE_CHAR;	/* 8-bit char soundfile */
		              break;
		    case 'a': if (outformat) goto outform;
		              outformch = c;
		              outformat = AE_ALAW;	/* a-law soundfile */
		              break;
		    case 'u': if (outformat) goto outform;
		              outformch = c;
		              outformat = AE_ULAW;	/* mu-law soundfile */
		              break;
		    case 's': if (outformat) goto outform;
		              outformch = c;
		              outformat = AE_SHORT;	/* short_int soundfile */
		              break;
		    case 'l': if (outformat) goto outform;
		              outformch = c;
		              outformat = AE_LONG;	/* long_int soundfile */
		              break;
		    case 'f': if (outformat) goto outform;
		              outformch = c;
		              outformat = AE_FLOAT;	/* float soundfile */
		              break;
		    case 'v': odebug = 1;   		/* verbose otran  */
		              break;
		    case 'm': FIND("no msglevel")
		              sscanf(s,"%d",&msglevel);
		              while (*++s);
		              break;
		    case 'd': displays = 0;         	/* no func displays */
		              break;
		    case 'g': graphsoff = 1;         	/* don't use graphics */
		              break;
		    case 'S': ScotScore++;
		              break;
		    case 'x': FIND("no xfilename")
		              xfilename = s;  		/* extractfile name */
		              while (*++s);
		              break;
		    case 't': FIND("no tempo value")
		              sscanf(s,"%d",&cmdTempo);  /* use this tempo ..  */
		              while (*++s);
		              if (cmdTempo <= 0) dieu("illegal tempo");
			      Beatmode = 1;          /* on uninterpreted Beats */
		              break;
		    case 'L': FIND("no Linein score device_name")
		              Linename = s;  		/* Linein device name */
		              while (*++s);
		              if (!strcmp(Linename,"stdin")) {
				  if (stdinassgn)
				      dieu("-L: stdin previously assigned");
				  stdinassgn = 1;
			      }
	                      Linein = 1;
		              break;
		    case 'M': FIND("no midi device_name")
		              Midiname = s;  		/* Midi device name */
		              while (*++s);
		              if (!strcmp(Midiname,"stdin")) {
				  if (stdinassgn)
				      dieu("-M: stdin previously assigned");
				  stdinassgn = 1;
				}
	                      Midiin = 1;
		              break;
		    case 'F': FIND("no midifile name")
		              FMidiname = s;  		/* Midifile name */
		              while (*++s);
		              if (!strcmp(FMidiname,"stdin")) {
				  if (stdinassgn)
				      dieu("-F: stdin previously assigned");
				  stdinassgn = 1;
				}
	                      FMidiin = 1;          /***************/
		              break;
		    case 'P': FIND("no pedal threshold")
		              sscanf(s,"%d",&SusPThresh);
		              while (*++s);
		              break;
		    case 'N': ringbell = 1;         	/* notify on completion */
		              break;
		    case 'T': termifend = 1;       /* terminate on midifile end */
		              break;
		    default:  usage();
		    }
	    else {
	        if (orchname == NULL)
		    orchname = --s;
	        else if (scorename == NULL)
		    scorename = --s;
		else dieu("too many arguments");
	    }
	} while (--argc);

	if (Linein || Midiin || FMidiin)
	    RTevents = 1;
	if (RTevents || sfread)
	    ksensing = 1;
	if (!outformat)                         /* if no audioformat yet  */
	    outformat = AE_SHORT;               /*  default to short_ints */
	outsampsiz = getsizformat(outformat);
	informat = outformat;    /* informat defaults; resettable by readinheader */
	insampsiz = outsampsiz;
	if (aiffOut) {
	    if (!sfheader)
	        dieu("can't write AIFF soundfile with no header");
	    if (outformat == AE_ALAW || outformat == AE_ULAW || outformat == AE_FLOAT)
	        dies("AIFF does not support %s encoding", getstrformat(outformat));
	}
	if (orchname == NULL)
	    dieu("no orchestra name");
	else fprintf(stderr,"orchname: %s", orchname);
	if (scorename != NULL)
	    fprintf(stderr,", scorename: %s", scorename);
	if (xfilename != NULL)
	    fprintf(stderr,", xfilename: %s", xfilename);
	fputc('\n', stderr);
#ifdef SYS5
	{
	  static  char  buf[80];
	  if (odebug)	setvbuf(stdout,buf,_IOLBF,80);
	}
#else
#ifndef THINK_C
	if (odebug)	setlinebuf(stdout);
#endif
#endif
	if (scorename == NULL) {
	    if (RTevents) {
	        fprintf(stderr,"realtime performance using dummy numeric scorefile\n");
		goto perf;
	    }
	    else scorename = "score.srt";
	}
	if (ScotScore) {                          /* if score in Scot format  */
	    if (!(scorin = fopen(scorename, "r")))
	        dies("cannot open scorefile %s", scorename);
	    if (!(scorout = fopen("score", "w")))
	        die("cannot open scotout score for writing");
	    fprintf(stderr,"translating Scot score ...\n");
	    scot(scorin, scorout, scorename);      /*    do Scot translation  */
	    fclose(scorin);
	    fclose(scorout);
	    scorename = "score";                   /*    and use this "score" */
	}
	if ((n = strlen(scorename)) > 4            /* if score ?.srt or ?.xtr */
	  && (!strcmp(scorename+n-4,".srt")
	      || !strcmp(scorename+n-4,".xtr"))) {
	    fprintf(stderr,"using previous %s\n",scorename);
	    playscore = sortedscore = scorename;            /*   use that one */
	}
	else {
	    if (!(scorin = fopen(scorename, "r")))          /* else sort it   */
	        dies("cannot open scorefile %s", scorename);
	    if (!(scorout = fopen(sortedscore, "w")))
	        dies("cannot open %s for writing", sortedscore);
	    fprintf(stderr,"sorting score ...\n");
	    scsort(scorin, scorout);
	    fclose(scorin);
	    fclose(scorout);
	}
	if (xfilename != NULL) {                        /* optionally extract */
	    if (!strcmp(scorename,"score.xtr"))
	        dies("cannot extract %s, name conflict",scorename);
	    if (!(xfile = fopen(xfilename, "r")))
	        dies("cannot open extract file %s", xfilename);
	    if (!(scorin = fopen(sortedscore, "r")))
	        dies("cannot reopen %s", sortedscore);
	    if (!(scorout = fopen(xtractedscore, "w")))
	        dies("cannot open %s for writing", xtractedscore);
	    fprintf(stderr,"  ... extracting ...\n");
	    scxtract(scorin, scorout, xfile);
	    fclose(scorin);
	    fclose(scorout);
	    playscore = xtractedscore;
	}	    
	if (!(scfp = fopen(playscore, "r")))
	    dies("cannot reopen %s", playscore);
	fprintf(stderr,"\t... done\n");

perf:	fprintf(stderr,"MIT Csound:\n");
	dispinit();	        /* initialise graphics or character display */
	musmon();               /* play the score using current orchestra   */
	if (ringbell) beep();
	return dispexit();      /* hold or terminate the display output     */
				/* for Mac, dispexit returns 0 to exit immediately */

outform: sprintf(errmsg,"sound output format cannot be both -%c and -%c",
		outformch, c);
	dieu(errmsg);
}

void beep()
{
	printf("%c\tbeep!\n",'\007');
}

void dieu(s)
 char *s;
{
        fprintf(stderr,"Csound Command ERROR:\t%s\n",s);
	usage();
}

static void usage()
{
fprintf(stderr,"Usage:\tcsound [-flags] orchfile scorefile\n");
fprintf(stderr, "Legal flags are:\n");
fprintf(stderr,"-I\tI-time only orch run\n");
fprintf(stderr,"-n\tno sound onto disk\n");
fprintf(stderr,"-i fnam\tsound input filename\n");
fprintf(stderr,"-o fnam\tsound output filename\n");
fprintf(stderr,"-b N\tsample frames (or -kprds) per software sound I/O buffer\n");
fprintf(stderr,"-B N\tsamples per hardware sound I/O buffer\n");
fprintf(stderr,"-A\tcreate an AIFF format output soundfile\n");
fprintf(stderr,"-h\tno header on output soundfile\n");
fprintf(stderr,"-c\t8-bit signed_char sound samples\n");
fprintf(stderr,"-a\talaw sound samples\n");
fprintf(stderr,"-u\tulaw sound samples\n");
fprintf(stderr,"-s\tshort_int sound samples\n");
fprintf(stderr,"-l\tlong_int sound samples\n");
fprintf(stderr,"-f\tfloat sound samples\n");
fprintf(stderr,"-v\tverbose orch translation\n");
fprintf(stderr,"-m N\ttty message level. Sum of: 1=note amps, 2=out-of-range msg, 4=warnings\n");
fprintf(stderr,"-d\tsuppress all displays\n");
fprintf(stderr,"-g\tsuppress graphics, use ascii displays\n");
fprintf(stderr,"-S\tscore is in Scot format\n");
fprintf(stderr,"-x fnam\textract from score.srt using extract file 'fnam'\n");
fprintf(stderr,"-t N\tuse uninterpreted beats of the score, initially at tempo N\n");
fprintf(stderr,"-L dnam\tread Line-oriented realtime score events from device 'dnam'\n");
fprintf(stderr,"-M dnam\tread MIDI realtime events from device 'dnam'\n");
fprintf(stderr,"-F fnam\tread MIDIfile event stream from file 'fnam'\n");
fprintf(stderr,"-P N\tMIDI sustain pedal threshold (0 - 128)\n");
fprintf(stderr,"-N\tnotify (ring the bell) when score or miditrack is done\n");
fprintf(stderr,"-T\tterminate the performance when miditrack is done\n");
fprintf(stderr,"flag defaults: csound -s -otest -b%d -B%d -m7 -P128\n",
	IOBUFSAMPS, IODACSAMPS);
        exit(1);
}
