#include "cs.h"			/*				LINEVENT.C	*/
#ifdef THINK_C
#include <console.h>
#else
#include <fcntl.h>
#endif

#define LBUFSIZ   200
#define LF        '\n'

static char *Linebuf, *Linep, *Linebufend;
static int  Linefd = 0;
#ifdef THINK_C
static FILE *Linecons;
#endif

typedef struct levtblk {
    struct levtblk *nxtblk;
    struct levtblk *nxtact;
    long      inuse, oncounter;
    EVTBLK    evtblk;
} LEVTBLK;

static LEVTBLK  *Firstblk;
static LEVTBLK  *Firstact;
EVTBLK *Linevtblk;
extern long kcounter;

void RTLineset()       /* set up Linebuf & ready the input files */
{                      /*     callable once from main.c         */
extern char *Linename;

        Firstblk = (LEVTBLK *) mcalloc((long)sizeof(LEVTBLK));
	Firstact = NULL;
	Linebuf = mcalloc((long)LBUFSIZ);
	Linebufend = Linebuf + LBUFSIZ;
	Linep = Linebuf;
	if (strcmp(Linename,"stdin") == 0) {
#ifdef THINK_C
	    console_options.top += 10;
	    console_options.left += 10;
	    console_options.title = "\pRT Line_events";
	    console_options.nrows = 10;
	    console_options.ncols = 50;
	    Linecons = fopenc();
	    cshow(Linecons);
#else
	    if (fcntl(Linefd, F_SETFL, fcntl(Linefd, F_GETFL, 0) | O_NDELAY) < 0)
	        die("-L stdin fcntl failed");
#endif
	}
	else if ((Linefd = open(Linename, O_RDONLY | O_NDELAY, 0)) < 0)
	    dies("cannot open %s", Linename);
}

void RTclose()
{
#ifdef THINK_C
    if (Linecons != NULL) fclose(Linecons);
#else
    if (Linefd) close(Linefd);
#endif
}

static int containsLF(cp,endp)    /* does this string segment contain LF ? */
 register char *cp, *endp;
{
    do { if (*cp++ == LF)  return(1); }
    while (cp < endp);
    return(0);
}

static LEVTBLK *getblk()   /* get a blk from the LEVTBLK pool, or alloc a new one */
{
    register LEVTBLK *curp = Firstblk, *nxtp;

    while (curp->inuse) {
        if ((nxtp = curp->nxtblk) == NULL) {
	    nxtp = (LEVTBLK *) mcalloc((long)sizeof(LEVTBLK));
	    curp->nxtblk = nxtp;
	}
	curp = nxtp;
    }
    return(curp);
}

static void Linsert(curp)    /* insert a blk into the time-ordered linevent queue */
  register LEVTBLK *curp;
{
    register LEVTBLK *nxtp = Firstact, *prvp = NULL;

    while (nxtp != NULL && nxtp->inuse && nxtp->oncounter <= curp->oncounter) {
        prvp = nxtp;
        nxtp = nxtp->nxtact;
    }
    if (prvp == NULL)
        Firstact = curp;
    else prvp->nxtact = curp;
    curp->nxtact = nxtp;
}

int sensLine()   /* accumlate RT Linein buffer, & place completed events in EVTBLK */
{                /* does more syntax checking than rdscor, since not preprocessed  */
    register int c;
    register char *cp;
    LEVTBLK  *Curblk;
    EVTBLK   *e;
    int      n, pcnt;
    float    *fp, *prvfp;
    char     *Linend;
static EVTBLK *prve = NULL;
static char prvop = ' ';
static int prvpcnt = 0;
static float prvp1 = 0.;
static float prvp2 = 0.;

#ifdef THINK_C
    if ((n = fread((void *)Linep, (size_t)1, (size_t)(Linebufend-Linep), Linecons)) > 0
#else
    if ((n = read(Linefd, Linep, Linebufend-Linep)) > 0
#endif
      || Linep > Linebuf) {
/*      printf("sensLine %d CHARS\n",n);  */
	Linend = Linep + n;
	if ((c = *(Linend - 1)) == LF || containsLF(Linep,Linend)) {
	    cp = Linebuf;
	    Curblk = getblk();                  /* get a blk from the levtblk pool */
	    e = &Curblk->evtblk;
	    while ((c = *cp++) == ' ' || c == '\t')    /* skip initial white space */
	        ;
	    if (c == LF) goto Timchk;                  /* if null line, bugout     */
	    switch(c) {                                /* look for legal opcode    */
	    case 'i':
	    case 'f': e->opcod = c;
	              break;
	    default:  fprintf(stderr,"unknown opcode %c\n");
	              goto Lerr;
	    }                                         /* for params that follow:   */
	    for (fp = &e->p[1], pcnt = 0; c != LF && pcnt<PMAX; pcnt++) {
	        register long val = 0, scale = 1;
		while ((c = *cp++) == ' ' || c == '\t')    /*  skip white space */
		    ;
		if (c == LF) break;
		if (c == '"') {                       /* if find character string  */
		    register char *sstrp;
		    if (pcnt != 4) {
		        fprintf(stderr,"misplaced string\n");  /*  ( must be p5 )  */
			goto Lerr;
		    }
		    if ((sstrp = e->strarg) == NULL)
		        e->strarg = sstrp = mcalloc((long)SSTRSIZ);
		    while ((c = *cp++) != '"') {
		        if (c == LF) {
			    fprintf(stderr,"unmatched quotes\n");
			    cp--;
			    goto Lerr;
			}
			*sstrp++ = c;                   /*   sav in private strbuf */
		    }
		    *sstrp = '\0';
		    *fp++ = sstrcod;                    /*   & store coded float   */
		    continue;
		}
		if (!(c>='0' && c<='9' || c=='+' || c=='-' || c=='.'))
		    goto Lerr;
		if (c == '.'                               /*  if lone dot,       */
		  && ((n = *cp)==' ' || n=='\t' || n==LF)) {
		    if (e->opcod != 'i' || prvop != 'i' || pcnt >= prvpcnt) {
		        fprintf(stderr,"dot carry has no reference\n");
			goto Lerr;
		    }
		    if (e != prve) {                       /*        pfld carry   */
		        if (pcnt == 1)
			    *fp = prvp2;
		        else *fp = prve->p[pcnt+1];
		    }
		    fp++;         
		    continue;
		}
		if (c == '-') {scale = -1; c = *cp++;}      /*  valid float: eval  */
		if (c == '+' || c == '0')  c = *cp++;
		while (c >= '0' && c <= '9') {
		    val *= 10;
		    val += c - '0';
		    c = *cp++;
		}
		if (c == ' ' || c == '\t' || c == LF)       /* simple decimal val? */
		    goto pfstor;                            /*   quick store       */
		if (c == '.')
		    c = *cp++;
		while (c >= '0' && c <= '9') {              /* else read full float */
		    val *= 10;
		    val += c - '0';
		    scale *= 10;
		    c = *cp++;
		}
		if (c != ' ' && c != '\t' && c != LF)  /*     chk delimiter legal   */
		    goto Lerr;
	pfstor:	*fp++ = (float) val/scale;             /*     & stor pval in EVTBLK */
	    }
	    if (e->opcod == 'i' && prvop == 'i')       /* do carries for instr data */
	        if (!pcnt || pcnt < prvpcnt && e->p[1] == prvp1) {
		    int pcntsav = pcnt;
		    if (e != prve)
		        for (prvfp = &prve->p[pcnt+1]; pcnt < prvpcnt; pcnt++)
			    *fp++ = *prvfp++;
		    else pcnt =  prvpcnt;
		    if (pcntsav < 2)
		        e->p[2] = prvp2;
		}
	    if (pcnt < 3) {
	        fprintf(stderr,"too few pfields\n");   /* check sufficient pfields  */
	        goto Lerr;
	    }
	    e->pcnt = pcnt;                            /*   &  record pfld count    */
	    prve = e;
	    prvop = e->opcod;                          /* preserv the carry sensors */
	    prvpcnt = pcnt;
	    prvp1 = e->p[1];
	    prvp2 = e->p[2];
	    if (pcnt == PMAX && c != LF) {
	        fprintf(stderr,"too many pfields\n");
	        while (*cp++ != LF)                    /* flush any excess data     */
		    ;
	    }
	    Linep = Linebuf;
	    while (cp < Linend)                        /* copy remaining data to    */
		*Linep++ = *cp++;                      /*     beginning of Linebuf  */
	    if (e->p[2] < 0.) {
	        fprintf(stderr,"-L with negative p2 illegal\n");
		goto Lerr;
	    }
	    e->p2orig = e->p[2];
	    e->p3orig = e->p[3];
	    Curblk->inuse = 1;
	    Curblk->oncounter = kcounter + e->p[2] * ekr;
	    Linsert(Curblk);
	}
	else Linep += n;           /* else just accum the chars */
    }

Timchk:
    if (Firstact != NULL
      && Firstact->oncounter <= kcounter) {   /* if an event is due now,       */
	Linevtblk = &Firstact->evtblk;
	Firstact->inuse = 0;                  /*   mark its space available    */
	Firstact = Firstact->nxtact;
	return(1);                            /*   & report Line-type RTevent  */
    }
    else return(0);                           /* else nothing due yet          */

Lerr:
    n = cp - Linebuf - 1;                     /* error position */
    while (*cp++ != LF);                      /* go on to LF    */
    *(cp-1) = '\0';                           /*  & insert NULL */
    fprintf(stderr,"illegal RT scoreline:\n%s\n", Linebuf);
    while (n--)
        fputc(' ',stderr);
    fprintf(stderr,"^\n");                    /* mark the error */
    Linep = Linebuf;
    while (cp < Linend)
        *Linep++ = *cp++;                     /* mov rem data forward */
    return(0);
}

