.TH YAWN 3Y "June 6th, 1994"
.nh
.SH NAME
YAWN \- Yet Another Widget Neatener
.SH DESCRIPTION
.LP
.B YAWN
is a library of useful functions for X widget management.
.LP
It is designed to work together with X11 Release 5, the X Toolkit and
the Athena Widget Set to supply an elegant streamlined look-and-feel to
accompany the unpolicied functionality provided by Xt and Xaw.  In
this
.B YAWN
has something in common with OSF Motif, although
.B YAWN
is a much simpler convenience tool, is entirely interoperable with
Xt/Xaw code, has a different look-and-feel, and is free.
.SH USAGE
.LP
.SS Initialisation and Cleaning Up
.LP
.B YAWN
provides two simple initialisation and exit functions:
.LP
.nf
void \fBYInitialise\fP\^(\^\fIwidget\fP, \fIhelpCallback\fP\^)
.br
       Widget \fIwidget\fP;
       YHelpCallback \fIhelpCallback\fP;
.fi
.IP
This initialises the
.B YAWN
library.  \fIwidget\fP may be any
existing managed composite widget (such as your top-level shell
widget).  \fIhelpCallback\fP is a function to be called when
the Help button on a
.B YAWN
dialogue box is pressed: the argument passed into the callback
will be the tag string that was passed in to the creation function for
that box (see below).  \fIhelpCallback\fP may be NULL, in which case
no such callback
will be called.
.IP
.B YHelpCallback
is defined as:
.nf
        typedef void  (* YHelpCallback)(String);
.fi
.IP
You may call \fBYInitialise\fP more than once with different arguments
if you wish.
.LP
.nf
void \fBYCleanUp\fP\^(\^void\^)
.fi
.IP
Deallocates any storage allocated by
.B YAWN
in the current session
(except menu records).  Programs making use of
.B YAWN
should be sure
to call \fBYCleanUp\fP before exiting.
.IP
Do not use any other
.B YAWN
functions after having called \fBYCleanUp\fP.
You may invoke \fBYCleanUp\fP even if \fBYInitialise\fP has not
been called.
.SS Shading
.LP
Most of the widgets created under
\fBYAWN\fP's jurisdiction are given
shaded backgrounds.  There are various possible shades, and which
shade is used for a given widget will determine the colour (on a
colour display) or
stipple (on a monochrome display) used for that widget's background.
On a colour display, the colours corresponding to the shades are
retrieved from X resources; when
.B YAWN
is initialised, it creates a
set of ``mock'' Athena Label widgets as children of a widget named
\fIyawn\fP, and draws the colour resources from those.  Shade values
care specified in the library interface as a type \fBYShade\fP.  This can
take on the following values:
.TP 15
.B NoShade
The widget's background will not be shaded.  On
a colour display, it will take on the value retrieved from the 
\fIyawn.noShade.background\fP resource.
.TP 15
.B LightShade
The widget's background will be shaded in a
light grey stipple on mono displays, and coloured in the value
of \fIyawn.lightShade.background\fP on colour ones.
.TP 15
.B MediumShade
The widget's background will be shaded in an
even grey stipple on mono displays, and coloured in the value
of \fIyawn.mediumShade.background\fP on colour ones.
.TP 15
.B SurroundShade
The widget's background will not be shaded.
On a colour display, it will take on the value retrieved from the
\fIyawn.surroundShade.background\fP resource.  This is usually used
for the surrounding boxes of action buttons and labels.
.LP
In all cases, the foreground and background colours to be used on a
monochrome display are taken from the values of
\fIyawn.mono.foreground\fP and \fIyawn.mono.background\fP.
.SS Widget Creation
.LP
.B YAWN
supports a number of ``dedicated'' widgets; these are normal Athena
widgets which, when created through the
.B YAWN
toolkit, are given a standard look through the use of resources and
surrounding widgets.  These can all be manipulated subsequently either
with or without the use of \fBYAWN\fP.  In addition, functions are
provided to make creation of common standard Athena widgets easier and
quicker.
.LP
.nf
Widget \fBYCreateWidget\fP\^(\^\fIname\fP, \fIclass\fP, \fIparent\fP\^)
       String \fIname\fP;
       WidgetClass \fIclass\fP;
       Widget \fIparent\fP;
.fi
.IP
This creates and returns a new managed Xt/Athena widget with the given
\fIname\fP, \fIclass\fP and \fIparent\fP and a NULL resource argument
list.
.IP
.B YCreateWidget
is implemented as a macro.
.LP
.nf
Widget \fBYCreateUnmanagedWidget\fP\^(\^\fIname\fP, \fIclass\fP, \fIparent\fP, \fIshade\fP\^)
       String \fIname\fP;
       WidgetClass \fIclass\fP;
       Widget \fIparent\fP;
       YShade \fIshade\fP;
.fi
.IP
This creates and returns a new unmanaged Xt/Athena widget with the given
\fIname\fP, \fIclass\fP and \fIparent\fP and a NULL resource argument
list.
.LP
.nf
Widget \fBYCreateShadedWidget\fP\^(\^\fIname\fP, \fIclass\fP, \fIparent\fP, \fIshade\fP\^)
       String \fIname\fP;
       WidgetClass \fIclass\fP;
       Widget \fIparent\fP;
       YShade \fIshade\fP;
.fi
.IP
This creates and returns a new managed widget with the given
\fIname\fP, \fIclass\fP and \fIparent\fP and a NULL resource argument
list, and sets its 
\fIbackgroundPixmap\fP resource according to \fIshade\fP.  The
.B YShade
type is described above, under \fBShading\fP.
.LP
.nf
Widget \fBYCreateLabel\fP\^(\^\fIname\fP, \fIparent\fP\^)
Widget \fBYCreateCommand\fP\^(\^\fIname\fP, \fIparent\fP\^)
Widget \fBYCreateRepeater\fP\^(\^\fIname\fP, \fIparent\fP\^)
Widget \fBYCreateMenuButton\fP\^(\^\fIname\fP, \fIparent\fP\^)
       String \fIname\fP;
       Widget \fIparent\fP;
.fi
.IP
These functions each create and return a new managed Athena Label,
Command,
Repeater or MenuButton widget, child of a new Box widget, in turn
child of the passed \fIparent\fP widget.  Both widgets (the requested
widget and its surrounding box) will be called \fIname\fP.
.IP
\fBYCreateCommand\fP and \fBYCreateMenuButton\fP also set the
leftBitmap resource of the command or menu button widget to display an
appropriate form of arrow.
.IP
.B YCreateLabel
is implemented as a macro.
.LP
.nf
Widget \fBYCreateArrowButton\fP\^(\^\fIname\fP, \fIparent\fP, \fIdirection\fP\^)
       String \fIname\fP;
       Widget \fIparent\fP;
       YArrowDirection \fIdirection\fP;
.fi
.IP
Creates and returns a new managed surrounded Athena Repeater widget.
The
widget will display a single arrow pointing in the direction given by
\fIdirection\fP.
.IP
The YArrowDirection type is defined as an enum of the elements
\fBYArrowLeft\fP, \fBYArrowRight\fP, \fBYArrowUp\fP and
\fBYArrowDown\fP.
.LP
.nf
Widget \fBYCreateToggle\fP\^(\^\fIname\fP, \fIparent\fP, \fIcallback\fP\^)
       String \fIname\fP;
       Widget \fIparent\fP;
       XtCallbackProc \fIcallback\fP;
.fi
.IP
Creates and returns a new managed Toggle widget.  This is not
the Athena Toggle widget, but an Athena Command widget with a callback
set; as such, it cannot be used as part of a radio group.  The Toggle
widget will begin in an unset state, and when it is clicked, its state
will toggle and the function \fIcallback\fP will be called.  The 
\fIclient_data\fP argument passed to \fIcallback\fP will be a Boolean
indicator of the Toggle's newly entered state.
.LP
.nf
Widget \fBYCreateSurroundedWidget\fP\^(\^\fIname\fP, \fIclass\fP, \fIparent\fP, \fIshade1\fP, \fIshade2\fP\^)
       String \fIname\fP;
       WidgetClass \fIclass\fP;
       Widget \fIparent\fP;
       YShade \fIshade1\fP, \fIshade2\fP;
.fi
.IP
Creates and returns a widget, surrounded (as in \fBYCreateLabel\fP) by a
Box widget.  The widget may be of any class.  The 
\fIbackgroundPixmap\fP or background colour of the Box will be set
according to
\fIshade1\fP, and that of its child will be set according to \fIshade2\fP.
.IP
.B YCreateSurroundedWidget
is implemented as a macro.
.SS Resource Value Manipulation
.LP
.B YAWN
includes two macros to assist with getting and setting X toolkit
resources, plus a function
to manipulate the state of the
.B YAWN
Toggle widget (see \fBYCreateToggle\fP above).
.LP
.nf
void \fBYSetValue\fP\^(\^\fIwidget\fP, \fIresource\fP, \fIvalue\fP\^)
       Widget \fIwidget\fP;
       String \fIresource\fP;
       XtArgVal \fIvalue\fP;
.fi
.IP
Sets the \fIresource\fP resource on widget \fIwidget\fP to 
\fIvalue\fP.  It's lazier than using \fBXtSetArg\fP/\fBXtSetValues\fP,
especially if you only want to set one resource value.
.IP
.B YSetValue
is implemented as a macro.
.LP
.nf
void \fBYGetValue\fP\^(\^\fIwidget\fP, \fIresource\fP, \fIvalue\fP\^)
       Widget \fIwidget\fP;
       String \fIresource\fP;
       XtArgVal \fIvalue\fP;
.fi
.IP
Gets the value of the \fIresource\fP resource on widget \fIwidget\fP,
and stores it in the space pointed to by \fIvalue\fP.  This is
equivalent to using \fBXtSetArg\fP/\fBXtGetValues\fP for one resource
value.
.IP
.B YGetValue
is implemented as a macro.
.LP
.nf
void \fBYSetToggleValue\fP\^(\^\fItoggle\fP, \fIvalue\fP\^)
Boolean \fBYGetToggleValue\fP\^(\^\fItoggle\fP\^)
       Widget \fItoggle\fP;
       Boolean \fIvalue\fP;
.fi
.IP
Set and get the state of a Toggle (of the kind returned by 
\fBYCreateToggle\fP), respectively.  The Toggle's visible window and
internal records will be updated to reflect any change in state.
.SS Message Output
.LP
\fBYAWN\fP provides a limited capability for output of text
intertwingled with font changing information.  This is similar to a
restricted form of X Compound Text, where only one font per line of
text may be specified.  This facility is most likely to be useful in
displaying small amounts of static text, such as in an information or
``About'' box.
.LP
.nf
void \fBYMessageInitialise\fP\^(\^\fIbitmap\fP, \fIbasefont\fP\^)
       Pixmap \fIbitmap\fP;
       String \fIbasefont\fP;
.fi
.IP
This function initialises the
.B YAWN
message boxes.  It declares that
the pixmap \fIbitmap\fP should be displayed in the top-left of any
message box (or, if it is NULL, that no pixmap should be
displayed), and that the font \fIbasefont\fP should be used for
displaying non-italic non-bold message texts (or, if NULL, that
an ugly default should be chosen instead).  Italic and bold fonts will
be derived automatically, provided \fIbasefont\fP is a valid XLFD
descriptor and suitable fonts are available.  If you require oblique
(as opposed to italic) or demibold (as opposed to bold) fonts, you
should declare the oblique/demibold version as the base font or it
will not be found.
.IP
You may call \fBYMessageInitialise\fP as many times as you like.
.LP
.nf
void \fBYMessage\fP\^(\^\fIparent\fP, \fIname\fP, \fIlabel\fP, \fItext\fP, \fInumber\fP\^)
       Widget \fIparent\fP;
       String \fIname\fP, \fIlabel\fP;
       YMessageString *\fItext\fP;
       int \fInumber\fP;
.fi
.IP
Pops up an asynchronous, non-grabbing textual display window called
\fIname\fP as a child of \fIparent\fP.  If a non-NULL bitmap was
supplied in the call to \fBYMessageInitialise\fP, it will be displayed
in the top left of the window.
.IP
If \fItext\fP is non-NULL, its contents will be displayed
centrally in the window.  These should be an array of \fInumber\fP
\fBYMessageString\fP structures, which are defined as -
.IP
.nf
        typedef struct _YMessageString {
               String \fItext\fP;
               Boolean \fIbold\fP;
               Boolean \fIitalic\fP;
        } \fBYMessageString\fP;
.fi
.IP
Here the \fItext\fP field describes a line of text, which will be
drawn centrally on a line on its own, either normally, or in bold,
italic or bold-italic face.  The latter are controlled by the 
\fIbold\fP and \fIitalic\fP fields.  To simplify initialising these
structures, the special symbols \fBYMessageNormal\fP, 
\fBYMessageBold\fP, \fBYMessageItalic\fP and \fBYMessageBoldItalic\fP are
provided: they expand into
.IP
.nf
            False,False
             True,False
            False,True
             True,True
.fi
.IP
respectively, corresponding to the necessary field settings in the
structure.
.IP
The message window will also contain a confirmation button, which will
be labelled \fIlabel\fP.  The \fIlabel\fP argument may not be 
NULL.
.SS Querying the User
.LP
.B YAWN
provides two mechanisms for synchronous user querying.  The
Xt/Athena toolkit and widgets offer no standard query synchronising
mechanism: a query requires the use of a callback function to record
the user's answer.  The
.B YAWN
query functions block the calling program completely until the answer
has been obtained, giving the result as the return value from the
querying function.  Although less flexible than the X toolkit
approach, this is much simpler and frequently very useful.
.LP
.nf
int \fBYQuery\fP\^(\^\^)
.fi
.IP
This function pops up a query dialogue box to ask the user a question,
and returns the user's answer.
.IP
This is a variable argument-list function, written using the
``varargs'' macro set, which effectively takes arguments as follows:
.IP
.nf
int \fBYQuery\fP\^(\^\fIparent\fP, \fImessage\fP, \fIbuttons\fP, \fIdefault\fP,
           \fIcancel\fP, \fIlabel\fP0, ..., \fIhelpTag\fP\^)
       Widget \fIparent\fP;
       String \fImessage\fP;
       Cardinal \fIn\fP;
       Cardinal \fIdefault\fP;
       Cardinal \fIcancel\fP;
       String \fIlabel\fP0 \^(\^...\^);
       String \fIhelpTag\fP;
.fi
.IP
\fIparent\fP is the widget to make the query box a child of;
\fImessage\fP is the text to display in the query label. The box will
have \fIn\fP buttons, labelled
\fIlabel\fP0 ... \fIlabel\fPn.  When the box is popped up, the X
pointer will be warped to the button numbered \fIdefault\fP, unless
\fIdefault\fP is -1.
.IP
If the \fIhelpTag\fP argument is non-NULL, the box will
have a ``Help'' button, pressing which will invoke the
\fIhelpCallback\fP that was passed to the \fBYInitialise\fP function,
passing it the \fIhelpTag\fP.
.IP
If \fImessage\fP is NULL, there will be no message label in the
query box.
.IP
\fBYQuery\fP returns an integer indicating which of the buttons the
user
pressed, counting upwards from 0 as the leftmost.  If for some reason
it exited without a button's having been pressed, \fBYQuery\fP returns
-1.
.LP
.nf
String \fBYGetUserInput\fP\^(\^\fIparent\fP, \fImessage\fP, \fIdefault\fP, \fIorientation\fP, \fIhelpTag\fP\^)
       Widget \fIparent\fP;
       String \fImessage\fP;
       String \fIdefault\fP;
       YOrientation \fIorientation\fP;
       String \fIhelpTag\fP;
.fi
.IP
Pops up a dialogue box to ask the user a question and obtain an answer
in the form of a string.  The box contains a message label, displaying
\fImessage\fP (unless \fImessage\fP is NULL, in which case no
label will appear), a text input box, with default input string 
\fIdefault\fP (or with no default string if \fIdefault\fP is NULL),
and Apply and Cancel buttons.  If \fIhelpTag\fP is non-NULL, there
will also be a Help button; see \fBYQuery\fP above for details.
.IP
If \fIorientation\fP is \fBYOrientHorizontal\fP, the box will be laid
out horizontally, with the text input area to the right of the message
area; if it is \fBYOrientVertical\fP, the arrangement will have the
text area below the message area.  Vertical orientation often looks
good if a wide input is needed, and horizontal if a narrower one is
needed.
.IP
The function behaves synchronously: it blocks until the user has
pressed either the Apply or Cancel button on the dialogue box.  It
returns the entered string, or NULL if the user pressed the
Cancel button.
.SS Creating Modal Menus
.LP
.B YAWN
supports the use of modal menus.  These consist of Athena simple
menus, with some functions to support modal behaviour.  As
.B YAWN
provides a reasonably rich interface to the menu functionality, it
should not be necessary to refer to the underlying
Athena menus, and programmers should avoid doing so.  There is
no guarantee that
.B YAWN
will always construct its menus in the same way.
.LP
.nf
YMenuId \fBYCreateMenu\fP\^(\^\fImenuButton\fP, \fIname\fP, \fInumber\fP, \fIelements\fP\^)
       Widget \fImenuButton\fP;
       String \fIname\fP;
       int \fInumber\fP;
       YMenuElement *\fIelements\fP;
.fi
.IP
Creates an Athena simple menu and returns an
identifier for it.  The arguments declare the button (of class 
\fImenuButtonWidgetClass\fP, such as that returned by 
\fBYCreateMenuButton\fP) which should call up the menu, the menu name (used
for widget identification, but not displayed on the menu itself), the
number of entries on the menu, and an array of \fBYMenuElement\fP
structures defining the contents of the menu entries.  This structure
contains the following fields:
.IP
.nf
            String \fIlabel\fP;
.fi
.IP
The label for the menu entry.  If this is NULL, a dividing line
will be drawn at this point instead of an entry.  The special symbol
\fBYMenuDivider\fP is provided, which expands to a whole line of 
\fINULL\fP entries for a particularly convenient interface (see the example
below).
.IP
.nf
            unsigned long \fIinsensitive_mode_mask\fP;
.fi
.IP
A mask indicating which menu modes should cause this menu to be greyed
out.  How you manage your menu modes is up to you: to \fBYAWN\fP, they
are just bitmasks, and a menu item will be greyed out if its 
\fIinsensitive_mode_mask\fP has one or more bits in common with the
current mode mask.  The latter is maintained by \fBYAWN\fP; it is
initialised to 0L, and can be changed by calling \fBYEnterMenuMode\fP
and \fBYLeaveMenuMode\fP.
.IP
.nf
            XtCallbackProc \fIcallback\fP;
.fi
.IP
A function to be called when this entry is selected by the user.  It
will receive as its \fIclient_data\fP argument a pointer to this 
\fBYMenuElement\fP structure.
.IP
.nf
            Widget \fIwidget\fP;
.fi
.IP
The widget or gadget to be used to draw the menu entry.  Applications
should normally initialise this to NULL, and it will be filled
in by \fBYCreateMenu\fP.  If this field is non-NULL, it will
\fInot\fP be overwritten.  You may or may not find a use for this.
.IP
As an example, given an array declared -
.IP
.nf
    YMenuElement fileMenu[] = {
      { "Load",         NullMask, FileMenuLoad, NULL, },
      { "Save", NoFileLoadedMask, FileMenuSave, NULL, },
      YMenuDivider,
      { "Exit",         NullMask, FileMenuExit, NULL, },
    \fP;
.fi
.IP
where \fINullMask\fP is presumably 0L -
.B YAWN
does not define
this - and \fINoFileLoadedMask\fP a value with a bit set somewhere,
then a call such as
.IP
.nf
fileMenuId = \fBYCreateMenu\fP\^(\^fileMenuButton, "File Menu",
                         \fBXtNumber\fP\^(\^fileMenu\^), fileMenu\^);
.fi
.IP
would serve to create the menu, instantiate its gadgets and callbacks,
and return an identifier for it.  Subsequently, the ``Save'' menu
option would only be available when the file menu was not in the
``NoFileLoadedMode'' mode (see the section below).
.SS Manipulating Modal Menus
.LP
Several functions not normally part of the Athena simple menu
interface are provided to allow control of the
.B YAWN
menu modes:
.LP
.nf
void \fBYEnterMenuMode\fP\^(\^\fImenu\fP, \fImode\fP\^)
void \fBYLeaveMenuMode\fP\^(\^\fImenu\fP, \fImode\fP\^)
       YMenuId \fImenu\fP;
       unsigned long \fImode\fP;
.fi
.IP
Causes menu \fImenu\fP to enter or leave mode \fImode\fP.  In effect
this sets or clears the bits
marked by \fImode\fP in the current mode mask maintained by \fBYAWN\fP
for menu \fimenu\fP,
and greys out or restores any affected menu entries in the menu
identified by \fImenu\fP.
.LP
.nf
Boolean \fBYQueryMenuMode\fP\^(\^\fImenu\fP, \fImode\fP\^)
       YMenuId \fImenu\fP;
       unsigned long \fImode\fP;
.fi
.IP
Determines whether a given menu is in a given mode.  If one or more of
the bits corresponding to \fImode\fP are set in the menu's current
mode mask, the function returns True; otherwise False.
.LP
.nf
Widget \fBYGetMenuButtonFromMenu\fP\^(\^\fImenu\fP\^)
       YMenuId \fImenu\fP;
.fi
.IP
Returns the menu button widget associated with the given menu id.
.LP
.nf
void \fBYDestroyMenu\fP\^(\^\fImenu\fP\^)
       YMenuId \fImenu\fP;
.fi
.IP
Destroys the given menu and frees any space allocated during the 
\fBYCreateMenu\fP call that created it.  This also resets the
\fIwidget\fP field in each element of the menu's description record
array to NULL.
.SS File Boxes
.LP
.B YAWN
contains a set of powerful file-box facilities.  These may be used
whenever a program using
.B YAWN
requires to obtain the name of a file from the user for reading or
writing.  The file-box functions provide an extremely simple
programmer interface, allowing file names or identifiers to be
obtained with a single function call.
.LP
.nf
void \fBYFileInitialise\fP\^(\^\fIdirectory\fP, \fIprefix\fP, \fIquery\fP, \fIbackup\fP,
                     \fIreadLabel\fP, \fIwriteLabel\fP, \fIappendLabel\fP\^)
       String \fIdirectory\fP;
       Boolean \fIquery\fP, \fIbackup\fP;
       String \fIreadLabel\fP, \fIwriteLabel\fP, \fIappendLabel\fP;
.fi
.IP
This function initialises the
.B YAWN
file management functions.  It
must be called before any of the other file functions.
.IP
A call to \fBYFileInitialise\fP declares:
.IP
- The default start-directory (\fIdirectory\fP) for file
selection box listings;
.IP
- Whether file selection boxes should check with the user before
possibly overwriting files (\fIquery\fP, True if they should
check);
.IP
- Whether backups should be made of files to be opened for
writing (\fIbackup\fP, True if they should - note that making
backups of files which are not subsequently opened owing to any kind
of file error is a destructive
operation);
.IP
- Labels for the Apply buttons on read, write and append file
selection boxes (which all default to ``Apply''; you may well wish to
set them to ``Load'', ``Save'' and ``Append'' or similar).
.IP
You may call \fBYFileInitialise\fP as many times as you like.
.LP
.nf
String \fBYFileGetReadFilename\fP\^(\^\fIparent\fP, \fIhelpTag\fP\^)
       Widget \fIparent\fP;
       String \fIhelpTag\fP;
.fi
.IP
Pops up a synchronous file selection box to obtain a filename for
reading.  The box will be a child of \fIparent\fP.  The file will not
be opened, but its name will be returned, or NULL if the user
cancelled the operation.  If \fIhelpTag\fP is non-NULL, the box will
contain a Help button which, when pressed, will invoke the
\fIhelpCallback\fP passed in to \fBYInitialise\fP, passing in
\fIhelpTag\fP as its argument.
.LP
.nf
String \fBYFileGetWriteFilename\fP\^(\^\fIparent\fP, \fIhelpTag\fP\^)
String \fBYFileGetAppendFilename\fP\^(\^\fIparent\fP, \fIhelpTag\fP\^)
       Widget \fIparent\fP;
       String \fIhelpTag\fP;
.fi
.IP
These pop up synchronous file selection boxes to obtain filenames for
writing or appending.  They differ from the \fBYFileGetReadFilename\fP
box in that their filename fields are editable.  The file will not be
opened, but its name will be returned, or NULL if the user
cancelled the operation.  The \fIhelpTag\fP argument is as for 
\fBYFileGetReadFilename\fP.
.LP
.nf
FILE *\fBYFileGetReadFile\fP\^(\^\fIparent\fP, \fIhelpTag\fP\^)
FILE *\fBYFileGetWriteFile\fP\^(\^\fIparent\fP, \fIhelpTag\fP\^)
FILE *\fBYFileGetAppendFile\fP\^(\^\fIparent\fP, \fIhelpTag\fP\^)
       Widget \fIparent\fP;
       String \fIhelpTag\fP;
.fi
.IP
Pop up synchronous file selection boxes for reading, writing and
appending, respectively.  These functions differ from 
\fBYFileGetReadFilename\fP, \fBYFileGetWriteFilename\fP and 
\fBYFileGetAppendFilename\fP in that they open the files and return file
pointers referring to the open files.  (The files can be closed with a
call to the standard library function \fBfclose\fP.)  They return NULL
if the user cancelled
the operation.  The helpTag argument is as for 
\fBYFileGetReadFilename\fP.
.LP
.nf
String \fBYFileGetLastFilename\fP\^(\^\fIclip\fP\^)
       Boolean \fIclip\fP;
.fi
.IP
Returns a shared string naming the last file obtained for reading,
writing or appending by \fBYFileGetReadFile\fP, 
\fBYFileGetReadFilename\fP and their friends.  If the last call to any of
these functions yielded a Cancel operation, \fBYFileGetLastFilename\fP
will return NULL.  If \fIclip\fP is True, 
\fBYFileGetLastFilename\fP will return only the final element of the
file's path name (the actual name of the file); otherwise it will
return the whole path name.
.SS Miscellaneous Convenience Functions
.LP
.B YAWN
includes a few miscellaneous functions which may be of use in keeping
the programmer's task of maintaining a clean look-and-feel as simple
as possible.
.LP
.nf
Pixmap \fBYCreatePixmapFromData\fP\^(\^\fIdata\fP, \fIwidth\fP, \fIheight\fP, \fIshade\fP\^)
       String \fIdata\fP;
       unsigned int \fIwidth\fP, \fIheight\fP;
       YShade \fIshade\fP;
.fi
.IP
Creates and returns an X pixmap of the same depth as the current
display's default, of width \fIwidth\fP and height \fIheight\fP,
containing data \fIdata\fP.  The foreground and background colours of
the pixmap will be chosen to fit in well with those of a
\fBYAWN\fP-created widget of shade \fIshade\fP.  This function behaves
otherwise like \fBXCreatePixmapFromBitmapData\fP.
.LP
.nf
GC \fBYCreateGC\fP\^(\^\fImask\fP, \fIvalues\fP, \fIshade\fP, \fIclear\fP\^)
       unsigned long \fImask\fP;
       XGCValues *\fIvalues\fP;
       YShade \fIshade\fP;
       Boolean \fIclear\fP;
.fi
.IP
Creates and returns a new X graphic context, using the values in 
\fIvalues\fP selected by \fImask\fP, augmented by suitable foreground
and background colours for use with a widget of shade \fIshade\fP.  If
\fIclear\fP is True, the foreground and background colours will
be the same, and will both be that which would otherwise have been
used for the background only.
.LP
.nf
XPoint \fBYPushPointerPosition\fP\^(\^void\^)
XPoint \fBYPopPointerPosition\fP\^(\^void\^)
.fi
.IP
Record and restore the position of the X pointer on the screen.  These
may be useful if you wish to warp the pointer to a default button or
list item, and then warp it back again.
.IP
These functions deliberately do not use a stack mechanism: they only
record the last pointer position.  If you push the position several
times, the first call to \fBYPopPointerPosition\fP will restore the
last pushed position,
and any subsequent \fBYPopPointerPosition\fP calls will be ignored.
This is in order to avoid
restoring the pointer to places that the user had completely forgotten
it was
ever at in the first place.  It also means that push and pop calls
need not be in pairs; there need not be a matching pop for each push,
or push for each pop.
.IP
Both functions return an \fBXPoint\fP structure recording the current
position of the pointer over the root window.  If the pointer query
failed and no such position is available, the structure will contain
zeroes.  This should happen only rarely, if ever.
.LP
.nf
XPoint \fBYPlaceAndPopup\fP\^(\^\fIshell\fP, \fIgrab\fP\^)
       Widget \fIshell\fP;
       XtGrabKind \fIgrab\fP;
.fi
.IP
Realizes and pops up the popup shell widget \fIshell\fP with the
Xt grab kind \fIgrab\fP.
The shell will be positioned at a reasonable point on the screen (not
left of or above its parent, nor off the edges of the screen, unless
it is impossible to manage otherwise).  \fBYPlaceAndPopup\fP also calls
\fBYPushPointerPosition\fP, and returns the position of the X pointer.
.SH FILES
.B YAWN
requires no special files.  However, for the best results, some care
should be taken about the settings in the host program's X resource
defaults file.  One possible example set, with some rather dubious
colour resources, is shown below.
.LP
.nf
       *borderWidth:                      1
       *highlightThickness:               1
       *SimpleMenu*lineWidth:             1
       *SimpleMenu*SmeLine.height:        2

       *yawn.mono.foreground:             black
       *yawn.mono.background:             white

       *yawn.noShade.foreground:          black
       *yawn.noShade.background:          peachpuff
       *yawn.lightShade.foreground:       black
       *yawn.lightShade.background:       maroon4
       *yawn.mediumShade.foreground:      gold2
       *yawn.mediumShade.background:      midnightblue
       *yawn.surroundShade.foreground:    black
       *yawn.surroundShade.background:    #e0b090
.fi
.LP
Care should also be taken with font settings, as the default font
for many X displays (\fIfixed\fP) is an inordinately ugly one.  A fair
resource setting to start with might be:
.LP
.nf
       *font:   -*-lucida-bold-r-*-*-14-*-75-*-*-*-*-*
.fi
.LP
.SH AUTHOR
.LP
Chris Cannam, ma0cc@ss1.bath.ac.uk at the University of Bath.
.LP
