/*
---------------------------------------------------------------------------------------------
			MIDI Sequencer - Final Year Project, A.J. Green
---------------------------------------------------------------------------------------------

File Name:	PianoRoll.h

Description:	Function prototypes and typedefs for Piano Roll track display windows.

Author:		AJG

History:

Update	Date		Programmer	Comments
======	====		==========	========
001	15/03/94	AJG		File Created.

--------------------------------------------------------------------------------------------
*/


#ifndef _PIANO_ROLL_H_
#define _PIANO_ROLL_H_

typedef struct
{
	ListElement	Base;
	int		TrackNum;
	Widget		Shell;
	Widget 		Pane;
	Widget		MenuBar;
	Widget		Form;
	Widget		ViewPort;
	Widget		PianoRollLabel;
	Widget		Scrollbar;
	Widget		TrackMenuButton;
	Widget		EditMenuButton;
	Widget		EventMenuButton;
	Widget		CounterDisplay;
	YMenuElement   *TrackMenu;
	YMenuId		TrackMenuId;
	YMenuElement   *EditMenu;
	YMenuId		EditMenuId;
	YMenuElement   *EventMenu;
	YMenuId		EventMenuId;
	Pixmap		LabelPixmap;
	Dimension	PianoRollWidth;
	Dimension	PianoRollHeight;
	GC		Clear;
	GC		DrawForce;
	GC		DrawXor;
	GC		LightGrey;
	GC		Grey;
	int		BarNumber;
	long		LastEvtTime;
	Boolean		Dragging;
	int		DragStartCoord;
	int		DragEndCoord;
	EventList	SelectStartEvt;
	EventList	SelectEndEvt;
}
PRWindowListElt, *PRWindowList;

#define PIANO_ROLL_STAVE_SPACING	9
#define PIANO_ROLL_STAVE_HEIGHT	       37

#define PIANO_ROLL_CLEF_WIDTH	       24
#define PIANO_ROLL_CLEF_HEIGHT         53
#define PIANO_ROLL_SHARP_WIDTH		6
#define PIANO_ROLL_SHARP_HEIGHT	       14

#define PIANO_ROLL_DEFAULT_BAR_WIDTH  192

#define PIANO_ROLL_OCTAVE_YSIZE	      (3.5 * PIANO_ROLL_STAVE_SPACING)

#define PIANO_ROLL_MIDDLE_C_YPOS      ((float)(PIANO_ROLL_TOP_STAVE_OFFSET + \
				       PIANO_ROLL_OCTAVE_YSIZE + \
				       PIANO_ROLL_STAVE_SPACING))

#define PIANO_ROLL_TOP_STAVE_OFFSET   ((int)(4 * (PIANO_ROLL_OCTAVE_YSIZE)))
#define PIANO_ROLL_PIXMAP_HEIGHT      ((int)(11 * (PIANO_ROLL_OCTAVE_YSIZE)))

void Midi_PianoRollWindowCreate(int TrackNum);
void Midi_UpdatePianoRollWindow(int TrackNum);
void Midi_PianoRollDeleteAllWindows(void);
void Midi_RemovePianoRollWindow(int TrackNum);



#endif
