/*
---------------------------------------------------------------------------------------------
			MIDI Sequencer - Final Year Project, A.J. Green
---------------------------------------------------------------------------------------------

File Name:	MidiSetupDlgs.c

Description: 	Code to display and run dialogues from the MIDI menu on
		the sequencer main window.

Author:		AJG

History:

Update	Date		Programmer	Comments
======	====		==========	========
001	28/04/94	AJG		File Created.

-------------------------------------------------------------------------------------------- 
*/

#include <MidiXInclude.h>
#include <MidiFile.h>
#include "Globals.h"
#include <MidiErrorHandler.h>
#include <Debug.h>
#include "EventDlgs.h"
#include <ctype.h>
#include "Main.h"


extern char    *MidiPortName;
extern Boolean  MidiPortSync;
extern int	MidiEventBufferSize;
extern Boolean  MidiMaintainTempo;
extern int	MidiEventBufferTimer;

Boolean SetupSync;
Boolean MaintainTempo;

Widget SetupDlg;
Widget SetupPortNameField;
Widget SetupEventBufSizeField;
Widget SetupBufferTimeField;

void Midi_SetupDlg(void);

void Midi_SetupCB(Widget w, XtPointer a, XtPointer b)
{
BEGIN("Midi_SetupCB");

	Midi_SetupDlg();

END;
}


void Midi_SetupCancelCB(Widget w, XtPointer a, XtPointer b)
{
BEGIN("Midi_SetupCancelCB");

	XtDestroyWidget(SetupDlg);

END;
}



void Midi_SetupSyncCB(Widget w, XtPointer a, XtPointer b)
{
BEGIN("Midi_SetupSyncCB");

	SetupSync = !SetupSync;

END;
}



void Midi_SetupMaintainTempoCB(Widget w, XtPointer a, XtPointer b)
{
BEGIN("Midi_SetupMaintainTempoCB");

	MaintainTempo = !MaintainTempo;

END;
}


void Midi_SetupOKCB(Widget w, XtPointer a, XtPointer b)
{
char *EventBufStr;
char *PortNameStr;
int   EventBufSize;

BEGIN("Midi_SetupOKCB");


	YGetValue(SetupPortNameField, XtNstring, &PortNameStr);

	if (strcmp(PortNameStr, MidiPortName))
	{
		XtFree(MidiPortName);
		MidiPortName = strcpy((char *)malloc(strlen(PortNameStr) + 1),
				      PortNameStr);
	}

	YGetValue(SetupEventBufSizeField, XtNstring, &EventBufStr);

	EventBufSize = atoi(EventBufStr);

	if (EventBufSize < 1) 
	{
		YQuery(SetupDlg, "Invalid Event Buffer Size", 1, 0, 0, "Continue", NULL);
		END;
	}

	MidiEventBufferSize = EventBufSize;
	MidiPortSync        = SetupSync;
	MidiMaintainTempo   = MaintainTempo;

	XtDestroyWidget(SetupDlg);

END;
}

	
void Midi_SetupDlg(void)
{
Widget SetupPane;
Widget SetupTopBox;
Widget SetupLabel;

Widget SetupForm;
Widget SetupPortNameLabel;
Widget SetupPortSyncButton;
Widget SetupMaintainTempoButton;
Widget SetupEventBufSizeLabel;
Widget SetupBufferTimeLabel;

Widget SetupBottomBox;
Widget SetupOK;
Widget SetupCancel;
Widget SetupHelp;

XPoint op;
char   TextBuffer[32];

BEGIN("Midi_SetupDlg");

	SetupDlg = XtCreatePopupShell("Midi Setup", transientShellWidgetClass, 
					  topLevel, NULL, 0);

	SetupPane = YCreateWidget("Midi Setup Pane", panedWidgetClass, 
				      SetupDlg);

	SetupTopBox = YCreateShadedWidget("Midi Setup Title Box", boxWidgetClass,
					      SetupPane, MediumShade);

	SetupLabel = YCreateLabel("Configure MIDI Setup", SetupTopBox);

	
	SetupForm = YCreateShadedWidget("Midi Setup Form", formWidgetClass, SetupPane, LightShade);

	SetupPortNameLabel = YCreateLabel("Midi Port:", SetupForm);

	SetupPortNameField = YCreateSurroundedWidget("Midi Port", asciiTextWidgetClass,
						     SetupForm, NoShade, NoShade);

	SetupPortSyncButton = YCreateToggle("Synchronous Mode", SetupForm, Midi_SetupSyncCB);

	SetupMaintainTempoButton = YCreateToggle("Maintain Tempo", SetupForm, Midi_SetupMaintainTempoCB);

	SetupEventBufSizeLabel = YCreateLabel("Event Buffer Size:", SetupForm);

	SetupEventBufSizeField = YCreateSurroundedWidget("Event Buffer Size", asciiTextWidgetClass,
						     SetupForm, NoShade, NoShade);


	SetupBufferTimeLabel = YCreateLabel("Input Buffer Timer:", SetupForm);

	SetupBufferTimeField = YCreateSurroundedWidget("Input Buffer Time", asciiTextWidgetClass,
							SetupForm, NoShade, NoShade);

	SetupBottomBox = YCreateShadedWidget("Midi Setup Button Box", boxWidgetClass,
						 SetupPane, MediumShade);

	SetupOK     = YCreateCommand("OK", SetupBottomBox);
	SetupCancel = YCreateCommand("Cancel", SetupBottomBox);
	
	if (appData.interlockWindow)
	{
		SetupHelp   = YCreateCommand("Help", SetupBottomBox);
		XtAddCallback(SetupHelp,   XtNcallback, Midi_HelpCallback, "Midi - MIDI Setup");
	}


	/******************/
	/* Add callbacks. */
	/******************/

	XtAddCallback(SetupOK, XtNcallback, Midi_SetupOKCB, NULL);
	XtAddCallback(SetupCancel, XtNcallback, Midi_SetupCancelCB, NULL);

	/************************************/
	/* Format the form widget contents. */
	/************************************/

	YSetValue(XtParent(SetupMaintainTempoButton), XtNfromHoriz, XtParent(SetupPortSyncButton));
	YSetValue(XtParent(SetupPortNameField), XtNfromHoriz, XtParent(SetupEventBufSizeLabel));
	YSetValue(XtParent(SetupPortNameField), XtNfromVert, XtParent(SetupMaintainTempoButton));
	YSetValue(XtParent(SetupPortNameLabel), XtNfromVert, XtParent(SetupMaintainTempoButton));
	YSetValue(XtParent(SetupEventBufSizeLabel), XtNfromVert, XtParent(SetupPortNameLabel));
	YSetValue(XtParent(SetupEventBufSizeField), XtNfromHoriz, XtParent(SetupEventBufSizeLabel));
	YSetValue(XtParent(SetupEventBufSizeField), XtNfromVert, XtParent(SetupPortNameLabel));
	YSetValue(XtParent(SetupBufferTimeLabel), XtNfromVert, XtParent(SetupEventBufSizeField));
	YSetValue(XtParent(SetupBufferTimeField), XtNfromVert, XtParent(SetupEventBufSizeField));
	YSetValue(XtParent(SetupBufferTimeField), XtNfromHoriz, XtParent(SetupBufferTimeLabel));
	
	YSetValue(SetupEventBufSizeField, XtNeditType, XawtextEdit);
	YSetValue(SetupPortNameField, XtNeditType, XawtextEdit);
	YSetValue(SetupBufferTimeField, XtNeditType, XawtextEdit);

	YSetValue(SetupPortNameField, XtNstring, MidiPortName);

	sprintf(TextBuffer, "%d", MidiEventBufferSize);
	YSetValue(SetupEventBufSizeField, XtNstring, TextBuffer);

	sprintf(TextBuffer, "%d", MidiEventBufferTimer);
	YSetValue(SetupBufferTimeField, XtNstring, TextBuffer);

	SetupSync = MidiPortSync;
	MaintainTempo = MidiMaintainTempo;

	YSetToggleValue(SetupPortSyncButton, SetupSync);
	YSetToggleValue(SetupMaintainTempoButton, MaintainTempo);

	op = YPlacePopupAndWarp(SetupDlg, XtGrabNonexclusive,
				SetupOK, SetupCancel);

	YAssertDialogueActions(SetupDlg, SetupOK, SetupCancel, SetupHelp);
END;
}

