/*
---------------------------------------------------------------------------------------------
			MIDI Sequencer - Final Year Project, A.J. Green
---------------------------------------------------------------------------------------------

File Name:	EventListWindow.h

Description:	Type definitions and function prototypes for event-list sub-window functions.

Author:		AJG

History:

Update	Date		Programmer	Comments
======	====		==========	========
001	18/02/94	AJG		File Created.

--------------------------------------------------------------------------------------------
*/

#ifndef _EVENTLISTWINDOW_H_
#define _EVENTLISTWINDOW_H_

#include "MidiFile.h"
#include "MidiTrack.h"
#include <X11/Intrinsic.h>

/******************************************/
/* Event List window selection structure. */
/******************************************/

typedef struct
{
	long		StartChar;
	long		EndChar;
	EventList	StartEvt;
	EventList	EndEvt;
}
ELWindowSelection;


/****************************************************/
/* Event list window private information structure. */
/****************************************************/

typedef struct
{
	ListElement		Base;
	int			TrackNum;
	Widget			Shell;
	Widget			Pane;
	Widget			MenuBar;
	Widget			Form;
	Widget			ViewPort;
	Widget			ListBox;
	Widget			TrackMenuButton;
	Widget			EditMenuButton;
	Widget			EventMenuButton;
	int			SelectedEvent;
	char	               *EventList;
	YMenuElement           *TrackMenu;
	YMenuId			TrackMenuId;
	YMenuElement           *EditMenu;
	YMenuId			EditMenuId;
	YMenuElement   	       *EventMenu;
	YMenuId			EventMenuId;
	ELWindowSelection	Selection;
}
ELWindowListElt, *ELWindowList;



void Midi_EventListWindowCreate(int TrackNum);
void Midi_UpdateEventListWindow(int TrackNum);
void Midi_EventListDeleteAllWindows(void);
void Midi_EventListCalculateSelection(ELWindowList CurrWindow);
void Midi_RemoveEventListWindow(int TrackNum);

/* Added by cc 95, no idea if it should be here but ajg certainly */
/* calls it elsewhere and I can't be arsed to work it out now     */

void Midi_SetupEventList(ELWindowList);

#endif
