
#ifndef _DOUBLY_LINKED_LISTS_
#define _DOUBLY_LINKED_LISTS_


/*
                 Doubly-linked lists, Chris Cannam 1994
                 ======================================

   The ListElement is supposed to  be an overlapping generic structure
   on  top of your own  specialised  "List-of-X" type.  Define them as
   in the example--

         typedef struct _IntListElement {
	   ListElement generic;
	   int         item;
	 } IntListElement, *IntList;

   You  should then define a   constructor  function (or macro)  which
   takes an int and returns an IntList--

         IntList NewIntList(int x)
	 {
	   IntList list;

	   list = (IntList)NewList(sizeof(IntListElement));
	   list->item = x;

	   return list;
	 }

   You're then ready to go.  These generic  List functions can be used
   by casting your  specialised list pointers to the  List type in the
   call, and  casting  returned values  back again.  This  header file
   includes  macros  which  obviate  the  need  to cast the arguments,
   though you'll still need to cast the return values back.  You might
   consider building some other specialist  functions, such as `cons',
   but that's up to you.

   Note that all the List functions assume that a List is defined by a
   pointer to any element  in it.  You  can as freely pass  Last(X) to
   any of  these functions  as X or  First(X),  and except in  special
   cases where a particular element is called for (such as Remove), it
   won't make a  blind bit  of  difference.   Similarly, there is   no
   reason why a returned  list pointer should  point to the start of a
   list.
*/


#include <stdio.h>
#include <stdlib.h>


typedef struct _ListElement {
  struct _ListElement *next;
  struct _ListElement *prev;
} ListElement, *List;


extern List    LIST_NewList     (size_t s);
extern List    LIST_First       (List a);
extern List    LIST_Last        (List a);
extern int     LIST_Length      (const List a);
extern void    LIST_DestroyList (List a);    /* traverses in forwards order */
extern List    LIST_Nconc       (List a, List b);
extern List    LIST_Insert      (List a, List b);
				             /* inserts a before element b  */
extern List    LIST_Remove      (List a);
				             /* removes elt a, returns next */
                                             /*  (prev if there is no next) */
extern List    LIST_Reverse     (List a);
extern List    LIST_Split       (List a);
				             /* breaks list in two before a */
				             /* and returns first half (you */
				             /* should already have second, */
				             /* 'cos it was the passed arg) */


/* Macros to move list pointers both ways -- */
/* both return lists which are essentially   */
/* the same as the passed one, but described */
/* differently                               */

#define Prev(x)   (((List)(x))->prev)
#define Next(x)   (((List)(x))->next)


/* Macros to do some of the casting for you. */
/* Obviously if you use these you'll have to */
/* be particularly careful that your types   */
/* are actually the right ones               */

#define NewList(x)     LIST_NewList((size_t)(x))
#define First(x)       LIST_First((List)(x))
#define Last(x)        LIST_Last((List)(x))
#define Length(x)      LIST_Length((List)(x))
#define DestroyList(x) LIST_DestroyList((List)(x))
#define Nconc(x,y)     LIST_Nconc((List)(x),(List)(y))
#define Insert(x,y)    LIST_Insert((List)(x),(List)(y))
#define Remove(x)      LIST_Remove((List)(x))
#define Reverse(x)     LIST_Reverse((List)(x))
#define Split(x)       LIST_Split((List)(x))


#endif /* _DOUBLY_LINKED_LISTS_ */

