
/*
   Musical Notation Editor, application widget creation stuff

   Chris Cannam, 1994
*/

#include "General.h"
#include "GC.h"
#include "Classes.h"
#include "Visuals.h"
#include "Menu.h"
#include "Yawn.h"
#include "ILClient.h"
#include "Stave.h"
#include "Palette.h"

#include <X11/Xaw/Form.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Repeater.h>
#include <X11/Xaw/Scrollbar.h>

#include <sys/types.h>
#include <sys/stat.h>

#include "rewind.xbm"
#include "back.xbm"
#include "forward.xbm"
#include "ffwd.xbm"

static Widget helpButton;

Pixmap  leftMap = 0;
Pixmap rightMap = 0;

Widget paletteShell  = NULL;
Widget musicViewport = NULL;
Widget pageButton    = NULL;


YMessageString aboutText[] = {
  { "The Rosegarden Editor was written by",  YMessageNormal,     },
  { "Chris Cannam",                          YMessageBold,       },
  { "as part of a final-year project at",    YMessageNormal,     },
  { "the University of Bath, UK.",           YMessageNormal,     },
  { " ",                                     YMessageNormal,     },
  { "IPC and MIDI code was supplied by",     YMessageItalic,     },
  { "Andy Green.",                           YMessageBoldItalic, },
};


/* 

     Interface layout
     ================         ,----- menu buttons
                              v
   ,-----------------------------------. ,-----------.
   | [file] [edit] [group] [help]      | | [palette] |  <-- palette menu
   +-----------------------------------+ +-----------+           button
   | ,-+-----------------------------. | | ,---+---. |
   | |/|                             | | | |   |   | |
   | |/|                             | | | +---+---+ |
   | |/|                             | | | |   |   | |  <-- palette buttons
   | |/|                             | | | +---+---+ |
   | |/| <-- vertical scrollbar      | | | |   |   | |
   | |/|                             | | | +---+---+ |
   | |/|                             | | | |   |   | |
   | |/|                             | | | +---+---+ |
   | |/|                             | | | |   |   | |
   | |/|                             | | | `---+---' |
   | |/|                             | | | ,---+---. |
   | `-+-----------------------------' | | +---+---+ |  <-- palette modifier
   | [  <<  ] [  <  ] [  >  ] [  >>  ] | | `---+---' |           buttons
   `-----------------------------------' `-----------'
                        ^
                        `----- scrolling buttons
*/



void HelpFinished(IL_ReturnCode rtn)
{
  Begin("HelpFinished");
  XtSetSensitive(helpButton, True);
  End;
}

void HelpButton(Widget w, XtPointer a, XtPointer b)
{
  Begin("HelpButton");
  IL_RequestService("Help", HelpFinished, "Editor", 8);
  XtSetSensitive(helpButton, False);
  End;
}

void yHelpCallback(String helpTag)
{
  Begin("yHelpCallback");

  IL_RequestService("Help", HelpFinished, helpTag, strlen(helpTag) + 1);

  End;
}

void yHelpCallbackCallback(Widget w, XtPointer a, XtPointer b)
{
  String helpTag = (String)a;

  Begin("yHelpCallbackCallback");

  IL_RequestService("Help", HelpFinished, helpTag, strlen(helpTag) + 1);

  End;
}


void AboutButton(Widget w, XtPointer a, XtPointer b)
{
  Begin("AboutButton");
  YMessage(XtParent(w), "About Rosegarden",
	    "Enough!", aboutText, XtNumber(aboutText));
  End;
}



void CreateApplicationWidgets(void)
{
  Widget    outerPane;
  Widget    topBox;
  Widget    bottomBox;
  Widget    aboutButton;
  Widget    fileButton;
  Widget    editButton;
  Widget    groupButton;
  Widget    textButton;
  Widget    barButton;
  Widget    staveButton;
  Widget    toolsButton;
  Widget    markButton;
  Widget    rewindButton;
  Widget    backButton;
  Widget    forwardButton;
  Widget    ffwdButton;
  Widget    palettePane;
  Widget    paletteTopBox;
  Widget    paletteButton;
  Widget    paletteForm;
  Widget    paletteModForm;
  Widget    paletteSpace;
  Widget    scrollbar;
  Window    w;
  char      paletteName[50];
  Pixmap    pixmap;
  Dimension h;
  struct stat statbuf;

  Begin("CreateApplicationWidgets");

  if (appData.interlockWindow) YInitialise(topLevel, yHelpCallback);
  else                         YInitialise(topLevel, NULL);

  YFileInitialise(appData.musicDirectory,
		  True, True, "Load", "Save", "Append");
  InitialiseVisuals();
  CreateGCs();

  YMessageInitialise(roseMap, appData.aboutTextFont);
  w = RootWindowOfScreen(XtScreen(topLevel));

  sprintf(paletteName, "%s Editor Palette", ProgramName);
  paletteShell =
    XtAppCreateShell(paletteName, ProgramName,
		     applicationShellWidgetClass, display,  NULL, 0);

  outerPane     = YCreateShadedWidget
    ("Editor",        panedWidgetClass,  topLevel,     NoShade);
  topBox        = YCreateShadedWidget
    ("Top Box",         boxWidgetClass, outerPane, MediumShade);
  musicViewport = YCreateShadedWidget
    ("Music View", viewportWidgetClass, outerPane,     NoShade);
  scrollbar     = YCreateShadedWidget
    ("Scrollbar", scrollbarWidgetClass, outerPane,     NoShade);
  bottomBox     = YCreateShadedWidget
    ("Bottom Box",      boxWidgetClass, outerPane, MediumShade);
  
  aboutButton   = YCreateSurroundedWidget
    ("About", commandWidgetClass, topBox, SurroundShade, NoShade);

     fileButton = YCreateMenuButton ("File",  topBox);
     editButton = YCreateMenuButton ("Edit",  topBox);
    staveButton = YCreateMenuButton ("Stave", topBox);
    groupButton = YCreateMenuButton ("Group", topBox);
      barButton = YCreateMenuButton ("Bar",   topBox);
     textButton = YCreateMenuButton ("Words", topBox);
     markButton = YCreateMenuButton ("Marks", topBox);
    toolsButton = YCreateMenuButton ("Tools", topBox);
     helpButton = YCreateCommand    ("Help",  topBox);

  if (!appData.interlockWindow) XtSetSensitive(helpButton, False);

   rewindButton = YCreateSurroundedWidget("Fast Rewind",  repeaterWidgetClass,
					   bottomBox, SurroundShade, NoShade);
     backButton = YCreateSurroundedWidget("Scroll Left",  repeaterWidgetClass,
					   bottomBox, SurroundShade, NoShade);
     pageButton = YCreateSurroundedWidget("Bar 0000",      commandWidgetClass,
					   bottomBox, SurroundShade, NoShade);
  forwardButton = YCreateSurroundedWidget("Scroll Right", repeaterWidgetClass,
					   bottomBox, SurroundShade, NoShade);
     ffwdButton = YCreateSurroundedWidget("Fast Forward", repeaterWidgetClass,
					   bottomBox, SurroundShade, NoShade);

  palettePane    = YCreateShadedWidget
    ("Editor Palette", panedWidgetClass, paletteShell,    NoShade);
  paletteTopBox  = YCreateShadedWidget
    ("Palette Top Box",  boxWidgetClass, palettePane, MediumShade);
  paletteModForm = YCreateShadedWidget
    ("Palette Mods",    formWidgetClass, palettePane,     NoShade);
  paletteForm    = YCreateShadedWidget
    ("Palette Form",    formWidgetClass, palettePane,  LightShade);
  paletteSpace   = YCreateShadedWidget
    ("Palette Space",    boxWidgetClass, palettePane, MediumShade);

  paletteButton = YCreateMenuButton("Palette", paletteTopBox);

  YSetValue(  aboutButton,     XtNbitmap,     roseMap );
  YSetValue(     topLevel, XtNiconPixmap,     roseMap );
  YSetValue( paletteShell, XtNiconPixmap,     roseMap );
  YSetValue(     topLevel,   XtNiconMask, roseMaskMap );
  YSetValue( paletteShell,   XtNiconMask, roseMaskMap );

  YMenuInitialise(XtParent(aboutButton), appData.acceleratorTable);

  InstallPaletteMenu(paletteButton);
  InstallPaletteMods(paletteModForm);
  InstallPalettes(paletteForm, paletteSpace);

  StaveInitialise(musicViewport);

  XtSetMappedWhenManaged(paletteShell, False);
  XtRealizeWidget(paletteShell);

  YGetValue(XtParent(paletteButton), XtNheight, &h);

  XtUnrealizeWidget(paletteShell);
  XtSetMappedWhenManaged(paletteShell, True);

  YSetValue(scrollbar, XtNorientation, XtorientHorizontal);
  YSetValue(scrollbar, XtNmin, 14);
  YSetValue(scrollbar, XtNmax, 14);

  YSetValue(paletteTopBox, XtNmin, roseHeight + 17);
  YSetValue(paletteTopBox, XtNmax, roseHeight + 17);
  YSetValue(paletteSpace,  XtNmax, h + 10);
  YSetValue(paletteSpace,  XtNmin, h + 10);
  XtRealizeWidget(paletteShell);

  pixmap =
    XCreateBitmapFromData(display,w,rewind_bits,rewind_width,rewind_height);
  YSetValue(  rewindButton, XtNbitmap, pixmap );

  rightMap =
    XCreateBitmapFromData(display,w,forward_bits,forward_width,forward_height);
  YSetValue( forwardButton, XtNbitmap, rightMap );

  leftMap = XCreateBitmapFromData(display,w,back_bits,back_width,back_height);
  YSetValue(    backButton, XtNbitmap, leftMap );

  pixmap = XCreateBitmapFromData(display,w,ffwd_bits,ffwd_width,ffwd_height);
  YSetValue(    ffwdButton, XtNbitmap, pixmap );

  XtAddCallback(helpButton,    XtNcallback,               HelpButton, NULL);
  XtAddCallback(aboutButton,   XtNcallback,              AboutButton, NULL);
  XtAddCallback(scrollbar,     XtNscrollProc, StaveScrollbarCallback, NULL);
  XtAddCallback(scrollbar,     XtNjumpProc,        StaveJumpCallback, NULL);

  XtAddCallback(rewindButton,  XtNcallback,
		StaveLeftCallback,  (XtPointer)True);
  XtAddCallback(backButton,    XtNcallback,
		StaveLeftCallback,  (XtPointer)False);
  XtAddCallback(pageButton,    XtNcallback,
		StavePageCallback,  NULL);
  XtAddCallback(forwardButton, XtNcallback,
		StaveRightCallback, (XtPointer)False);
  XtAddCallback(ffwdButton,    XtNcallback,
		StaveRightCallback, (XtPointer)True);

   InstallFileMenu(  fileButton);
   InstallEditMenu(  editButton);
  InstallStaveMenu( staveButton);
  InstallGroupMenu( groupButton);
   InstallTextMenu(  textButton);
   InstallMarkMenu(  markButton);
    InstallBarMenu(   barButton);
  InstallToolsMenu( toolsButton);

  XtInstallAccelerators(musicViewport,  XtParent(aboutButton));
  XtInstallAccelerators(topBox,         XtParent(aboutButton));
  XtInstallAccelerators(bottomBox,      XtParent(aboutButton));
  XtInstallAccelerators(paletteTopBox,  XtParent(aboutButton));
  XtInstallAccelerators(paletteModForm, XtParent(aboutButton));
  XtInstallAccelerators(paletteForm,    XtParent(aboutButton));
  XtInstallAccelerators(paletteSpace,   XtParent(aboutButton));

  YSetValue(topBox,        XtNmin, roseHeight + 17);
  YSetValue(topBox,        XtNmax, roseHeight + 17);
  YSetValue(bottomBox,     XtNmax, h + 10);
  YSetValue(bottomBox,     XtNmin, h + 10);

  YSetValue(musicViewport, XtNallowVert,   True);
  YSetValue(musicViewport, XtNallowHoriz, False);
  YSetValue(musicViewport, XtNforceBars,   True);

  XtRealizeWidget(topLevel);

  StaveInitialiseScrollbar(scrollbar);
  YSetScrollbarPixmap(scrollbar);
  YSetViewportScrollbarPixmaps(musicViewport);

  stave = NULL;
  YSetValue(pageButton, XtNlabel, "Bar 0");
  XtSetSensitive(pageButton, False);

  EnterMenuMode(NoAreaSweptMode         |
		SequencerNotRunningMode |
		FileNotLoadedMode       |
		CursorNotPlacedMode);

  if (!(appData.midi2texName && (stat(appData.midi2texName, &statbuf) == 0)))
    EnterMenuMode(Midi2TeXUnavailableMode);

  End;
}

