
#ifndef _MUSIC_STAVEPRIVATE_
#define _MUSIC_STAVEPRIVATE_

#include <X11/Intrinsic.h>
#include "Classes.h"
#include "StaveCursor.h"

extern Widget  staveLabel;

/*
   What is a major stave?
   ======================

   A major stave, represented by the data type MajorStaveRec, is
   a description of an arrangement of musical notation in several
   staves, divided into bars, on a visible rectangular area.

   The major stave is equipped with the ability to highlight and
   edit parts of the musical text.
*/


typedef struct _StaveEltListElement {
  ListElement    typeless;
  Bar          **bars;		   /* array of pointers, not 2d array */
  BarTag        *starts;
  BarTag        *ends;
  Dimension     *widths;     /* widths[i] is width of bar at *bars[i] */
} StaveEltListElement, *StaveEltList;


/* Sweeping should be possible only from one chord (call it Item) to  */
/* another.  There should be no horizontal-band discrimination within */
/* a sweep, only rectangles the full height of the stave.  Functions  */
/* may be provided on the menu to handle dividing them if need be.    */

typedef struct _StaveSweep {
  Boolean        swept;		       /* have we got an area at all? */
  int            stave;
  int            first_bar;
  PointerRec     from;
  PointerRec     to;
  XPoint         a;
  XPoint         b;
} StaveSweep;


typedef struct _StaveFormattingRec {
  int            next;	       /* first unformatted bar on that stave */
  Boolean        tied;
  TimeSignature *time;
  Clef          *clef;
  Key           *key;
  ItemList       items;
} StaveFormattingRec;


typedef struct _MajorStaveRec {

  int                 staves;                           /* number of staves */
  int                 bars;	                        /* Length(bar_list) */
  int                 display_start;          /* first bar number displayed */
  int                 display_number; /* width of display, no of bars shown */

  String             *names;
  int                *name_lengths;
  ItemList           *music;

  StaveEltList        bar_list;
  StaveFormattingRec *formats;	/* one record per stave (different keys &c) */

  StaveSweep          sweep;

  Boolean             visible;

} MajorStaveRec;


extern StaveEltList NewStaveEltList(Bar **, BarTag *, BarTag *, Dimension *);
extern StaveSweep   NewSweep(void);
extern void         StaveForceUpdate(void);


#define StaveTopHeight(x) ((x)*(StaveUpperGap+StaveHeight+StaveLowerGap) \
                           +StaveUpperGap)

#define StaveTotalHeight(x) (StaveTopHeight((x)->staves)- \
			     StaveUpperGap+StaveLowerGap)


#endif /* _MUSIC_STAVEPRIVATE_ */

