
/* Musical Notation Editor for X, Chris Cannam 1994 */
/* Functions to handle actions from Stave menu options */


#include "General.h"
#include "Widgets.h"
#include "Menu.h"
#include "Stave.h"
#include "StaveEdit.h"
#include "StavePrivate.h"
#include "ItemList.h"
#include "Yawn.h"


void StaveMenuRenameStave(Widget w, XtPointer a, XtPointer b)
{
  MajorStaveRec  *mstave  = (MajorStaveRec *)stave;
  int             staveNo = mstave->sweep.stave;
  String          name;

  Begin("StaveMenuRenameStave");

  if (!stave || !mstave->sweep.swept ||
      mstave->sweep.from.left != mstave->sweep.to.left) {
    XBell(display, 70);
    End;
  }

  if (!(name = YGetUserInput
	(topLevel, "Name:", NULL, YOrientHorizontal, "Stave - Rename Staff")))
    End;

  FileMenuMarkChanged(stave, True);
  StaveRenameStave(stave, staveNo, name);
  End;
}



void StaveMenuNewStave(Widget w, XtPointer a, XtPointer b)
{
  int            i;
  int            off;
  int            posn;
  MajorStaveRec *mstave = (MajorStaveRec *)stave;
  int            staves = mstave->staves;
  MajorStave     newStave;
  ItemList      *newMusic;
  String        *newNames;
  ItemList       list;
  int            num   = 4;
  int            denom = 4;

  Begin("StaveMenuNewStave");

  if (mstave->sweep.swept) {

    posn = YQuery(topLevel, "Where should the new staff go?", 4, 3, 3,
		  "First", "Last", "After current staff", "Cancel",
		  "Stave - New Staff");

    if (posn == 3) End;

  } else {

    posn = YQuery(topLevel, "Where should the new staff go?", 3, 2, 2,
		  "First", "Last", "Cancel", "Stave - New Staff");

    if (posn == 2) End;
  }

  off = 0;
  if (posn == 0) off = 1;

  for (list = mstave->music[0]; list; list = (ItemList)Next(list)) {
    if (list->item->generic.object_class == TimeSignatureClass) {
      num   = ((TimeSignature *)list->item)->timesig.numerator;
      denom = ((TimeSignature *)list->item)->timesig.denominator;
      break;
    }
  }

  newMusic = (ItemList *)XtMalloc((mstave->staves + 1) * sizeof(ItemList));
  newNames = (String   *)XtMalloc((mstave->staves + 1) * sizeof(String));

  for (i = 0; i < mstave->staves; ++i) {

    if (posn == 2 && off == 0 && i > mstave->sweep.stave) off = 1;

    newMusic[i + off] = mstave->music[i];
    newNames[i + off] = XtNewString(mstave->names[i]);
  }

  list = NewItemList((Item *)NewClef(NULL, TrebleClef));
  list = (ItemList)First
    (Nconc(list, NewItemList((Item *)NewTimeSignature(NULL, num, denom))));

  switch (posn) {

  case 0: newMusic[i = 0]                       = list; break;
  case 1: newMusic[i = mstave->staves]          = list; break;
  case 2: newMusic[i = mstave->sweep.stave + 1] = list; break;
  }

  newNames[i] = XtNewString("unnamed");
  newStave = NewStave(mstave->staves + 1, newMusic);

  XtFree((void *)mstave->music);
  StaveDestroy(stave, False);
  memcpy((void *)mstave, (void *)newStave, sizeof(MajorStaveRec));

  for (i = 0; i < mstave->staves; ++i) {
    StaveRenameStave(stave, i, newNames[i]);
    XtFree(newNames[i]);
  }

  XtFree((void *)newNames);

  staveMoved = True;
  StaveRefresh(stave, -1);
  FileMenuMarkChanged(stave, True);

  End;
}



void StaveMenuDeleteStave(Widget w, XtPointer a, XtPointer b)
{
  int            i;
  int            off;
  MajorStaveRec *mstave = (MajorStaveRec *)stave;
  ItemList      *newMusic;
  String        *newNames;
  MajorStave     newStave;
  int            staves = mstave->staves;

  Begin("StaveMenuDeleteStave");

  if (!mstave->sweep.swept) {
    XBell(display, 70);
    End;
  }

  if (mstave->staves <= 1) {
    IssueMenuComplaint("You can't delete the only remaining staff.");
    End;
  }

  if (YQuery(topLevel, "Are you sure you want to delete this staff?", 2, 1, 1,
	     "Continue", "Cancel", "Stave - Delete Staff") != 0) End;

  off = 0;

  newMusic = (ItemList *)XtMalloc((mstave->staves - 1) * sizeof(ItemList));
  newNames = (String   *)XtMalloc((mstave->staves - 1) * sizeof(String));

  for (i = 0; i < mstave->staves; ++i) {

    if (i == mstave->sweep.stave) { off = 1; continue; }
    newMusic[i - off] = mstave->music[i];
    newNames[i - off] = XtNewString(mstave->names[i]);
  }

  newStave = NewStave(mstave->staves - 1, newMusic);
  
  XtFree((void *)mstave->music);
  StaveDestroy(stave, False);
  memcpy((void *)mstave, (void *)newStave, sizeof(MajorStaveRec));

  for (i = 0; i < mstave->staves; ++i) {
    StaveRenameStave(stave, i, newNames[i]);
    XtFree(newNames[i]);
  }

  XtFree((void *)newNames);

  staveMoved = True;
  StaveRefresh(stave, -1);
  FileMenuMarkChanged(stave, True);

  End;
}



void StaveMenuEmptyStave(Widget w, XtPointer a, XtPointer b)
{
  MajorStaveRec *mstave = (MajorStaveRec *)stave;

  Begin("StaveMenuEmptyStave");

  if (!mstave->sweep.swept) {
    XBell(display, 70);
    End;
  }

  if (!mstave->music[mstave->sweep.stave]) {
    IssueMenuComplaint("This stave is empty anyway.");
    End;
  }

  if (!Next(mstave->music[mstave->sweep.stave])) {
    IssueMenuComplaint("You can't remove the only item in a staff.");
    End;
  }

  if (YQuery(topLevel, "Are you sure you want to empty this whole staff?",
	     2, 1, 1, "Continue", "Cancel", "Stave - Empty Staff") != 0) End;

  mstave->sweep.from.left = NULL;
  mstave->sweep.to.left   = (ItemList)Last(mstave->music[mstave->sweep.stave]);
  mstave->sweep.swept     = True;

  EditMenuDelete(w, a, b);

  staveMoved = True;
  StaveResetFormatting(stave, mstave->sweep.stave);
  StaveRefresh(stave, -1);
  FileMenuMarkChanged(stave, True);

  End;
}

