
/* Musical Notation Editor for X, Chris Cannam 1994 */

#ifndef _MUSIC_ITEMLISTS_
#define _MUSIC_ITEMLISTS_

#include "Lists.h"
#include "Classes.h"

extern ItemList ItemListEnGroup         (GroupTag, ItemList, ItemList);
extern ItemList ItemListUnGroup         (ItemList);
extern ItemList ItemListExpungeGroups   (ItemList, ItemList, ItemList);
extern ItemList ItemListEnsureIntegrity (ItemList);
extern ItemList ItemListAutoBeam        (TimeSignature *, ItemList, ItemList);


/* Define some iterators for use in "for" loops -- use as */
/*      for (ItemList_ITERATE(i, items))       { ... }    */
/* or   for (ItemList_ITERATE_GROUP(i, group)) { ... }    */

/* x is iteration variable, y is list start: */

#define ItemList_ITERATE(x,y) \
             x = (y); x; \
             x = (x)->item->generic.object_class == GroupClass   ? \
                 (ItemList)Next(((Group *)(x)->item)->group.end) : \
                 (ItemList)Next((x))

/* x is iteration variable, y is group pointer: */

#define ItemList_ITERATE_GROUP(x,y) \
             x = (y)->group.start; x; \
             x = (x) == y->group.end ? NULL : \
                 (x)->item->generic.object_class == GroupClass   ? \
                 (ItemList)Next(((Group *)(x)->item)->group.end) : \
                 (ItemList)Next((x))

#endif /* _MUSIC_ITEMLISTS_ */

