
#ifndef _MUSIC_GENERAL_
#define _MUSIC_GENERAL_


/* Non-X libraries */

#include <ctype.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <errno.h>
#include <unistd.h>


/* Vital X libraries */

#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>


#include <Debug.h>
#include <SysDeps.h>


/* Global defines, and functions in Main */

extern Display   *display;
extern Widget     topLevel;
extern Widget     paletteShell;

extern Pixmap     greyMap;
extern Pixmap     lightGreyMap;
extern Pixmap     roseMap;
extern Pixmap     roseMaskMap;
extern Pixmap     upMap;
extern Pixmap     downMap;
extern Pixmap     leftMap;
extern Pixmap     rightMap;
extern Dimension  roseHeight;

extern void Error(String);
extern void QuitNicely(void);
extern void QuitNicelyCallback(Widget, XtPointer, XtPointer);
extern void ChangeTitleBar(String);


/* Dimension defines */

#define DotWidth          4
#define NoteWidth         9
#define NoteHeight        8
#define ClefWidth         24
#define NoteModWidth      7
#define NoteModHeight     14
#define ChordModHeight    7
#define TailWidth         5
#define TailHeight        14
#define StaveHeight       37
#define StaveUpperGap     80
#define StaveLowerGap     40


/* Other defines */

#define ProgramName "Rosegarden"
#define DefaultFont "fixed"


/* Resource type */

typedef struct {
  String    timeSignatureFont;
  String    bigTextFont;
  String    littleTextFont;
  String    tinyTextFont;
  String    italicTextFont;
  String    aboutTextFont;
  String    interlockWindow;
  String    musicDirectory;
  String    midi2texName;
  String    acceleratorTable;
  int       midiBarEmphasis;	/* Added by jpff during an unfinished change */
  Boolean   foundDefaults;
} AppData, *AppDataPtr;

extern AppData appData;


/* Equation and general musical object types */

typedef void *MusicObject;

typedef struct _LineEquationRec {
  int           c;		/* then eqn is "y = mx + c"    */
  double        m;
  Boolean       eqn_present;
  Boolean       reverse;	/* point tail the "wrong" way? */
} LineEquationRec, *LineEquation;


/* Success/failure type */

typedef int Result;

#define Failed    0
#define Succeeded 1


#define STAVE_Y_COORD(x) (StaveHeight-1 - ((x)<0 ? -(NoteHeight/2+1) : 0) - \
			  (((x)/2==((x)+1)/2)? \
			   ((x)/2*(NoteHeight+1)+(NoteHeight/2)): \
			   ((x)/2*(NoteHeight+1)+ NoteHeight)))

/* Blit macro */

extern Boolean oneD;

#define CopyArea(s,d,x,y,w,h,X,Y)  if (oneD) \
   XCopyPlane(display,(s),(d),copyGC,(x),(y),(w),(h),(X),(Y),1L); \
   else XCopyArea(display,(s),(d),copyGC,(x),(y),(w),(h),(X),(Y))


#endif /* _MUSIC_GENERAL_ */

