/* PVTool - Copyright 1996 Richard W.E. Furse */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_COMMAND_LENGTH 1000
#define MAX_FILE_LENGTH 500
#define DOCUMENTATION_FILE "pvtool.txt"
#define LIBRARY_FILE "pv"
#define TOP_OF_CODE "top.x"
#define END_OF_CODE "end.x"
#define NAME_OF_PROG_IN_COMPILE_MODE "pvcom"

#define TRUE 1
#define FALSE 0

/* NB PVTOOL_LIBRARY_DIRECTORY is provided by makefile. */

char * static_version_string = "VERSION: " VERSION_STRING;

int
main (int argc, char *argv[])
{
  char command[MAX_COMMAND_LENGTH], filename[MAX_FILE_LENGTH];
  char temporary_file[L_tmpnam + 2], *bin = NULL;
  char *programName, *cp;
  int i, err = 0, c, run_exe = TRUE, removed_line = TRUE;
  FILE *main_input, *input, *output;

  /* Find out whether to compile or compile/run/delete */
  if (!strcmp (NAME_OF_PROG_IN_COMPILE_MODE, argv[0]))
    {
      /* Run in compiler mode only: */
      if (argc == 3)
	{
	  bin = argv[2];
	  run_exe = FALSE;
	}
      else
	{
	  printf ("Usage:\n\n");
	  printf ("\tpvcom <input control file> <output binary>\n\n");
	  printf ("This converts a pvtool batch file to run slightly ");
	  printf ("faster.\n");
	  err = 1;
	}
    }

  if (!err && argc == 1 && run_exe)
    {
      /* If pvtool has been run without parameters print documentation: */
      sprintf (command,
	       "cat %s%s",
	       PVTOOL_LIBRARY_DIRECTORY, DOCUMENTATION_FILE);
      system (command);
      err = 1;
    }

  if (!err && run_exe)
    {
      /* Name a temporary file to make into an binary: */
      bin = malloc (L_tmpnam);
      if (bin == NULL || tmpnam (bin) == NULL)
	{
	  err = 1;
	  fprintf (stderr, "%s: Failed to name a temporary file\n",
		   argv[0]);
	}
    }

  if (!err)
    {
      /* Assume first parameter is the name of a script. Open it: */
      main_input = fopen (argv[1], "r");
      if (main_input == NULL)
	{
	  err = 1;
	  fprintf (stderr, "%s: Error reading input file %s\n",
		   argv[0],
		   argv[1]);
	}
    }

  if (!err)
    {
      /* If the first line begins #! then skip line: */
      if (fgetc (main_input) == (int) ('#')
	  && fgetc (main_input) == (int) ('!'))
	{
	  while (fgetc (main_input) != '\n')
	    ;
	  removed_line = TRUE;
	}
      else
	{
	  /* Go back to beginning */
	  fseek (main_input, 0, SEEK_SET);
	}
    }

  if (!err)
    {
      /* Name a temporary file to put the C code in: */
      if (tmpnam (temporary_file) == NULL)
	{
	  err = 1;
	  fprintf (stderr, "%s: Failed to name temporary C file\n",
		   argv[0]);
	}
      else
	strcat (temporary_file, ".c");
    }

  if (!err)
    {
      /* Open temporary file for C code: */
      output = fopen (temporary_file, "wb");
      if (output == NULL)
	{
	  err = 1;
	  fprintf (stderr, "%s: Error creating temporary C file\n",
		   argv[0]);
	}
    }

  if (!err)
    {
      /* Read top.c into beginning of temporary C file: */
      strcpy (filename, PVTOOL_LIBRARY_DIRECTORY);
      strcat (filename, TOP_OF_CODE);
      input = fopen (filename, "r");
      if (input == NULL)
	{
	  err = 1;
	  fprintf (stderr, "%s: Error reading pvtool library file %s\n",
		   argv[0],
		   filename);
	}
      else
	{
	  while ((c = fgetc (input)) != EOF)
	    fputc (c, output);
	  fclose (input);
	}
    }

  if (!err)
    {
      /* Paste
	
	 char *programName = "<whatever>";
	 # <new line number>
	
	 into file. The new line number so that compilation errors
	 later will be correct: */
      programName = run_exe ? argv[1] : bin;
      for (cp = programName; *cp != 0; cp++)
	{
	  if (*cp == '/')
	    programName = cp + 1;
	}
      fprintf (output, "char *programName=\"%s\";\n",
	       programName);
      if (!removed_line)
	fprintf (output, "# 1\n");
      else
	fprintf (output, "# 2\n");
    }

  if (!err)
    {
      /* Paste script into temporary C file: */
      while ((c = fgetc (main_input)) != EOF)
	fputc (c, output);
      fclose (main_input);
    }

  if (!err)
    {
      /* Paste end.c on the end of the temporary C file. */
      strcpy (filename, PVTOOL_LIBRARY_DIRECTORY);
      strcat (filename, END_OF_CODE);
      input = fopen (filename, "r");
      if (input == NULL)
	{
	  err = 1;
	  fprintf (stderr, "%s: Error reading pvtool library file %s\n",
		   argv[0],
		   filename);
	}
      else
	{
	  while ((c = fgetc (input)) != EOF)
	    fputc (c, output);
	  fclose (input);
	}
    }

  if (!err)
    {
      /* Close temporary C file, compile it to produce a binary or a
         new temporary binary: */
      fclose (output);
      sprintf (command,
	       "cc %s -o %s -g -L%s -l%s -lm",
	       temporary_file,
	       bin,
	       PVTOOL_LIBRARY_DIRECTORY, LIBRARY_FILE);
      err = system (command);
      if (err != 0)
	fprintf (stderr, "%s: Error compiling\n",
		 argv[0]);
    }

  if (!err)
    {
      /* Remove temporary C file: */
      remove (temporary_file);
    }

  if (!err && run_exe)
    {
      /* Run binary: */
      strcpy (command, bin);
      for (i = 2; i < argc; i++)
	{
	  strcat (command, " ");
	  strcat (command, argv[i]);
	}
      err = system (command);

      if (err)
	fprintf (stderr, "Program returned error level %d.\n", err);

      /* Remove binary: */
      remove (bin);
    }

  return (err);
}
