.TH Perf EMS
.SH NAME
Perf \- invoke Csound audio processing and synthesis 
.SH DESCRIPTION
.PP
\fBperf\fR is a command for passing an orchestra file and score file to
\fBCsound\fR to generate a soundfile.
The score file can be in one of many different formats, according to user
preference.  Translation, sorting, and formatting into orchestra-readable
numeric text is handled by various preprocessors;
all or part of the score is then sent on to the orchestra.
Orchestra performance is also optionally controllable by command flags,
which set the level of output displays, console reports, foreground or
background processing, etc.
.PP
The format of the command is:
.in +3
perf  orchflags  orchname  scoreflags  scorename
.in -3
where the arguments are of 2 types:
\fIflag\fR arguments (beginning with a "-"), and
\fIname\fR arguments (such as filenames).
Certain flag arguments take one or more following name arguments, others none.
Flags may appear either separately or bundled together (all characters
following "-" are flags).
Flags that take a name argument will find them in subsequent arguments,
or (for -d, -m) optionally in the same argument immediately following the flag.
The following are thus equivalent commands:
.in +3
.nf
perf  -b -n -m3 orchname -x xfilename -s scorename
perf  -bnm3 orchname -sx xfilename scorename
.in -3
.fi
.PP
All flags and names are optional, and default settings are supplied as needed.
A \fBperf\fR command normally includes two explicit names:
.in +3
\fIorchname\fR names a file containing Csound orchestra code;  if omitted (or
represented by a dot "."), perf will use the previously preprocessed
orchestra in the current directory (kept as \fIorch.orc\fR).
.br
\fIscorename\fR names a file of musical score data in Scot format or standard
numeric score format; if omitted, perf will use the previously
processed score in the current directory (kept as \fIscore.srt\fR).
.in -3

\fBperf\fR reports on the various stages of score and orchestra processing
as it goes, doing various syntax and error checks along the way.
Once the actual performance has begun, any error messages will derive
from either the instrument loader or the unit generators themselves.

A \fBperf\fR command may include any rational combination of the following
flag arguments:

Orchestra-related flags (-b, -n, -i, -f, -v, -t, -d, -m, -N, -P):

perf -b
.br
Background perf.  Use for large jobs while you run smaller tests in foreground.
A background perf leaves its terminal output in file \fIbperf.out\fR.
There can be at most one background and one foreground
perf running in the same directory.  A disallowed perf will not
hurt those already running.

perf -n
.br
Nosound. Bypass the writing of sound to disk.  This flag does not
change perf in any other way, and is useful for tests, etc.

perf -i
.br
I-time only.  Allocate and initialize all instruments as per the score,
but skip all P-time processing (no k-signals or a-signals, and thus no
amplitudes and no sound).  A very fast check of the validity of your
score pfields and i-variables.

perf -f
.br
Floating point samples in output soundfile.  Overrides the default short
format.  A float file cannot be played, but can be read in by \fBsoundin\fR
and GEN01.

perf -v
.br
Verbose translate and run.  Prints details of orch translation and performance,
enabling errors to be more clearly located.

perf -t
.br
Suppress function table display.  Tables are created but not displayed.

perf -d XX
.br
Display options, with some system dependencies.
.I d1
displays in ascii chars, suitable for any terminal;
.I d2
invokes the Xwindow manager to create a new window for each object,
with pauses between iterations;
.I d3
creates Xwindow displays with no pauses;
.I d4
invokes a high-resolution display (e.g. Starbase for the HP Bobcat,
Regis for a VT125);
.I d0
bypasses all displays.  Default is
.I d1.

perf -m XX
.br
Message level for standard (terminal) output.
Takes the \fIsum\fR of 3 print control flags, turned on
by the following values:
1 = note amplitude messages,  2 = samples out of range message,
4 = warning messages.
The default value is
.I m7
(all messages on).

perf -N sfname
.br
Output soundfile name.
Sound is written into the user soundfile directory (SFDIR) as \fIsfname\fR.
If no name is given, the default name will be \fItest\fR.
If \fIsfname\fR is of the form \fI./name\fR or \fI/path/name\fR,
sound will be written into the current or specified directory.
If SFREMOTE is enabled at Csound installation, and \fIsfname\fR is of the form
\fImachine:/path/name\fR, sound will be written to the remote machine.

perf -P
.br
Orchestra preprocessor.  Input file \fIorchname\fR will be passed through the
\fIcpp\fR C-preprocessor before going on to any performance.


Score-related flags (-s, -x, -P):

perf -s file.scot
.br
Interpret
.I file.scot
as a Scot file, and create a standard score file from it
(then perform the result).

perf -x xfile file.sc
.br
Take
.I file.sc
(or the default
.I score.srt
) and extract a portion of it for performance, according to
.I xfile
(see extract below).

perf -P
.br
Score preprocessor.  Input file \fIscorename\fR will be passed through the
\fIcpp\fR C-preprocessor before going to any other processing.


.SH
The Extract feature:
.PP
This feature will
.B extract
a segment of a
.I "sorted numeric score"
file according to instructions taken from a control file.
The control file contains an instrument list and two time points,
.I from
and
.I to,
in the form:
.in +3
instruments 1 2   from 1:27.5    to 2:2
.in -3
.PP
The component labels may be abbreviated as
.I "i, f"
and
.I t.
The time points denote the begininng and end of the extract in terms of:
.in +3
[section no.] : [beat no.].
.in -3
Each of the three parts is also optional.
The default values for missing
.I "i, f"
or
.I t
are:
.in +3
all instruments,   begining of score,   end of score.
.in -3
.PP
.I extract
reads an orchestra-readable score file and produces an
orchestra-readable result.
Comments, tabs and extra spaces are flushed,
.I w
and
.I a
statements are added and an 
.I f0
reflecting the extract length is appended to the output.
Following an
.I extract
process, the abbreviated score will contain all function table statements,
together with just those note statements that occur in the
.I from-to
interval specified.  Notes lying completely in the interval will be
unmodified;  notes that lie only partly within will their p3 durations
truncated as necessary.

.SH
Independent Preprocessing:
.PP
Although the result of all score preprocessing is retained in the file
.I score.srt
after orchestra performance (it exists as soon as score preprocessing
has completed), the user may sometimes want to run these phases independently.
The command
.in +3
scot  filename
.in -3
will process the
.I Scot
formatted
.I filename,
and leave a
.I "standard numeric score"
result in a file named
.I score
for perusal or later processing.

The command
.in +3
scscort < infile   > outfile
.in -3
will put a numeric score
.I infile
through Carry, Tempo, and Sort preprocessing, leaving the result in
.I outfile.

Likewise
.B extract,
also normally invoked as part of the
.B perf
command, can be invoked as a standalone program:
.in +3
extract xfile < score.sort  > score.extract
.in -3
This command expects an already sorted score.
An unsorted score should first be sent through
.I scsort
then piped to the extract program:
.in +3
scsort < scorefile | extract xfile > score.extract
.in -3
.SH "SEE ALSO"
adsyn(EMS), csound(EMS), hetro(EMS), lpc(EMS),
.I "The Csound Reference Manual"
.SH AUTHOR
.PP
Written by Barry Vercoe at the Experimental Music Studio of the
Media Laboratory at MIT.
