#include <stdio.h>		/*						DISP125.C	*/
#include <signal.h>		/* plot on vt125 screen using ReGis graphics */

#define BDRY  80

catch()
{
	disp125_close();
	printf("\n");
	exit(-1);
}

dsplRgraph(array,n,clabel)		/* enter here, called from display.c */
  float	*array;
  int	n;
  char	*clabel;
{
extern	char *term;

	if (strcmp(term,"vt125"))
		dies("TERM=%s cannot support vt125 option d4", term);
	scroll_alpha();
	signal(SIGINT,catch);
	disp125_open();
	outline_graph();
	plot_regis(array,n,clabel);
	disp125_close();
	signal(SIGINT,SIG_DFL);
}

outline_graph()
{
	int bdry = BDRY;
	char chars[40];
	sprintf(chars,"P[%d,0] V[%d,0] V[%d,%d] V[%d,%d] V[%d,0] ",bdry,767-bdry				,767-bdry,479-bdry,bdry,479-bdry,bdry);
	printf("%s",chars);
}

/*	Put terminal into Regis graphics mode and clear screen		*/

disp125_open()
{
	fprintf(stdout,"\033PpS(E)");
}


/*	Clear screen and take terminal out of Regis graphics mode	*/

disp125_close()
{
	fprintf(stdout,"\033\\");
	fflush(stdout);
}



plot_regis(data,numb,label) 
  float *data;
  int numb;
  char *label;
{
	int bdry;		/* boundary of graph. no top bdry */
	int zero_cross;		/* zero crossing */
	int throw;		/* peak excursion */
	int tnumb;		/* number of target elements */
	int x,y;		/* plotted coordinates */
	int i,index;
	int sideness;
	int labstart;

	float peakabs; 		/* peak value in array */
	float pdata[768-2*BDRY];	/* plotted data */
	float find_peak();
	float incr;

	register float *ptr,*ptrlim = data + numb;
	float max = 0., min = 0.;

	bdry = BDRY;
	tnumb = 767 - 2*bdry;
	incr = (float) numb / tnumb;
	for ( ptr = data ; ptr < ptrlim ; ptr++)
	{
		if (*ptr  > max)
			max = *ptr;
		else 
		{
			if (*ptr < min)
				min = *ptr;
		}
	} 
	if (max > -min)
		peakabs = max;
	else
		peakabs = -min;

	if 	(max == 0)
		sideness = 2;
	else if (min == 0)
		sideness = 1;
	else
		sideness = 0;

	for (i = 0 ; i < tnumb ; i++)
	{
		index = (int) (i * incr);
		pdata[i] = data[index];
	}
	switch (sideness)
	{
		case 0:
			throw =  (int) ((479 - bdry) / 2.);
			zero_cross = 0;
			max = peakabs;
			min = -peakabs;
			break;
		case 1:
			throw = (int) (479 - bdry);
			zero_cross = 0;
			break;
		case 2:
			throw = (int) (479 - bdry);
			zero_cross = - throw;
			break;
	}
	labstart = 383 - (int) ( strlen(label)*9/2);
	printf("P[%d,%d]",labstart,479-bdry+4);
	printf("T '%s'",label);

	printf("P[330,%d]",479-bdry+45);
	printf("T '%d points'",numb);

	printf("P[0,0]");
	printf("T '%5.3f'",max);
	printf("P[0,%d]",479 - bdry - 5);
	printf("T '%5.3f'",min);
	printf("P[%d,%d]",bdry,479 - bdry);
	for ( i = 0 ; i < tnumb ; i++)
	{
		x = i + bdry;
		peakabs = (peakabs == 0.) ? 1. : peakabs;
		y = zero_cross + (int) (throw * (1 - pdata[i] / peakabs)) ; 
		printf("V[%d,%d]",x,y);
	/*	printf("x = %d y = %d\n",x,y); */
	}
}

scroll_alpha()
{
	int i;
	for (i = 0 ; i < 25 ; i++)
		printf("\n");
}
