#include "pitch.h"
#include <sys/soundfile.h>
#include <sys/stat.h>
#include <stdio.h>
#include <math.h>

int LSLICE;
int JSLIDE;
float SR = 14000.;
float NYQ; 
int JMAX;
int MM;
int PCHWORD = 8; /* number of bytes per pchframe */

main()
{
	float sig[350];
	int sigi[350];
	int MIDPOINT;
	float tphi[50][5][18],tpsi[50][6][18];
	float tgamph[50][5],tgamps[50][6];
	float freq[50];   
	float getpch(),getrms(),lowpass();
	float pchlow,pchigh,input[4];
	FILE *pdata;
	int i,n,jj,anal;
	long nsamps,begbyte;
	float data[2],inskip,dur;
        long outskip;
	char name[15];
	char *sigp;
	double rmsm,freqm,rmsx,freqx;
	struct SFDESC sfdesc;
	struct stat stat;
	short *cyllist;
	int sound,nbytes,nblpc,firstframe,nread;

	if((pdata = fopen("pchdata","r")) == NULL) {
		fprintf(stderr, "can't open 'pchdata'\n");
		exit(-1);
	}

	fprintf(stderr,"Enter name of output data file\t");
	gets(name);
	if((anal = open(name,2)) < 0) {
		fprintf(stderr," Can't open data file\n");
		exit(1);
	}

	fprintf(stderr,"Enter name of soundfile to analyze\t");
	gets(name);
	if(sfstat(name,&sfdesc,&stat,&cyllist)) {
		fprintf(stderr," Can't stat file \n");
		exit(1); 
	}

	if(sfdesc.sf_chans != 1) {
		fprintf(stderr," Can only analyze mono file, sorry\n");
		exit(1);
	}

	if(sfdesc.sf_class != INT) {
		fprintf(stderr," Can only analyze integer file\n");
		exit(1);
	}

	if((sound = sfopen(name,READ)) < 0) {
		fprintf(stderr," Can't open sound file\n");
		exit(1);
	}
	fscanf(pdata,"%d %d",&LSLICE,&JSLIDE);
	fscanf(pdata,"%f %f",&pchlow,&pchigh);
	fscanf(pdata,"%f %f",&inskip,&dur);  
	fscanf(pdata,"%d",&firstframe);



	begbyte = inskip * sfdesc.sf_srate * sfdesc.sf_class;
	if(sflseek(sound,begbyte,0) < 0) {
		fprintf(stderr,"Bad sflseek\n");
		exit(1);
	}


	outskip = firstframe * PCHWORD;

	if((lseek(anal,outskip,0)) < 0) {
		fprintf(stderr,"Bad lseek on pitch analysis file\n");
		exit(1);
	}
	NYQ = sfdesc.sf_srate/2.;
        SR = sfdesc.sf_srate;
	JMAX = LSLICE/10;
	MM = ((LSLICE/10+1)/2);
	printf("Reading file %s, sampling rate = %f\n",name,sfdesc.sf_srate);
        printf("Pitch boundaries = %f %f\n",pchlow,pchigh);
        printf("Total samples per analyzed segment = %d\n",LSLICE);
        printf("New samples per analyzed segment = %d\n",JSLIDE);
        printf("Writing starting at output frame %d\n",firstframe);
	MIDPOINT = LSLICE - JSLIDE;
	sigp = (char *)(sigi+MIDPOINT);
	ptable(pchlow,pchigh,tphi,tpsi,tgamph,tgamps,freq,n);   
	if((jj = sfread(sound,(char *)sigi,LSLICE*INT)) != LSLICE * INT) {
		fprintf(stderr,"Bad sfread\n");
		exit(1);
		}
	for(i=0; i<LSLICE; i++) sig[i]=lowpass((float)sigi[i]);   
	nsamps = sfdesc.sf_srate * dur;
	while(nsamps) {
		data[0] = getpch(sig,tphi,tpsi,tgamph,tgamps,freq,n);
		data[1] = getrms(sig);
		write(anal,(char *)data,8);   
		printf("pitch= %f rmsamp= %f\n ",data[0],data[1]);
		for(i=0; i<MIDPOINT; i++)  sig[i] = sig[i+JSLIDE];
		if((jj = sfread(sound,sigp,JSLIDE * INT)) != JSLIDE * INT) {
			fprintf(stderr," bad sfread\n");
			exit(1);
			}
		for(i=MIDPOINT; i<LSLICE; i++) sig[i] = lowpass((float)sigi[i]);  
		nsamps -= JSLIDE; 
	}
}

