>From kw Tue Mar  5 14:01:41 1985 remote from bc-ccm
/* this is a simple program to edit the output of the 
	pitch tracker that Lansky wrote
*/
#include <stdio.h>
#define FLOAT 4

main()
{
        int pchfd, newpchfd,j;
	float pval;
	int firstframe,lastframe,nbframe;
#define ARRSIZ 200
	float vals[ARRSIZ]; /* enough for 46 poles + 4 data values */
	char  input[32]; /* orig file containing pitches & amps */
	char  output[32]; /* new file containing pitches & amps */
	char	answer[10];

	fprintf(stderr," Enter name of pitch data input file\t");
	scanf("%s",input);
	if((pchfd = open(input,0)) < 0) {
		fprintf(stderr," Can't open pitch analysis file\n");
		exit(1);
		}
	fprintf(stderr," Enter name of pitch data output file\t");
	scanf("%s",output);
	if((newpchfd = creat(output,0666)) < 0) {
		fprintf(stderr," Can't create new pitch file\n");
		exit(1);
		}

	nbframe = 2*FLOAT; 
	printf("counting starts at 1\n");
	fprintf(stderr," Enter frame to start edit\t");
	scanf("%d",&firstframe);
	fprintf(stderr," Enter last frame of edit\t");
	scanf("%d",&lastframe);
	if(lastframe < firstframe) {
		printf("pedit: error: last frame less than first.\n");
		exit(1);
		}

	fprintf(stderr," Enter 'r' for replace, 't' for transpose\t");
	scanf("%s",answer);
	fprintf(stderr," Enter pitch factor or pitch value\t");
	scanf("%f", &pval);
	
	printf("first frame is %d, last is %d\n", firstframe, lastframe);
	for(j = 1; j < firstframe; j++) {
		if(read(pchfd, (char *)vals, nbframe) != nbframe) {
			printf(" bad read\n");
			exit(1);
			}	
		if(write(newpchfd, (char *)vals, nbframe) != nbframe){
			printf(" bad write to the new pitch file\n");
			exit(1);
			}
		}

	for(j=firstframe;j<=lastframe;j++) {
		if(read(pchfd,(char *)vals,nbframe) != nbframe) {
			printf(" bad read, at less than lastframe\n");
			exit(1);
			}
		if(!strcmp(answer,"r")) {
			vals[0] = pval;
			}
		else {
			vals[0] *= pval;	
			}
		if(write(newpchfd, (char *)vals, nbframe) != nbframe){
			printf(" bad write to the new pitch file\n");
			exit(1);
			}
		}
	while((j = read(pchfd, vals, ARRSIZ)) > 0)
		if(write(newpchfd, vals, j) < 0)
			printf("bad write of the last values\n");
}

