
#include "track.h"

pchanl(infile,outfile,pchlow,pchigh,startime,endtim)
int infile;
FILE *outfile;
double pchlow,pchigh,startime,endtim;
{
	float sigf[LSLICE],sig[LSLICE];
/* magic numbers */
	float tphi[50][5][8],tpsi[50][6][8];
	float tgamph[50][5],tgamps[50][6];
	float freq[50];
	float getpch(),getrms();
	int m,n;
	int nfr,fr1,fr2,interp,nintr;
	double xintrp,rmsm,freqm,rmsx,freqx;

printf(" In pchanl %f ",startime); 
printf("pchanl: endtim =%f ",endtim);
printf("pchanl: pchigh=%f ",pchigh);
printf("pchanl: pchlow =%f \r\n",pchlow);
	for ( m=0 ; m < LSLICE ; ++m )
	{
		sig[m] = ZERO;
		sigf[m]=ZERO;
	}
	if(startime >= ZERO )
		fr1 = startime*SR/(double) JSLIDE +1.5;
	else
		fr1=1;
	fr2 = endtim*SR/(double) JSLIDE;
	if( pchigh <= TURN2 )
		interp = 2;
	else if ( pchigh <= TURN1 )
		interp = 1;
	else
		interp = 3;
		interp = 1;

	xintrp = (double) interp;
	pchlow *= ONE / xintrp;
	pchigh *= ONE / xintrp;
/* n not set */
	ptable(pchlow,pchigh,tphi,tpsi,tgamph,tgamps,freq,n);
	sflseek(infile,(long) (((JSLIDE-1) * fr1)*SAMPSIZE),0);
	if (fill1(infile,interp,sig,sigf) != ERREXIT)
	{
		for (nfr=fr1 ; nfr <= fr2 ; ++nfr)
		{
			rmsm = ZERO;
			freqm = ZERO;
			for( nintr = 1 ; nintr <= interp ; ++nintr)
			{
				if( fill2(infile,interp,sig,sigf) != ERREXIT)
				{
					freqx = getpch(sigf,tphi,tpsi,tgamph,tgamps,freq,n);
					rmsx = getrms(sig);
					freqm += freqx;
					rmsm += rmsx;
	printf("Frame %d amp = %f pch = %f\n ",nfr,rmsm,freqm);
					fprintf(outfile,"%f %f\n",rmsm,freqm);
				}
				else
				{
					printf(" \rCame to End of File on input\n");
					return;
				}
			}
		}
	}
	else
	{
		printf(" \rCame to End of File on input\n");
		return;
	}
}
