#include "track.h"
main()
{
/* Interactive input for pitch analysis program */
	int sfptr;
	FILE *outfile;
	char infname[NAMESIZ],outfname[NAMESIZ];
	double startime,endtim,pchlow,pchigh;

	setbuf(stdout, NULL);
	setbuf(stderr, NULL);
	fprintf(stdout,"	PITCH ANALYSIS PROGRAM\n\n");
	fprintf(stdout,"Enter the name of the sound file to be analyzed: ");
	scanf("%s",infname);
	if(!strcmp(infname,"end") || !strcmp(infname,""))
	{
		fprintf(stdout,"End of program.\n");
		exit(0);
	}

	if ((sfptr=sfopen(infname,READ)) == SF_OPERR)
	{
		fprintf(stderr,"ptrack: main: error opening sound file \"%s\"\n",infname);
		exit(0);
	}
	fprintf(stdout,"\nEnter the name of the file to contain the analysis:");
	scanf("%s",outfname);
	if((outfile=fopen(outfname,"w")) == NULL)
	{
		fprintf(stderr,"ptrack: main: error opening output file \"%s\"\n",outfname);
		exit(0);
	}
	fprintf(stdout,"\nEnter the highest frequency to be encountered in the soundfile:");
	scanf("%f",&pchigh);
	printf("%f",pchigh);
	fprintf(stdout,"\nEnter the lowest frequency to be encountered in the soundfile:");
	scanf("%f",&pchlow);
	fprintf(stdout,"\nEnter time point in soundfile to begin pitch tracking(seconds):");
	scanf("%f",&startime);
	fprintf(stdout,"\nEnter time point in soundfile to end pitch tracking(seconds):");
	scanf("%f",&endtim);
	fprintf(stdout,"Commencing to track pitch and amplitude of file \"%s\"\n",infname);
	fprintf(stdout,"\tfrom %f seconds to %f seconds\n",startime,endtim);
	fprintf(stdout,"\tEstimated frequency range %f Hz to %f Hz\n",pchlow,pchigh);
	fprintf(stdout,"\tThe results will be placed in file \"%s\"\n",outfname);
	pchanl(sfptr,outfile,pchlow,pchigh,startime,endtim);
	sfclose(sfptr);
	fclose(outfile);
	fprintf(stdout,"\nEnd of pitch analysis program.\n");
	return(1);
}
