;====================================================================;
;                       Sample Orchestra #3                          ;
;====================================================================;
       sr      =       22050
       kr      =       2205
       ksmps   =       10
       nchnls  =       2

;====================================================================;
;                    Portamento/Panning Instrument                   ;               
;                                                                    ;
; p4=amp  p5=pch p6=portsize (oct)  p7=delay  p8=ofn  p9=p3 in beats ; 
;====================================================================;

               instr   1,2,3,4
   ipitch      =       octpch(p5)                 ;center pitch in oct
   itempo      =       p3/p9                      ;ratio seconds/beats
   idelay      =       p7*itempo                  ;cnvt beats to secs
   iport       =       p6                         ;p6 in oct
   ilfn        =       (iport > 0 ? 4 : 5)        ;fn 4 = 1/4 sine
   irfn        =       (iport > 0 ? 5 : 4)        ;fn 5 = 1/4 cos

   kport       init    0                          ;initialize kvars
   kleft       init    .707                       ;sqrt(.5) for mono
   kright      init    .707  
 
               if      (iport == 0) goto continue ;skip if not needed

   kport       oscil1i  idelay,iport,p3-idelay,2  ;fn 2 is linear ramp
   kleft       oscil1i  idelay,1,p3-idelay,ilfn  
   kright      oscil1i  idelay,1,p3-idelay,irfn

continue:
   kgate       envlpx  p4,p3*.1,p3,p3/4,3,1,.01   ;fn 3 is exponential
  
   asig        oscili  kgate,cpsoct(ipitch+kport),p8
               outs    asig*kleft,asig*kright     ;panning
               endin

 ;=========================================================================;
 ;                 Simple Gating Instrument with Chorus                    ;
 ;                                                                         ;
 ; p4=amp      p5=pch1       p6=pch2       p7=risefac      p8=decfac       ;
 ; p9=ofn1    p10=ofn2      p11=gatefn    p12=beathz      p13=gatehz       ;  
 ;=========================================================================;
                 instr   5,6,7,8

   igatehz      =       (p13 == 0 ? 1/p3 : p13)   ;default to once per note
   ihalfamp     =       p4/2
   ipitch1      =       cpspch(p5)
   ipitch2      =       cpspch(p6)
   ibeatfreq    =       p12     
   idetune2     =       ipitch2 + ibeatfreq

   kgate        oscili  1,igatehz,p11            ;p11 has gating control fn#
   kenvlp       linen   1,p3*p7,p3,p3*p8         ;p7,p8 are rise, decay facs

   asig1        oscili  p4,ipitch1,p9            ;sound one
   astraight2   oscili  ihalfamp,ipitch2,p10     ;straight sound two
   adetune2     oscili  ihalfamp,idetune2,p10    ;detuned sound two
   asig2        =       astraight2 + adetune2    ;sound two 

   aout1        =       asig1 * kgate
   aout2        =       asig2 * (1-kgate)
   aoutsig      =       (aout1 + aout2) * kenvlp ;output the sum         
                
                outs    aoutsig,aoutsig
                endin
;==========================================================================;
;               Basic FM Instrument with Variable Vibrato                  ;
;                                                                          ;
;  p4=amp       p5=pch(fund)    p6=vibdel       p7=vibrate      p8=vibwth  ;
;  p9=rise     p10=decay       p11=max index   p12=car fac     p13=mod fac ;
; p14=index rise  p15=index decay  p16=left channel factor p17=original p3 ;
;==========================================================================;
                instr   9,10,11,12
;------------------------------------------------;initialization block:
        kpitch  init    cpspch (p5)     

        itempo  =       p3/p17                   ;ratio seconds/beats
        idelay  =       p6 * itempo              ;convert beats to secs
        irise   =       p9 * itempo
        idecay  =       p10 * itempo
        indxris =       (p14 == 0 ? irise : p14 * itempo)
        indxdec =       (p15 == 0 ? idecay : p15 * itempo)
               
                if      (p16 != 0) igoto panning ;if a panfac, use it, else
        ilfac   =       .707                     ;default is mono (sqrt(.5))
        irfac   =       .707    
                igoto   perform  
panning:        
        ilfac   =       sqrt(p16)        
        irfac   =       sqrt(1-p16)
;------------------------------------------------;performance block:
perform:
                if      (p7 == 0 || p8 == 0) goto continue
        kontrol oscil1  idelay,1,.5,2            ;vib control
        kvib    oscili  p8*kontrol,p7*kontrol,1  ;vibrato unit
        kpitch  =       cpsoct(octpch(p5)+kvib)  ;varying fund pitch in hz
continue:
        kamp    linen   p4,irise,p3,idecay
        kindex  linen   p11,indxris,p3,indxdec
 
        asig    foscili kamp,kpitch,p12,p13,kindex,1  ;p12=carfac,p13=modfac
                outs    asig*ilfac,asig*irfac
                endin
