#include <stdio.h>
#include <ctype.h>
#include "../PvOrig/pvoc.h"

#define READMODE "rb"
#define WRITEMODE "wb+"

static PVSTRUCT tmphdr;

char *programName = "magnitud";

main(argc,argv)
     int argc;char **argv;
{
     PVSTRUCT *pvh;
     char *infilnam;
     int  err,fftFrameSize,yourframes, i,j;
     long offset,off;
     char *cp;
     float *fp;
     long *lp;
     float mag;
     float frqPerBin;
     float treshold;

       fprintf(stdout,"\nThis program displays FFT data per analysis frame _and_");
       fprintf(stdout,"\nonly for channels above a selected minimal magnitude.");

       if (argc != 2) {
                fprintf(stdout,"\n\nUsage: magnitud <analysis.file>\n\n");
                exit(1);
        }
        infilnam = *++argv;

        if ( (err = PVReadFile(infilnam,&pvh)) != 0 ) {
                fprintf(stderr,"error reading was: %d\n",err);
                fprintf(stderr,"-1: couldn't open file\n");
                fprintf(stderr,"-2: not a pvoc.file\n");
                fprintf(stderr,"-3: couldn't allocate memory\n");
                fprintf(stderr,"-4: read error\n");
                exit(1);
        }

        fprintf(stdout,"Succesfull read of: %s\n",infilnam);
        fprintf(stdout,"\n\nDisplaying Headerdata\n\n");
        fprintf(stdout,"dataBsize: data occupies %ld bytes\n",pvh->dataBsize);
        fprintf(stdout,"dataFormat: %ld\n",pvh->dataFormat);
        fprintf(stdout,"minFreq: %6.2f\n",pvh->minFreq);
        fprintf(stdout,"maxFreq: %6.2f\n",pvh->maxFreq);
        fprintf(stdout,"freqFormat, log or lin: %ld\n",pvh->freqFormat);
        fprintf(stdout,"frameFormat: %ld\n",pvh->frameFormat);
        fprintf(stdout,"mono, stereo, quad:   %ld\n",pvh->channels);

        fprintf(stdout,"\tsamplingRate of original audio: %6.0f\n",pvh->samplingRate);
        fprintf(stdout,"\tframeSize: %ld audio samples per frame\n",pvh->frameSize);
        fprintf(stdout,"\tframeIncr: increasing %ld audio samples per frame\n",pvh->frameIncr);

        /* let fp point to the start of data area */
        offset=pvh->headBsize;
        cp = (char *)pvh;   /* let cp point to beginning of allocated memory */
        cp = cp + offset;   /* increment pointer by header size bytes */
        fp = (float *)cp;   /* make it a float pointer now */

        fftFrameSize = pvh->frameSize/2+1;   /* # of complex data locs */
        /* bandwidth of frequency channels, given sr & framesize */
        frqPerBin = (pvh->samplingRate)/pvh->frameSize;

        fprintf(stdout,"frameBsize: Total of %ld frames in this file\n",pvh->dataBsize/pvh->frameBsize);

        fprintf(stdout,"\n\nHow many frames do you want me to display?\n\n");
        scanf("%d",&yourframes);
        printf("\n\nWhat treshold magnitude should I take?\n\n");
        scanf("%f",&treshold);

        printf ("\nYou have chosen %3.2f as treshold.",treshold);
        printf ("\nMagnitudes <= treshold will not be displayed.\n");
        printf("\n\nFrqPerBin is +- %5.2F\n",frqPerBin);

        fprintf(stdout,"\n\t mag\tfreq \n\n");
        for (j=0;j<yourframes;j++)
        {       off = j*fftFrameSize*2;
                fprintf(stdout,"fr %d:",j+1);

                for(i=0;i<fftFrameSize;i++) {
                   mag = *(fp+off+i*2);
                   if ( mag > treshold) {
                        printf("\t%5.2f", mag);
                        printf("\t%5.2f\n",i*frqPerBin); /* analyzed freq */
                   }
                }
                fprintf(stdout,"\n");   /* NL separates the frames */
        }

        fprintf(stdout,"Done: %d frames of file %s\n\n",yourframes,infilnam);
        return(err);
}
