#include <stdio.h>
#include <ctype.h>
#include "../PvOrig/pvoc.h"

#define READMODE "rb"
#define WRITEMODE "wb+"
#define PI 3.14159265358979323846
static PVSTRUCT tmphdr;

char *programName = "channels";


main(argc,argv)
     int argc;char **argv;
{
     PVSTRUCT *pvh; 
     char *infilnam;
     int  err,fftFrameSize,yourframes, i,j;
     long offset,off;
     char *cp;
     float *fp;
     long *lp;
     float bwidth;

	fprintf(stdout,"\nThe program displays FFT data per frequency channel.\n");	

	if (argc != 2) {
	 	fprintf(stderr,"\nUsage: channels <analysis.file>\n\n");	
		exit(1);
	}
	infilnam = *++argv;
	
	if ( (err = PVReadFile(infilnam,&pvh)) != 0 ) {
		fprintf(stderr,"error reading was: %d\n",err);
		fprintf(stderr,"-1: couldn't open file\n");
		fprintf(stderr,"-2: not a pvoc.file\n");
		fprintf(stderr,"-3: couldn't allocate memory\n");
		fprintf(stderr,"-4: read error\n");
		exit(1);
	}
	
 	fprintf(stdout,"Succesfull read of: %s\n",infilnam);	
	fprintf(stdout,"\n\nDisplaying Headerdata\n");
	fprintf(stdout,"dataBsize: data occupies %ld bytes\n",pvh->dataBsize);
	fprintf(stdout,"dataFormat: %ld\n",pvh->dataFormat);
	fprintf(stdout,"samplingRate of original audio: %6.0f\n",pvh->samplingRate);
	fprintf(stdout,"mono, stereo, quad:   %ld\n",pvh->channels);
	fprintf(stdout,"frameSize: %ld audio samples per frame\n",pvh->frameSize);
	fprintf(stdout,"frameIncr: increasing %ld audio samples per frame\n",pvh->frameIncr);
	fprintf(stdout,"frameBsize: %ld frames in this file\n",pvh->dataBsize/pvh->frameBsize);
	fprintf(stdout,"frameFormat: %ld\n",pvh->frameFormat);
	fprintf(stdout,"minFreq: %6.2f\n",pvh->minFreq);
	fprintf(stdout,"maxFreq: %6.2f\n",pvh->maxFreq);
	fprintf(stdout,"freqFormat, log or lin: %ld\n",pvh->freqFormat);

	/* let fp point to the start of data area */	
	offset=pvh->headBsize;
	cp = (char *)pvh;   /* let cp point to beginning of allocated memory */
	cp = cp + offset;   /* increment pointer by header size bytes */
	fp = (float *)cp;   /* make it a float pointer now */  

	fftFrameSize = pvh->frameSize/2+1;   /* # of complex data locs */
	/* bandwidth of frequency channels, given sr & framesize */
	bwidth = (.5*pvh->samplingRate)/(pvh->frameSize/2); 

	fprintf(stdout,"\n\nHow many frames do you want me to display?\n\n");
	scanf("%d",&yourframes);
	
	fprintf(stdout,"\n\tmagnitude\t\t\tfrequency\n\n");
	for (j=0;j<fftFrameSize;j++) /* show each channel */
	{	off = fftFrameSize*2;
		fprintf(stdout,"channel %d:",j+1);
		fprintf(stdout," %5.2f < ",bwidth*(j-1));
		fprintf(stdout,"%5.2f < ",bwidth*j-bwidth/2);
		fprintf(stdout,"%5.2f \n\n",bwidth*j);

		fprintf(stdout,"\tmag\tfreq\n");

		for (i=0;i<yourframes;i++) {
	    	   fprintf(stdout,"\t%-5.2f",*(fp+off*i+j*2));
		   fprintf(stdout,"\t%-5.2f\n",*(fp+1+off*i+j*2));
		}
		fprintf(stdout,"\n");   /* NL separates the frames */
	}  
	
	fprintf(stdout,"Done: %d frames of file %s\n\n",yourframes,infilnam);
	return(err);
}
