#include <math.h>

/*
 * 3D transformations are done around (0,0,0) in ndc space; c =
 * (cx,cy,cz) is center of transformation in world coordinates C =
 * (CX,CY,CZ) is corresponding point in ndc space; transform P =
 * (x,y,z,) to P' = (x',y',z') according to P' = R X ( P - C ) + C,
 * where R is 3D rotation matrix and P and C are point vectors,
 * taking scaling and linear translations into account
 */
xfm3( seg, cx, cy, cz, sx, sy, sz, ax, ay, az, tx, ty, tz )
 int seg ; float cx, cy, cz, sx, sy, sz, ax, ay, az, tx, ty, tz ;
{
 float rotz[3][3], roty[3][3], rotx[3][3], rotxy[3][3], rotxyz[3][3] ;
 float svec[3], ovec[3], t[3] ;
 float CX, CY, CZ ;
 int i, j, k ;
    map_world_to_ndc_3( cx, cy, cz, &CX, &CY, &CZ ) ;
/*
 * svec is scaled, mapped center point vector
 */
    svec[0] = sx*CX ; svec[1] = sy*CY ; svec[2] = sz*CZ ;
/*
 * ovec is specified output translation plus mapped center point
 */
    ovec[0] = tx+CX ; ovec[1] = ty+CY ; ovec[2] = tz+CZ ;
/*
 * clear rotation component matrices
 */
    for ( i = 0 ; i < 3 ; i++ )
	for ( j = 0 ; j < 3 ; j++ )
	    rotx[i][j] = roty[i][j] = rotz[i][j] = 0. ;
/*
 *                x  y  z      Z:         Y:           X:
 *    3D      x' 00 10 20  CZ -SZ  0   CY  0 -SY    1   0   0
 * rotation   y' 01 11 21  SZ  CZ  0    0  1   0    0  CX  SX
 * matrices:  z' 02 12 22   0   0  1   SY  0  CY    0 -SX  CX
 */
    rotz[2][2] = 1. ; rotz[0][0] = rotz[1][1] = cos( (double) az ) ;
    rotz[0][1] = sin( (double) az ) ; rotz[1][0] = -rotz[0][1] ;
    roty[1][1] = 1. ; roty[0][0] = roty[2][2] = cos( (double) ay ) ;
    roty[0][2] = sin( (double) ay ) ; roty[2][0] = -roty[0][2] ;
    rotx[0][0] = 1. ; rotx[1][1] = rotx[2][2] = cos( (double) ax ) ;
    rotx[2][1] = sin( (double) ax ) ; rotx[1][2] = -rotx[2][1] ;
/*
 * rotxy = rotx X roty
 */
    for ( i = 0 ; i < 3 ; i++ )
	for ( j = 0 ; j < 3 ; j++ )
	    for ( rotxy[j][i] = k = 0 ; k < 3 ; k++ )
		rotxy[j][i] += rotx[j][k]*roty[k][i] ;
/*
 * rotxyz (final rotation matrix) = rotxy X rotz
 */
    for ( i = 0 ; i < 3 ; i++ )
	for ( j = 0 ; j < 3 ; j++ )
	    for ( rotxyz[j][i] = k = 0 ; k < 3 ; k++ )
		rotxyz[j][i] += rotxy[j][k]*rotz[k][i] ;
/*
 * scale by svec (mapped, scaled center point)
 */
    for ( i = 0 ; i < 3 ; i++ )
	for ( j = 0 ; j < 3 ; j++ )
	    rotxyz[j][i] *= svec[j] ;
/*
 * sum rows into translation vector
 */
    for ( i = 0 ; i < 3 ; i++ )
	for ( t[i] = j = 0 ; j < 3 ; j++ )
	    t[i] += rotxyz[j][i] ;
/*
 * correct ovec by t to get final translation
 */
    for ( i = 0 ; i < 3 ; i++ )
	t[i] = ovec[i] - t[i] ;
/*
 * perform transformation in ndc space
 */
    set_segment_image_transformation_3( seg,
	sx, sy, sz, ax, ay, az, t[0], t[1], t[2] ) ;
}
